/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.config;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigEntry<T> {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigEntry.class);
    private String key;
    private List<String> alternatives;
    private T defaultValue;
    private Function<String, T> valueConverter;
    private Function<T, String> stringConverter;
    private String doc;
    private String version;
    private boolean isPublic;
    private boolean isDeprecated;
    private boolean isOptional;
    private boolean hasNoDefault;
    private Consumer<T> validator;

    ConfigEntry(String key, String version, String doc, List<String> alternatives, boolean isPublic, boolean isDeprecated) {
        this.key = key;
        this.version = version;
        this.doc = doc;
        this.alternatives = alternatives;
        this.isPublic = isPublic;
        this.isDeprecated = isDeprecated;
        this.isOptional = false;
    }

    void setValueConverter(Function<String, T> valueConverter) {
        this.valueConverter = valueConverter;
    }

    void setStringConverter(Function<T, String> stringConverter) {
        this.stringConverter = stringConverter;
    }

    void setDefaultValue(T t) {
        this.defaultValue = t;
    }

    void setOptional() {
        this.isOptional = true;
    }

    void setHasNoDefault() {
        this.hasNoDefault = true;
    }

    void setValidator(Consumer<T> validator) {
        this.validator = validator;
    }

    public ConfigEntry<T> checkValue(Function<T, Boolean> checkValueFunc, String errorMsg) {
        this.setValidator(value -> {
            if (!((Boolean)checkValueFunc.apply(value)).booleanValue()) {
                throw new IllegalArgumentException(String.format("%s in %s is invalid. %s", this.stringConverter.apply(value), this.key, errorMsg));
            }
        });
        return this;
    }

    public List<T> strToSeq(String str, Function<String, T> converter) {
        List<String> strList = Arrays.asList(str.split(","));
        List valList = strList.stream().map(converter).collect(Collectors.toList());
        return valList;
    }

    public String seqToStr(List<T> seq, Function<T, String> converter) {
        List valList = seq.stream().map(converter).collect(Collectors.toList());
        String str = String.join((CharSequence)",", valList);
        return str;
    }

    public ConfigEntry<List<T>> toSequence() {
        ConfigEntry<List<List>> conf = new ConfigEntry<List<List>>(this.key, this.version, this.doc, this.alternatives, this.isPublic, this.isDeprecated);
        Function<String, Object> elementConverter = this.validator == null ? this.valueConverter : value -> {
            if (value == null) {
                this.validator.accept(null);
            }
            T convertedValue = this.valueConverter.apply((String)value);
            this.validator.accept(convertedValue);
            return convertedValue;
        };
        conf.setValueConverter(str -> this.strToSeq((String)str, (Function<String, T>)elementConverter));
        conf.setStringConverter(val -> val == null ? null : this.seqToStr((List<T>)val, this.stringConverter));
        return conf;
    }

    public ConfigEntry<T> createWithDefault(T t) {
        ConfigEntry<T> conf = new ConfigEntry<T>(this.key, this.version, this.doc, this.alternatives, this.isPublic, this.isDeprecated);
        conf.setValueConverter(this.valueConverter);
        conf.setStringConverter(this.stringConverter);
        conf.setDefaultValue(t);
        conf.setValidator(this.validator);
        return conf;
    }

    public ConfigEntry<Optional<T>> createWithOptional() {
        ConfigEntry<Optional<Optional>> conf = new ConfigEntry<Optional<Optional>>(this.key, this.version, this.doc, this.alternatives, this.isPublic, this.isDeprecated);
        conf.setValueConverter(s -> Optional.ofNullable(this.valueConverter.apply((String)s)));
        conf.setStringConverter(t -> t.map(this.stringConverter).orElse(null));
        conf.setOptional();
        conf.setValidator(optionValue -> {
            if (Stream.of(Optional.ofNullable(this.validator), optionValue).allMatch(Optional::isPresent)) {
                this.validator.accept(optionValue.get());
            }
        });
        return conf;
    }

    public ConfigEntry<T> create() {
        ConfigEntry<T> conf = new ConfigEntry<T>(this.key, this.version, this.doc, this.alternatives, this.isPublic, this.isDeprecated);
        conf.setValueConverter(this.valueConverter);
        conf.setStringConverter(this.stringConverter);
        conf.setHasNoDefault();
        conf.setValidator(this.validator);
        return conf;
    }

    public T readFrom(Map<String, String> properties) throws NoSuchElementException {
        String value = properties.get(this.key);
        if (value == null) {
            String alternative;
            Iterator<String> iterator = this.alternatives.iterator();
            while (iterator.hasNext() && (value = properties.get(alternative = iterator.next())) == null) {
            }
        }
        if (value == null) {
            if (this.defaultValue != null) {
                return this.defaultValue;
            }
            if (this.hasNoDefault) {
                if (this.validator != null) {
                    this.validator.accept(null);
                }
                return null;
            }
            if (!this.isOptional) {
                throw new NoSuchElementException("No configuration found for key " + this.key);
            }
        }
        T convertedValue = this.valueConverter.apply(value);
        if (this.validator != null) {
            this.validator.accept(convertedValue);
        }
        return convertedValue;
    }

    public void writeTo(Map<String, String> properties, T value) {
        String stringValue = this.stringConverter.apply(value);
        if (stringValue == null) {
            LOG.warn("Config {} value to set is null, ignore setting to Config.", (Object)stringValue);
            return;
        }
        properties.put(this.key, stringValue);
    }

    public String getKey() {
        return this.key;
    }

    public List<String> getAlternatives() {
        return this.alternatives;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public String getDoc() {
        return this.doc;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public boolean isDeprecated() {
        return this.isDeprecated;
    }
}

