/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog;

import java.time.Instant;
import java.util.Arrays;
import java.util.Map;
import org.apache.gravitino.Entity;
import org.apache.gravitino.EntityStore;
import org.apache.gravitino.GravitinoEnv;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.StringIdentifier;
import org.apache.gravitino.catalog.CapabilityHelpers;
import org.apache.gravitino.catalog.CatalogManager;
import org.apache.gravitino.catalog.EntityCombinedTable;
import org.apache.gravitino.catalog.OperationDispatcher;
import org.apache.gravitino.catalog.PropertiesMetadataHelpers;
import org.apache.gravitino.catalog.SchemaDispatcher;
import org.apache.gravitino.catalog.TableDispatcher;
import org.apache.gravitino.connector.HasPropertyMetadata;
import org.apache.gravitino.connector.capability.Capability;
import org.apache.gravitino.exceptions.NoSuchEntityException;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.exceptions.NoSuchTableException;
import org.apache.gravitino.exceptions.TableAlreadyExistsException;
import org.apache.gravitino.lock.LockType;
import org.apache.gravitino.lock.TreeLockUtils;
import org.apache.gravitino.meta.AuditInfo;
import org.apache.gravitino.meta.TableEntity;
import org.apache.gravitino.rel.Column;
import org.apache.gravitino.rel.Table;
import org.apache.gravitino.rel.TableChange;
import org.apache.gravitino.rel.expressions.distributions.Distribution;
import org.apache.gravitino.rel.expressions.distributions.Distributions;
import org.apache.gravitino.rel.expressions.sorts.SortOrder;
import org.apache.gravitino.rel.expressions.transforms.Transform;
import org.apache.gravitino.rel.expressions.transforms.Transforms;
import org.apache.gravitino.rel.indexes.Index;
import org.apache.gravitino.rel.indexes.Indexes;
import org.apache.gravitino.storage.IdGenerator;
import org.apache.gravitino.utils.NameIdentifierUtil;
import org.apache.gravitino.utils.PrincipalUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableOperationDispatcher
extends OperationDispatcher
implements TableDispatcher {
    private static final Logger LOG = LoggerFactory.getLogger(TableOperationDispatcher.class);

    public TableOperationDispatcher(CatalogManager catalogManager, EntityStore store, IdGenerator idGenerator) {
        super(catalogManager, store, idGenerator);
    }

    public NameIdentifier[] listTables(Namespace namespace) throws NoSuchSchemaException {
        return this.doWithCatalog(NameIdentifierUtil.getCatalogIdentifier(NameIdentifier.of((String[])namespace.levels())), c -> c.doWithTableOps(t -> t.listTables(namespace)), NoSuchSchemaException.class);
    }

    public Table loadTable(NameIdentifier ident) throws NoSuchTableException {
        EntityCombinedTable table = TreeLockUtils.doWithTreeLock(ident, LockType.READ, () -> this.internalLoadTable(ident));
        if (!table.imported()) {
            SchemaDispatcher schemaDispatcher = GravitinoEnv.getInstance().schemaDispatcher();
            NameIdentifier schemaIdent = NameIdentifier.of((String[])ident.namespace().levels());
            schemaDispatcher.loadSchema(schemaIdent);
            TreeLockUtils.doWithTreeLock(schemaIdent, LockType.WRITE, () -> {
                this.importTable(ident);
                return null;
            });
        }
        return table;
    }

    public Table createTable(NameIdentifier ident, Column[] columns, String comment, Map<String, String> properties, Transform[] partitions, Distribution distribution, SortOrder[] sortOrders, Index[] indexes) throws NoSuchSchemaException, TableAlreadyExistsException {
        SchemaDispatcher schemaDispatcher = GravitinoEnv.getInstance().schemaDispatcher();
        NameIdentifier schemaIdent = NameIdentifier.of((String[])ident.namespace().levels());
        schemaDispatcher.loadSchema(schemaIdent);
        return TreeLockUtils.doWithTreeLock(NameIdentifier.of((String[])ident.namespace().levels()), LockType.WRITE, () -> this.internalCreateTable(ident, columns, comment, properties, partitions, distribution, sortOrders, indexes));
    }

    public Table alterTable(NameIdentifier ident, TableChange ... changes) throws NoSuchTableException, IllegalArgumentException {
        this.validateAlterProperties(ident, HasPropertyMetadata::tablePropertiesMetadata, changes);
        NameIdentifier catalogIdent = NameIdentifierUtil.getCatalogIdentifier(ident);
        Table tempAlteredTable = this.doWithCatalog(catalogIdent, c -> c.doWithTableOps(t -> t.alterTable(ident, CapabilityHelpers.applyCapabilities(c.capabilities(), changes))), NoSuchTableException.class, IllegalArgumentException.class);
        Table alteredTable = this.doWithCatalog(catalogIdent, c -> c.doWithTableOps(t -> t.loadTable(NameIdentifier.of((Namespace)ident.namespace(), (String)tempAlteredTable.name()))), NoSuchTableException.class);
        StringIdentifier stringId = this.getStringIdFromProperties(alteredTable.properties());
        if (stringId == null) {
            return EntityCombinedTable.of(alteredTable).withHiddenPropertiesSet(this.getHiddenPropertyNames(NameIdentifierUtil.getCatalogIdentifier(ident), HasPropertyMetadata::tablePropertiesMetadata, alteredTable.properties()));
        }
        TableEntity updatedTableEntity = this.operateOnEntity(ident, id -> this.store.update((NameIdentifier)id, TableEntity.class, Entity.EntityType.TABLE, tableEntity -> {
            String newName = Arrays.stream(changes).filter(c -> c instanceof TableChange.RenameTable).map(c -> ((TableChange.RenameTable)c).getNewName()).reduce((c1, c2) -> c2).orElse(tableEntity.name());
            return TableEntity.builder().withId(tableEntity.id()).withName(newName).withNamespace(ident.namespace()).withAuditInfo(AuditInfo.builder().withCreator(tableEntity.auditInfo().creator()).withCreateTime(tableEntity.auditInfo().createTime()).withLastModifier(PrincipalUtils.getCurrentPrincipal().getName()).withLastModifiedTime(Instant.now()).build()).build();
        }), "UPDATE", stringId.id());
        return EntityCombinedTable.of(alteredTable, updatedTableEntity).withHiddenPropertiesSet(this.getHiddenPropertyNames(NameIdentifierUtil.getCatalogIdentifier(ident), HasPropertyMetadata::tablePropertiesMetadata, alteredTable.properties()));
    }

    public boolean dropTable(NameIdentifier ident) {
        NameIdentifier catalogIdent = NameIdentifierUtil.getCatalogIdentifier(ident);
        boolean droppedFromCatalog = this.doWithCatalog(catalogIdent, c -> c.doWithTableOps(t -> t.dropTable(ident)), RuntimeException.class);
        boolean droppedFromStore = false;
        try {
            droppedFromStore = this.store.delete(ident, Entity.EntityType.TABLE);
        }
        catch (NoSuchEntityException e) {
            LOG.warn("The table to be dropped does not exist in the store: {}", (Object)ident, (Object)e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this.isManagedEntity(catalogIdent, Capability.Scope.TABLE) ? droppedFromStore : droppedFromCatalog;
    }

    public boolean purgeTable(NameIdentifier ident) throws UnsupportedOperationException {
        NameIdentifier catalogIdent = NameIdentifierUtil.getCatalogIdentifier(ident);
        boolean droppedFromCatalog = this.doWithCatalog(catalogIdent, c -> c.doWithTableOps(t -> t.purgeTable(ident)), RuntimeException.class, UnsupportedOperationException.class);
        boolean droppedFromStore = false;
        try {
            droppedFromStore = this.store.delete(ident, Entity.EntityType.TABLE);
        }
        catch (NoSuchEntityException e) {
            LOG.warn("The table to be purged does not exist in the store: {}", (Object)ident, (Object)e);
            return false;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this.isManagedEntity(catalogIdent, Capability.Scope.TABLE) ? droppedFromStore : droppedFromCatalog;
    }

    private void importTable(NameIdentifier identifier) {
        long uid;
        EntityCombinedTable table = this.internalLoadTable(identifier);
        if (table.imported()) {
            return;
        }
        StringIdentifier stringId = null;
        try {
            stringId = table.stringIdentifier();
        }
        catch (IllegalArgumentException ie) {
            LOG.warn("Failed to get string identifier from schema properties: {}, this maybe caused by the same-name string identifier is set by the user with unsupported format.", (Object)ie.getMessage());
        }
        if (stringId != null) {
            LOG.warn("The Table uid {} existed but still need to be imported, this could be happened when Table is renamed by external systems not controlled by Gravitino. In this case, we need to overwrite the stored entity to keep the consistency.", (Object)stringId);
            uid = stringId.id();
        } else {
            uid = this.idGenerator.nextId();
        }
        TableEntity tableEntity = TableEntity.builder().withId(uid).withName(identifier.name()).withNamespace(identifier.namespace()).withAuditInfo(AuditInfo.builder().withCreator(table.auditInfo().creator()).withCreateTime(table.auditInfo().createTime()).withLastModifier(table.auditInfo().lastModifier()).withLastModifiedTime(table.auditInfo().lastModifiedTime()).build()).build();
        try {
            this.store.put(tableEntity, true);
        }
        catch (Exception e) {
            LOG.error("Failed to {} entity for {} in Gravitino, with this situation the returned object will not contain the metadata from Gravitino.", new Object[]{"put", identifier, e});
            throw new RuntimeException("Fail to import the table entity to the store.", e);
        }
    }

    private EntityCombinedTable internalLoadTable(NameIdentifier ident) {
        NameIdentifier catalogIdentifier = NameIdentifierUtil.getCatalogIdentifier(ident);
        Table table = this.doWithCatalog(catalogIdentifier, c -> c.doWithTableOps(t -> t.loadTable(ident)), NoSuchTableException.class);
        StringIdentifier stringId = this.getStringIdFromProperties(table.properties());
        if (stringId == null) {
            return EntityCombinedTable.of(table).withHiddenPropertiesSet(this.getHiddenPropertyNames(catalogIdentifier, HasPropertyMetadata::tablePropertiesMetadata, table.properties())).withImported(this.isEntityExist(ident, Entity.EntityType.TABLE));
        }
        TableEntity tableEntity = this.operateOnEntity(ident, identifier -> this.store.get((NameIdentifier)identifier, Entity.EntityType.TABLE, TableEntity.class), "GET", stringId.id());
        return EntityCombinedTable.of(table, tableEntity).withHiddenPropertiesSet(this.getHiddenPropertyNames(catalogIdentifier, HasPropertyMetadata::tablePropertiesMetadata, table.properties())).withImported(tableEntity != null);
    }

    private Table internalCreateTable(NameIdentifier ident, Column[] columns, String comment, Map<String, String> properties, Transform[] partitions, Distribution distribution, SortOrder[] sortOrders, Index[] indexes) {
        NameIdentifier catalogIdent = NameIdentifierUtil.getCatalogIdentifier(ident);
        this.doWithCatalog(catalogIdent, c -> c.doWithPropertiesMeta(p -> {
            PropertiesMetadataHelpers.validatePropertyForCreate(p.tablePropertiesMetadata(), properties);
            return null;
        }), IllegalArgumentException.class);
        long uid = this.idGenerator.nextId();
        StringIdentifier stringId = StringIdentifier.fromId(uid);
        Map<String, String> updatedProperties = StringIdentifier.newPropertiesWithId(stringId, properties);
        this.doWithCatalog(catalogIdent, c -> c.doWithTableOps(t -> t.createTable(ident, columns, comment, updatedProperties, partitions == null ? Transforms.EMPTY_TRANSFORM : partitions, distribution == null ? Distributions.NONE : distribution, sortOrders == null ? new SortOrder[]{} : sortOrders, indexes == null ? Indexes.EMPTY_INDEXES : indexes)), NoSuchSchemaException.class, TableAlreadyExistsException.class);
        TableEntity tableEntity = TableEntity.builder().withId(uid).withName(ident.name()).withNamespace(ident.namespace()).withAuditInfo(AuditInfo.builder().withCreator(PrincipalUtils.getCurrentPrincipal().getName()).withCreateTime(Instant.now()).build()).build();
        Table table = this.doWithCatalog(catalogIdent, c -> c.doWithTableOps(t -> t.loadTable(ident)), NoSuchTableException.class);
        try {
            this.store.put(tableEntity, true);
        }
        catch (Exception e) {
            LOG.error("Failed to {} entity for {} in Gravitino, with this situation the returned object will not contain the metadata from Gravitino.", new Object[]{"put", ident, e});
            return EntityCombinedTable.of(table).withHiddenPropertiesSet(this.getHiddenPropertyNames(catalogIdent, HasPropertyMetadata::tablePropertiesMetadata, table.properties()));
        }
        return EntityCombinedTable.of(table, tableEntity).withHiddenPropertiesSet(this.getHiddenPropertyNames(catalogIdent, HasPropertyMetadata::tablePropertiesMetadata, table.properties()));
    }
}

