/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog;

import org.apache.gravitino.EntityStore;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.catalog.CatalogManager;
import org.apache.gravitino.catalog.OperationDispatcher;
import org.apache.gravitino.catalog.PartitionDispatcher;
import org.apache.gravitino.exceptions.NoSuchPartitionException;
import org.apache.gravitino.exceptions.NoSuchTableException;
import org.apache.gravitino.exceptions.PartitionAlreadyExistsException;
import org.apache.gravitino.rel.SupportsPartitions;
import org.apache.gravitino.rel.partitions.Partition;
import org.apache.gravitino.storage.IdGenerator;

public class PartitionOperationDispatcher
extends OperationDispatcher
implements PartitionDispatcher {
    public PartitionOperationDispatcher(CatalogManager catalogManager, EntityStore store, IdGenerator idGenerator) {
        super(catalogManager, store, idGenerator);
    }

    @Override
    public String[] listPartitionNames(NameIdentifier tableIdent) {
        return this.doWithTable(tableIdent, SupportsPartitions::listPartitionNames, NoSuchTableException.class);
    }

    @Override
    public Partition[] listPartitions(NameIdentifier tableIdent) {
        return this.doWithTable(tableIdent, SupportsPartitions::listPartitions, NoSuchTableException.class);
    }

    @Override
    public Partition getPartition(NameIdentifier tableIdent, String partitionName) throws NoSuchPartitionException {
        return this.doWithTable(tableIdent, p -> p.getPartition(partitionName), NoSuchPartitionException.class);
    }

    @Override
    public Partition addPartition(NameIdentifier tableIdent, Partition partition) throws PartitionAlreadyExistsException {
        return this.doWithTable(tableIdent, p -> p.addPartition(partition), PartitionAlreadyExistsException.class);
    }

    @Override
    public boolean dropPartition(NameIdentifier tableIdent, String partitionName) {
        return this.doWithTable(tableIdent, p -> p.dropPartition(partitionName), NoSuchPartitionException.class);
    }

    @Override
    public boolean purgePartition(NameIdentifier tableIdent, String partitionName) throws UnsupportedOperationException {
        return this.doWithTable(tableIdent, p -> p.purgePartition(partitionName), NoSuchPartitionException.class);
    }
}

