---
id: 'feedback'
title: 'Feedback'
---

We appreciate all the feedback and suggestions you have. If you find any bugs during use, you can submit the issue through the [NEW ISSUE](https://github.com/apache/fesod/issues/new/choose) page.

## Before Submitting

Before creating a new issue, please ensure you have completed the following preparatory steps. This will help avoid duplicate work and save both your time and the maintainers' time.

### Read the Documentation

- Please read the `README` file and the official documentation in the project to see if there are any solutions to the problems mentioned.

### Search Existing Issues

- Visit the [Issue List](https://github.com/apache/fesod/issues) and search for keywords.
- If you find a similar issue, please **comment and provide additional details** under that issue instead of creating a new one.
- If an unresolved issue is closed for some reason, please **comment and provide additional details** to reopen it.

### Update to the latest version

Please make sure you are using the latest stable version of the project or the latest code from the main branch. Many issues have been resolved in newer versions.

## Creating a New Issue

If you confirm that your issue has not been reported, please submit a new issue through the [NEW ISSUE](https://github.com/apache/fesod/issues/new/choose) page.

**Please use the issue template** and provide as much information as possible, such as:

- Environment information (operating system, version used, etc.).
- Steps to reproduce the issue.
- Error logs or screenshots.
- Provide a minimal reproducible example.

The following situations are appropriate for submitting a new issue:

- Bug reports
- New feature
- Performance issues
- Function proposals or design suggestions
- Documentation improvements
- Optimization of test coverage
- Need for technical support
- Other issues related to the project

## Notes

- The title of the issue should be clear and concise, written in **English**, and should be no longer than 50 characters.
- Please use polite language in the issue description and content.
- Each issue should focus on a single topic, please do not combine multiple issues into one.
- Unless a specific developer has been explicitly assigned to the issue in advance, please do not arbitrarily assign it to a particular developer.
- Do not include sensitive information such as passwords, keys, server addresses, or private data in the issue.

Thank you for contributing to the improvement of the project! Every feedback you provide is the driving force behind our progress.
