//---------------------------------------------------------------------------
//	Greenplum Database
//	Copyright (C) 2013 VMware, Inc. or its affiliates.
//
//	@filename:
//		CParseHandlerLogicalForeignGet.cpp
//
//	@doc:
//		Implementation of the SAX parse handler class for parsing logical foreign get
//---------------------------------------------------------------------------

#include "naucrates/dxl/parser/CParseHandlerLogicalForeignGet.h"

#include "naucrates/dxl/parser/CParseHandlerFactory.h"

using namespace gpdxl;


XERCES_CPP_NAMESPACE_USE

//---------------------------------------------------------------------------
//	@function:
//		CParseHandlerLogicalForeignGet::CParseHandlerLogicalForeignGet
//
//	@doc:
//		Ctor
//
//---------------------------------------------------------------------------
CParseHandlerLogicalForeignGet::CParseHandlerLogicalForeignGet(
	CMemoryPool *mp, CParseHandlerManager *parse_handler_mgr,
	CParseHandlerBase *parse_handler_root)
	: CParseHandlerLogicalGet(mp, parse_handler_mgr, parse_handler_root)
{
}

//---------------------------------------------------------------------------
//	@function:
//		CParseHandlerLogicalGet::StartElement
//
//	@doc:
//		Invoked by Xerces to process an opening tag
//
//---------------------------------------------------------------------------
void
CParseHandlerLogicalForeignGet::StartElement(
	const XMLCh *const,	 // element_uri,
	const XMLCh *const element_local_name,
	const XMLCh *const,		// element_qname
	const Attributes &attr	//attrs
)
{
	CParseHandlerLogicalGet::StartElement(element_local_name,
										  EdxltokenLogicalForeignGet, attr);
}

//---------------------------------------------------------------------------
//	@function:
//		CParseHandlerLogicalGet::EndElement
//
//	@doc:
//		Invoked by Xerces to process a closing tag
//
//---------------------------------------------------------------------------
void
CParseHandlerLogicalForeignGet::EndElement(
	const XMLCh *const,	 // element_uri,
	const XMLCh *const element_local_name,
	const XMLCh *const	// element_qname
)
{
	CParseHandlerLogicalGet::EndElement(element_local_name,
										EdxltokenLogicalForeignGet);
}

// EOF
