/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.inbox.store;

import java.util.concurrent.atomic.LongAdder;
import java.util.function.Supplier;
import org.apache.bifromq.metrics.ITenantMeter;
import org.apache.bifromq.metrics.TenantMetric;

class TenantStats {
    private final LongAdder sessionCount = new LongAdder();
    private final LongAdder subCount = new LongAdder();
    private final String tenantId;
    private final String[] tags;
    private boolean isLeader;

    TenantStats(String tenantId, Supplier<Number> usedSpaceGetter, String ... tagValuePair) {
        this.tenantId = tenantId;
        this.tags = tagValuePair;
        ITenantMeter.gauging((String)tenantId, (TenantMetric)TenantMetric.MqttPersistentSessionSpaceGauge, usedSpaceGetter, (String[])this.tags);
    }

    public void addSessionCount(int delta) {
        this.sessionCount.add(delta);
    }

    public void addSubCount(int delta) {
        this.subCount.add(delta);
    }

    boolean isNoSession() {
        return this.sessionCount.sum() == 0L;
    }

    void toggleMetering(boolean isLeader) {
        if (!this.isLeader && isLeader) {
            ITenantMeter.gauging((String)this.tenantId, (TenantMetric)TenantMetric.MqttPersistentSubCountGauge, this.subCount::sum, (String[])this.tags);
            ITenantMeter.gauging((String)this.tenantId, (TenantMetric)TenantMetric.MqttPersistentSessionNumGauge, this.sessionCount::sum, (String[])this.tags);
            this.isLeader = true;
        } else if (this.isLeader && !isLeader) {
            ITenantMeter.stopGauging((String)this.tenantId, (TenantMetric)TenantMetric.MqttPersistentSubCountGauge, (String[])this.tags);
            ITenantMeter.stopGauging((String)this.tenantId, (TenantMetric)TenantMetric.MqttPersistentSessionNumGauge, (String[])this.tags);
            this.isLeader = false;
        }
    }

    void destroy() {
        ITenantMeter.stopGauging((String)this.tenantId, (TenantMetric)TenantMetric.MqttPersistentSubCountGauge, (String[])this.tags);
        ITenantMeter.stopGauging((String)this.tenantId, (TenantMetric)TenantMetric.MqttPersistentSessionNumGauge, (String[])this.tags);
        ITenantMeter.stopGauging((String)this.tenantId, (TenantMetric)TenantMetric.MqttPersistentSessionSpaceGauge, (String[])this.tags);
    }
}

