/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.mqtt.handler;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.mqtt.MqttConnectMessage;
import io.netty.handler.codec.mqtt.MqttConnectReturnCode;
import io.netty.handler.codec.mqtt.MqttConnectVariableHeader;
import io.netty.handler.codec.mqtt.MqttIdentifierRejectedException;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageBuilders;
import io.netty.handler.codec.mqtt.MqttMessageType;
import io.netty.handler.codec.mqtt.MqttPublishMessage;
import io.netty.handler.codec.mqtt.MqttUnacceptableProtocolVersionException;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.bifromq.mqtt.handler.ChannelAttrs;
import org.apache.bifromq.mqtt.handler.v3.MQTT3ConnectHandler;
import org.apache.bifromq.mqtt.handler.v5.MQTT5ConnectHandler;
import org.apache.bifromq.mqtt.handler.v5.MQTT5MessageBuilders;
import org.apache.bifromq.plugin.eventcollector.Event;
import org.apache.bifromq.plugin.eventcollector.IEventCollector;
import org.apache.bifromq.plugin.eventcollector.ThreadLocalEventPool;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.channelclosed.ChannelError;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.channelclosed.ConnectTimeout;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.channelclosed.IdentifierRejected;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.channelclosed.ProtocolError;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.channelclosed.UnacceptedProtocolVer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MQTTPreludeHandler
extends ChannelDuplexHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MQTTPreludeHandler.class);
    public static final String NAME = "MqttPreludeHandler";
    private final long timeoutInSec;
    private ChannelHandlerContext ctx;
    private IEventCollector eventCollector;
    private InetSocketAddress remoteAddr;
    private ScheduledFuture<?> timeoutCloseTask;
    private ScheduledFuture<?> closeConnectionTask;

    public MQTTPreludeHandler(int timeoutInSec) {
        this.timeoutInSec = timeoutInSec;
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        this.ctx = ctx;
        this.eventCollector = ChannelAttrs.mqttSessionContext((ChannelHandlerContext)ctx).eventCollector;
        this.remoteAddr = ChannelAttrs.socketAddress(ctx.channel());
        this.timeoutCloseTask = ctx.executor().schedule(() -> {
            this.eventCollector.report((Event)((ConnectTimeout)ThreadLocalEventPool.getLocal(ConnectTimeout.class)).peerAddress(this.remoteAddr));
            ctx.channel().close();
        }, this.timeoutInSec, TimeUnit.SECONDS);
    }

    public void handlerRemoved(ChannelHandlerContext ctx) {
        if (this.timeoutCloseTask != null) {
            this.timeoutCloseTask.cancel(true);
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        if (this.timeoutCloseTask != null) {
            this.timeoutCloseTask.cancel(true);
        }
        ctx.fireChannelInactive();
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        assert (msg instanceof MqttMessage);
        ctx.channel().config().setAutoRead(false);
        this.timeoutCloseTask.cancel(true);
        MqttMessage message = (MqttMessage)msg;
        if (!message.decoderResult().isSuccess()) {
            Throwable cause = message.decoderResult().cause();
            if (cause instanceof MqttUnacceptableProtocolVersionException) {
                this.closeChannelWithRandomDelay((Event<?>)((UnacceptedProtocolVer)ThreadLocalEventPool.getLocal(UnacceptedProtocolVer.class)).peerAddress(this.remoteAddr));
                return;
            }
            if (message.fixedHeader() != null && message.fixedHeader().messageType() != MqttMessageType.CONNECT) {
                this.closeChannelWithRandomDelay((Event<?>)((ProtocolError)((ProtocolError)ThreadLocalEventPool.getLocal(ProtocolError.class)).peerAddress(this.remoteAddr)).statement("MQTT-3.1.0-1"));
                return;
            }
            Object object = message.variableHeader();
            if (object instanceof MqttConnectVariableHeader) {
                MqttConnectVariableHeader connVarHeader = (MqttConnectVariableHeader)object;
                switch (connVarHeader.version()) {
                    case 3: 
                    case 4: {
                        if (cause instanceof TooLongFrameException) {
                            this.closeChannelWithRandomDelay((Event<?>)((ProtocolError)ThreadLocalEventPool.getLocal(ProtocolError.class)).statement("Too large packet").peerAddress(this.remoteAddr));
                        } else if (cause instanceof MqttIdentifierRejectedException) {
                            this.closeChannelWithRandomDelay((Event<?>)((IdentifierRejected)ThreadLocalEventPool.getLocal(IdentifierRejected.class)).peerAddress(this.remoteAddr), (MqttMessage)MqttMessageBuilders.connAck().returnCode(MqttConnectReturnCode.CONNECTION_REFUSED_IDENTIFIER_REJECTED).build());
                        } else {
                            this.closeChannelWithRandomDelay((Event<?>)((ProtocolError)((ProtocolError)ThreadLocalEventPool.getLocal(ProtocolError.class)).peerAddress(this.remoteAddr)).statement("MQTT3-4.8.0-2"));
                        }
                        return;
                    }
                }
                if (cause instanceof TooLongFrameException) {
                    this.closeChannelWithRandomDelay((Event<?>)((ProtocolError)ThreadLocalEventPool.getLocal(ProtocolError.class)).statement("Too large packet").peerAddress(this.remoteAddr), (MqttMessage)MqttMessageBuilders.connAck().properties(MQTT5MessageBuilders.connAckProperties().reasonString(cause.getMessage()).build()).returnCode(MqttConnectReturnCode.CONNECTION_REFUSED_PACKET_TOO_LARGE).build());
                } else if (cause instanceof MqttIdentifierRejectedException) {
                    this.closeChannelWithRandomDelay((Event<?>)((IdentifierRejected)ThreadLocalEventPool.getLocal(IdentifierRejected.class)).peerAddress(this.remoteAddr), (MqttMessage)MqttMessageBuilders.connAck().properties(MQTT5MessageBuilders.connAckProperties().reasonString(cause.getMessage()).build()).returnCode(MqttConnectReturnCode.CONNECTION_REFUSED_CLIENT_IDENTIFIER_NOT_VALID).build());
                } else {
                    this.closeChannelWithRandomDelay((Event<?>)((ProtocolError)((ProtocolError)ThreadLocalEventPool.getLocal(ProtocolError.class)).peerAddress(this.remoteAddr)).statement("MQTT5-4.13.1-1"), (MqttMessage)MqttMessageBuilders.connAck().properties(MQTT5MessageBuilders.connAckProperties().reasonString(cause.getMessage()).build()).returnCode(MqttConnectReturnCode.CONNECTION_REFUSED_MALFORMED_PACKET).build());
                }
                return;
            }
            this.closeChannelWithRandomDelay((Event<?>)((ProtocolError)((ProtocolError)ThreadLocalEventPool.getLocal(ProtocolError.class)).peerAddress(this.remoteAddr)).statement(cause.getMessage()));
            return;
        }
        if (message.fixedHeader().messageType() != MqttMessageType.CONNECT) {
            if (message.fixedHeader().messageType() == MqttMessageType.PUBLISH) {
                ((MqttPublishMessage)message).release();
            }
            this.closeChannelWithRandomDelay((Event<?>)((ProtocolError)ThreadLocalEventPool.getLocal(ProtocolError.class)).statement("MQTT-3.1.0-1"));
            log.debug("First packet must be mqtt connect message: remote={}", (Object)this.remoteAddr);
            return;
        }
        MqttConnectMessage connectMessage = (MqttConnectMessage)message;
        switch (connectMessage.variableHeader().version()) {
            case 3: 
            case 4: {
                ctx.pipeline().addAfter((EventExecutorGroup)ctx.executor(), NAME, "MQTT3ConnectHandler", (ChannelHandler)new MQTT3ConnectHandler());
                ctx.fireChannelRead((Object)connectMessage);
                ctx.pipeline().remove((ChannelHandler)this);
                break;
            }
            case 5: {
                ctx.pipeline().addAfter((EventExecutorGroup)ctx.executor(), NAME, "MQTT5ConnectHandler", (ChannelHandler)new MQTT5ConnectHandler());
                ctx.fireChannelRead((Object)connectMessage);
                ctx.pipeline().remove((ChannelHandler)this);
                break;
            }
            default: {
                log.debug("Unsupported protocol version: {}", (Object)connectMessage.variableHeader().version());
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        log.debug("ctx: {}, cause:", (Object)ctx, (Object)cause);
        this.eventCollector.report((Event)((ChannelError)((ChannelError)ThreadLocalEventPool.getLocal(ChannelError.class)).peerAddress(this.remoteAddr)).cause(cause));
        ctx.channel().close();
    }

    private void closeChannelWithRandomDelay(Event<?> reason) {
        this.closeChannelWithRandomDelay(reason, null);
    }

    private void closeChannelWithRandomDelay(Event<?> reason, MqttMessage farewell) {
        if (this.timeoutCloseTask != null) {
            this.timeoutCloseTask.cancel(true);
        }
        this.eventCollector.report(reason);
        assert (this.closeConnectionTask == null);
        this.closeConnectionTask = this.ctx.executor().schedule(() -> {
            if (!this.ctx.channel().isActive()) {
                return;
            }
            if (farewell != null) {
                this.ctx.writeAndFlush((Object)farewell).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            } else {
                this.ctx.channel().close();
            }
        }, (long)ThreadLocalRandom.current().nextInt(5000), TimeUnit.MILLISECONDS);
    }
}

