/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.mqtt.handler;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.util.ReferenceCountUtil;
import java.util.LinkedList;
import java.util.Queue;

public class MQTTMessageDebounceHandler
extends ChannelDuplexHandler {
    public static final String NAME = "MQTTMessageDebounceHandler";
    private final Queue<MqttMessage> buffer = new LinkedList<MqttMessage>();
    private boolean readOne = false;

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        MqttMessage msg;
        while ((msg = this.buffer.poll()) != null) {
            ReferenceCountUtil.release((Object)msg);
        }
        super.channelInactive(ctx);
    }

    public void read(ChannelHandlerContext ctx) {
        if (ctx.channel().config().isAutoRead()) {
            MqttMessage msg;
            while ((msg = this.buffer.poll()) != null) {
                ctx.fireChannelRead((Object)msg);
            }
            ctx.read();
        } else {
            MqttMessage msg = this.buffer.poll();
            if (msg != null) {
                ctx.fireChannelRead((Object)msg);
            } else {
                this.readOne = true;
                ctx.read();
            }
        }
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        assert (msg instanceof MqttMessage);
        if (ctx.channel().config().isAutoRead()) {
            ctx.fireChannelRead(msg);
        } else {
            this.buffer.offer((MqttMessage)msg);
            if (this.readOne) {
                MqttMessage mqttMsg = this.buffer.poll();
                ctx.fireChannelRead((Object)mqttMsg);
                this.readOne = false;
            }
        }
    }
}

