/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.balance.impl;

import java.time.Duration;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.apache.bifromq.basehlc.HLC;
import org.apache.bifromq.basekv.balance.AwaitBalance;
import org.apache.bifromq.basekv.balance.BalanceNow;
import org.apache.bifromq.basekv.balance.BalanceResult;
import org.apache.bifromq.basekv.balance.NoNeedBalance;
import org.apache.bifromq.basekv.balance.StoreBalancer;
import org.apache.bifromq.basekv.balance.command.BalanceCommand;
import org.apache.bifromq.basekv.balance.command.BootstrapCommand;
import org.apache.bifromq.basekv.proto.Boundary;
import org.apache.bifromq.basekv.proto.KVRangeId;
import org.apache.bifromq.basekv.proto.KVRangeStoreDescriptor;
import org.apache.bifromq.basekv.utils.BoundaryUtil;
import org.apache.bifromq.basekv.utils.DescriptorUtil;
import org.apache.bifromq.basekv.utils.EffectiveEpoch;
import org.apache.bifromq.basekv.utils.KVRangeIdUtil;

public class RangeBootstrapBalancer
extends StoreBalancer {
    private final Supplier<Long> millisSource;
    private final long suspicionDurationMillis;
    private final AtomicReference<BootstrapTrigger> bootstrapTrigger = new AtomicReference();

    public RangeBootstrapBalancer(String clusterId, String localStoreId) {
        this(clusterId, localStoreId, Duration.ofSeconds(15L), () -> ((HLC)HLC.INST).getPhysical());
    }

    public RangeBootstrapBalancer(String clusterId, String localStoreId, Duration suspicionDuration) {
        this(clusterId, localStoreId, suspicionDuration, () -> ((HLC)HLC.INST).getPhysical());
    }

    RangeBootstrapBalancer(String clusterId, String localStoreId, Duration suspicionDuration, Supplier<Long> millisSource) {
        super(clusterId, localStoreId);
        this.millisSource = millisSource;
        this.suspicionDurationMillis = suspicionDuration.toMillis();
    }

    public void update(Set<KVRangeStoreDescriptor> landscape) {
        Optional effectiveEpoch = DescriptorUtil.getEffectiveEpoch(landscape);
        if (effectiveEpoch.isEmpty()) {
            if (this.bootstrapTrigger.get() == null) {
                KVRangeId rangeId = KVRangeIdUtil.generate();
                this.log.debug("No epoch found, schedule bootstrap command to create first full boundary range: {}", (Object)KVRangeIdUtil.toString((KVRangeId)rangeId));
                this.bootstrapTrigger.set(new BootstrapTrigger(rangeId, BoundaryUtil.FULL_BOUNDARY, this.randomSuspicionTimeout()));
            }
        } else if (this.bootstrapTrigger.get() != null) {
            this.log.debug("Effective epoch found: {}, cancel any pending bootstrap", (Object)((EffectiveEpoch)effectiveEpoch.get()).epoch());
            this.bootstrapTrigger.set(null);
        }
    }

    public BalanceResult balance() {
        BootstrapTrigger current = this.bootstrapTrigger.get();
        if (current != null) {
            long nowMillis = this.millisSource.get();
            if (nowMillis > current.triggerTime) {
                this.bootstrapTrigger.set(null);
                return BalanceNow.of((BalanceCommand)((BootstrapCommand.BootstrapCommandBuilder)((BootstrapCommand.BootstrapCommandBuilder)BootstrapCommand.builder().toStore(this.localStoreId)).kvRangeId(current.id)).boundary(current.boundary).build());
            }
            return AwaitBalance.of((Duration)Duration.ofMillis(current.triggerTime - nowMillis));
        }
        return NoNeedBalance.INSTANCE;
    }

    private long randomSuspicionTimeout() {
        return this.millisSource.get() + ThreadLocalRandom.current().nextLong(this.suspicionDurationMillis, this.suspicionDurationMillis * 2L);
    }

    private record BootstrapTrigger(KVRangeId id, Boundary boundary, long triggerTime) {
    }
}

