/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.logger;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.slf4j.Marker;
import org.slf4j.event.Level;
import org.slf4j.spi.LocationAwareLogger;

public class MDCLogger
implements Logger {
    private static final Optional<Level> EMPTY_LEVEL = Optional.empty();
    private static final Optional<Level> TRACE_LEVEL = Optional.of(Level.TRACE);
    private static final Optional<Level> DEBUG_LEVEL = Optional.of(Level.DEBUG);
    private static final Optional<Level> INFO_LEVEL = Optional.of(Level.INFO);
    private static final Optional<Level> WARN_LEVEL = Optional.of(Level.WARN);
    private static final Optional<Level> ERROR_LEVEL = Optional.of(Level.ERROR);
    private static final String FQCN = MDCLogger.class.getName();
    private final LocationAwareLogger delegate;
    private final String[] tags;

    public MDCLogger(String name, String ... tags) {
        assert (tags.length % 2 == 0) : "Tags must be in key-value pairs";
        this.delegate = (LocationAwareLogger)LoggerFactory.getLogger((String)name);
        this.tags = tags;
    }

    public static Logger getLogger(Class<?> clazz, String ... tags) {
        return MDCLogger.getLogger(clazz.getName(), tags);
    }

    public static Logger getLogger(String name, String ... tags) {
        return new MDCLogger(name, tags);
    }

    protected Map<String, String> extraContext() {
        return Collections.emptyMap();
    }

    private void logWithMDC(Supplier<Optional<Level>> isEnabled, Marker marker, String msg, Object[] args, Throwable t) {
        int i;
        Optional<Level> lvl = isEnabled.get();
        if (lvl.isEmpty()) {
            return;
        }
        Object[] evaluated = args;
        if (args != null && args.length > 0) {
            evaluated = new Object[args.length];
            for (i = 0; i < args.length; ++i) {
                Object a = args[i];
                evaluated[i] = a instanceof Supplier ? ((Supplier)a).get() : a;
            }
        }
        for (i = 0; i < this.tags.length; i += 2) {
            MDC.put((String)this.tags[i], (String)this.tags[i + 1]);
        }
        Map<String, String> extraCtx = this.extraContext();
        extraCtx.forEach(MDC::put);
        this.delegate.log(marker, FQCN, lvl.get().toInt(), msg, evaluated, t);
        for (int i2 = 0; i2 < this.tags.length; i2 += 2) {
            MDC.remove((String)this.tags[i2]);
        }
        extraCtx.keySet().forEach(MDC::remove);
    }

    public String getName() {
        return this.delegate.getName();
    }

    public boolean isTraceEnabled() {
        return this.delegate.isTraceEnabled();
    }

    private Optional<Level> isTraceEnabledSupplier() {
        return this.delegate.isTraceEnabled() ? TRACE_LEVEL : EMPTY_LEVEL;
    }

    public void trace(String msg) {
        this.logWithMDC(this::isTraceEnabledSupplier, null, msg, null, null);
    }

    public void trace(String format, Object arg) {
        this.logWithMDC(this::isTraceEnabledSupplier, null, format, new Object[]{arg}, null);
    }

    public void trace(String format, Object arg1, Object arg2) {
        this.logWithMDC(this::isTraceEnabledSupplier, null, format, new Object[]{arg1, arg2}, null);
    }

    public void trace(String format, Object ... arguments) {
        this.logWithMDC(this::isTraceEnabledSupplier, null, format, arguments, null);
    }

    public void trace(String msg, Throwable t) {
        this.logWithMDC(this::isTraceEnabledSupplier, null, msg, null, t);
    }

    public boolean isTraceEnabled(Marker marker) {
        return this.delegate.isTraceEnabled(marker);
    }

    private Supplier<Optional<Level>> isTraceEnabledSupplier(Marker marker) {
        return () -> this.delegate.isTraceEnabled(marker) ? TRACE_LEVEL : EMPTY_LEVEL;
    }

    public void trace(Marker marker, String msg) {
        this.logWithMDC(this.isTraceEnabledSupplier(marker), marker, msg, null, null);
    }

    public void trace(Marker marker, String format, Object arg) {
        this.logWithMDC(this.isTraceEnabledSupplier(marker), marker, format, new Object[]{arg}, null);
    }

    public void trace(Marker marker, String format, Object arg1, Object arg2) {
        this.logWithMDC(this.isTraceEnabledSupplier(marker), marker, format, new Object[]{arg1, arg2}, null);
    }

    public void trace(Marker marker, String format, Object ... argArray) {
        this.logWithMDC(this.isTraceEnabledSupplier(marker), marker, format, argArray, null);
    }

    public void trace(Marker marker, String msg, Throwable t) {
        this.logWithMDC(this.isTraceEnabledSupplier(marker), marker, msg, null, t);
    }

    public boolean isDebugEnabled() {
        return this.delegate.isDebugEnabled();
    }

    private Optional<Level> isDebugEnabledSupplier() {
        return this.delegate.isDebugEnabled() ? DEBUG_LEVEL : EMPTY_LEVEL;
    }

    public void debug(String msg) {
        this.logWithMDC(this::isDebugEnabledSupplier, null, msg, null, null);
    }

    public void debug(String format, Object arg) {
        this.logWithMDC(this::isDebugEnabledSupplier, null, format, new Object[]{arg}, null);
    }

    public void debug(String format, Object arg1, Object arg2) {
        this.logWithMDC(this::isDebugEnabledSupplier, null, format, new Object[]{arg1, arg2}, null);
    }

    public void debug(String format, Object ... arguments) {
        this.logWithMDC(this::isDebugEnabledSupplier, null, format, arguments, null);
    }

    public void debug(String msg, Throwable t) {
        this.logWithMDC(this::isDebugEnabledSupplier, null, msg, null, t);
    }

    public boolean isDebugEnabled(Marker marker) {
        return this.delegate.isDebugEnabled(marker);
    }

    private Supplier<Optional<Level>> isDebugEnabledSupplier(Marker marker) {
        return () -> this.delegate.isDebugEnabled(marker) ? DEBUG_LEVEL : EMPTY_LEVEL;
    }

    public void debug(Marker marker, String msg) {
        this.logWithMDC(this.isDebugEnabledSupplier(marker), marker, msg, null, null);
    }

    public void debug(Marker marker, String format, Object arg) {
        this.logWithMDC(this.isDebugEnabledSupplier(marker), marker, format, new Object[]{arg}, null);
    }

    public void debug(Marker marker, String format, Object arg1, Object arg2) {
        this.logWithMDC(this.isDebugEnabledSupplier(marker), marker, format, new Object[]{arg1, arg2}, null);
    }

    public void debug(Marker marker, String format, Object ... arguments) {
        this.logWithMDC(this.isDebugEnabledSupplier(marker), marker, format, arguments, null);
    }

    public void debug(Marker marker, String msg, Throwable t) {
        this.logWithMDC(this.isDebugEnabledSupplier(marker), marker, msg, null, t);
    }

    public boolean isInfoEnabled() {
        return this.delegate.isInfoEnabled();
    }

    private Optional<Level> isInfoEnabledSupplier() {
        return this.delegate.isInfoEnabled() ? INFO_LEVEL : EMPTY_LEVEL;
    }

    public void info(String msg) {
        this.logWithMDC(this::isInfoEnabledSupplier, null, msg, null, null);
    }

    public void info(String format, Object arg) {
        this.logWithMDC(this::isInfoEnabledSupplier, null, format, new Object[]{arg}, null);
    }

    public void info(String format, Object arg1, Object arg2) {
        this.logWithMDC(this::isInfoEnabledSupplier, null, format, new Object[]{arg1, arg2}, null);
    }

    public void info(String format, Object ... arguments) {
        this.logWithMDC(this::isInfoEnabledSupplier, null, format, arguments, null);
    }

    public void info(String msg, Throwable t) {
        this.logWithMDC(this::isInfoEnabledSupplier, null, msg, null, t);
    }

    public boolean isInfoEnabled(Marker marker) {
        return this.delegate.isInfoEnabled(marker);
    }

    private Supplier<Optional<Level>> isInfoEnabledSupplier(Marker marker) {
        return () -> this.delegate.isInfoEnabled(marker) ? INFO_LEVEL : EMPTY_LEVEL;
    }

    public void info(Marker marker, String msg) {
        this.logWithMDC(this.isInfoEnabledSupplier(marker), marker, msg, null, null);
    }

    public void info(Marker marker, String format, Object arg) {
        this.logWithMDC(this.isInfoEnabledSupplier(marker), marker, format, new Object[]{arg}, null);
    }

    public void info(Marker marker, String format, Object arg1, Object arg2) {
        this.logWithMDC(this.isInfoEnabledSupplier(marker), marker, format, new Object[]{arg1, arg2}, null);
    }

    public void info(Marker marker, String format, Object ... arguments) {
        this.logWithMDC(this.isInfoEnabledSupplier(marker), marker, format, arguments, null);
    }

    public void info(Marker marker, String msg, Throwable t) {
        this.logWithMDC(this.isInfoEnabledSupplier(marker), marker, msg, null, t);
    }

    public boolean isWarnEnabled() {
        return this.delegate.isWarnEnabled();
    }

    private Optional<Level> isWarnEnabledSupplier() {
        return this.delegate.isWarnEnabled() ? WARN_LEVEL : EMPTY_LEVEL;
    }

    public void warn(String msg) {
        this.logWithMDC(this::isWarnEnabledSupplier, null, msg, null, null);
    }

    public void warn(String format, Object arg) {
        this.logWithMDC(this::isWarnEnabledSupplier, null, format, new Object[]{arg}, null);
    }

    public void warn(String format, Object arg1, Object arg2) {
        this.logWithMDC(this::isWarnEnabledSupplier, null, format, new Object[]{arg1, arg2}, null);
    }

    public void warn(String format, Object ... arguments) {
        this.logWithMDC(this::isWarnEnabledSupplier, null, format, arguments, null);
    }

    public void warn(String msg, Throwable t) {
        this.logWithMDC(this::isWarnEnabledSupplier, null, msg, null, t);
    }

    public boolean isWarnEnabled(Marker marker) {
        return this.delegate.isWarnEnabled(marker);
    }

    private Supplier<Optional<Level>> isWarnEnabledSupplier(Marker marker) {
        return () -> this.delegate.isWarnEnabled(marker) ? WARN_LEVEL : EMPTY_LEVEL;
    }

    public void warn(Marker marker, String msg) {
        this.logWithMDC(this.isWarnEnabledSupplier(marker), marker, msg, null, null);
    }

    public void warn(Marker marker, String format, Object arg) {
        this.logWithMDC(this.isWarnEnabledSupplier(marker), marker, format, new Object[]{arg}, null);
    }

    public void warn(Marker marker, String format, Object arg1, Object arg2) {
        this.logWithMDC(this.isWarnEnabledSupplier(marker), marker, format, new Object[]{arg1, arg2}, null);
    }

    public void warn(Marker marker, String format, Object ... arguments) {
        this.logWithMDC(this.isWarnEnabledSupplier(marker), marker, format, arguments, null);
    }

    public void warn(Marker marker, String msg, Throwable t) {
        this.logWithMDC(this.isWarnEnabledSupplier(marker), marker, msg, null, t);
    }

    public boolean isErrorEnabled() {
        return this.delegate.isErrorEnabled();
    }

    private Optional<Level> isErrorEnabledSupplier() {
        return this.delegate.isErrorEnabled() ? ERROR_LEVEL : EMPTY_LEVEL;
    }

    public void error(String msg) {
        this.logWithMDC(this::isErrorEnabledSupplier, null, msg, null, null);
    }

    public void error(String format, Object arg) {
        this.logWithMDC(this::isErrorEnabledSupplier, null, format, new Object[]{arg}, null);
    }

    public void error(String format, Object arg1, Object arg2) {
        this.logWithMDC(this::isErrorEnabledSupplier, null, format, new Object[]{arg1, arg2}, null);
    }

    public void error(String format, Object ... arguments) {
        this.logWithMDC(this::isErrorEnabledSupplier, null, format, arguments, null);
    }

    public void error(String msg, Throwable t) {
        this.logWithMDC(this::isErrorEnabledSupplier, null, msg, null, t);
    }

    public boolean isErrorEnabled(Marker marker) {
        return this.delegate.isErrorEnabled(marker);
    }

    private Supplier<Optional<Level>> isErrorEnabledSupplier(Marker marker) {
        return () -> this.delegate.isErrorEnabled(marker) ? ERROR_LEVEL : EMPTY_LEVEL;
    }

    public void error(Marker marker, String msg) {
        this.logWithMDC(this.isErrorEnabledSupplier(marker), marker, msg, null, null);
    }

    public void error(Marker marker, String format, Object arg) {
        this.logWithMDC(this.isErrorEnabledSupplier(marker), marker, format, new Object[]{arg}, null);
    }

    public void error(Marker marker, String format, Object arg1, Object arg2) {
        this.logWithMDC(this.isErrorEnabledSupplier(marker), marker, format, new Object[]{arg1, arg2}, null);
    }

    public void error(Marker marker, String format, Object ... arguments) {
        this.logWithMDC(this.isErrorEnabledSupplier(marker), marker, format, arguments, null);
    }

    public void error(Marker marker, String msg, Throwable t) {
        this.logWithMDC(this.isErrorEnabledSupplier(marker), marker, msg, null, t);
    }
}

