/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.apiserver.http.handler;

import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.bifromq.apiserver.Headers;
import org.apache.bifromq.apiserver.http.IHTTPRequestHandler;
import org.apache.bifromq.apiserver.http.handler.utils.HeaderUtils;
import org.apache.bifromq.apiserver.http.handler.utils.JSONUtils;
import org.apache.bifromq.basekv.metaservice.IBaseKVMetaService;
import org.apache.bifromq.basekv.metaservice.IBaseKVStoreBalancerStatesObserver;
import org.apache.bifromq.basekv.proto.BalancerStateSnapshot;

@Path(value="/store/balancer")
final class GetBalancerStateHandler
implements IHTTPRequestHandler {
    private final IBaseKVMetaService metaService;
    private final Map<String, IBaseKVStoreBalancerStatesObserver> balancerStateObservers = new ConcurrentHashMap<String, IBaseKVStoreBalancerStatesObserver>();
    private final CompositeDisposable disposable = new CompositeDisposable();

    GetBalancerStateHandler(IBaseKVMetaService metaService) {
        this.metaService = metaService;
    }

    @Override
    public void start() {
        this.disposable.add(this.metaService.clusterIds().subscribe(clusterIds -> {
            this.balancerStateObservers.keySet().removeIf(clusterId -> !clusterIds.contains(clusterId));
            for (String clusterId2 : clusterIds) {
                this.balancerStateObservers.computeIfAbsent(clusterId2, arg_0 -> ((IBaseKVMetaService)this.metaService).balancerStatesObserver(arg_0));
            }
        }));
    }

    @Override
    public void close() {
        this.disposable.dispose();
        this.balancerStateObservers.values().forEach(IBaseKVStoreBalancerStatesObserver::stop);
    }

    @Override
    @GET
    @Operation(summary="Get the store balancer state")
    @Parameters(value={@Parameter(name="req_id", in=ParameterIn.HEADER, description="optional caller provided request id", schema=@Schema(implementation=Long.class)), @Parameter(name="store_name", in=ParameterIn.HEADER, required=true, description="the store name", schema=@Schema(implementation=String.class)), @Parameter(name="balancer_factory_class", in=ParameterIn.HEADER, required=true, description="the full qualified name of balancer factory class configured for the store", schema=@Schema(implementation=String.class))})
    @RequestBody
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Success", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="404", description="Balancer not found for the store", content={@Content(schema=@Schema(implementation=String.class))})})
    public CompletableFuture<FullHttpResponse> handle(@Parameter(hidden=true) long reqId, @Parameter(hidden=true) FullHttpRequest req) {
        try {
            String storeName = HeaderUtils.getHeader(Headers.HEADER_STORE_NAME, (HttpRequest)req, true);
            String balancerFactoryClass = HeaderUtils.getHeader(Headers.HEADER_BALANCER_FACTORY_CLASS, (HttpRequest)req, true);
            IBaseKVStoreBalancerStatesObserver statesObserver = this.balancerStateObservers.get(storeName);
            if (statesObserver == null) {
                return CompletableFuture.completedFuture(new DefaultFullHttpResponse(req.protocolVersion(), HttpResponseStatus.NOT_FOUND, Unpooled.copiedBuffer((byte[])("Store not found: " + storeName).getBytes())));
            }
            return statesObserver.currentBalancerStates().timeout(1L, TimeUnit.SECONDS).firstElement().toCompletionStage().toCompletableFuture().handle((currentStateMap, e) -> {
                if (e != null) {
                    if (e instanceof TimeoutException) {
                        DefaultFullHttpResponse resp = new DefaultFullHttpResponse(req.protocolVersion(), HttpResponseStatus.OK, Unpooled.wrappedBuffer((byte[])this.toJson(Collections.emptyMap()).getBytes()));
                        resp.headers().set("Content-Type", (Object)"application/json");
                        return resp;
                    }
                    return new DefaultFullHttpResponse(req.protocolVersion(), HttpResponseStatus.INTERNAL_SERVER_ERROR, Unpooled.copiedBuffer((byte[])e.getMessage().getBytes()));
                }
                HashMap<String, Map<String, BalancerStateSnapshot>> statesByStoreByBalancer = new HashMap<String, Map<String, BalancerStateSnapshot>>();
                for (Map.Entry entry : currentStateMap.entrySet()) {
                    String storeId = (String)entry.getKey();
                    Map statesByBalancer = (Map)entry.getValue();
                    BalancerStateSnapshot expectedStates = (BalancerStateSnapshot)statesByBalancer.get(balancerFactoryClass);
                    if (expectedStates == null) continue;
                    statesByStoreByBalancer.computeIfAbsent(balancerFactoryClass, k -> new HashMap()).put(storeId, expectedStates);
                }
                if (!statesByStoreByBalancer.isEmpty()) {
                    DefaultFullHttpResponse resp = new DefaultFullHttpResponse(req.protocolVersion(), HttpResponseStatus.OK, Unpooled.wrappedBuffer((byte[])this.toJson(statesByStoreByBalancer).getBytes()));
                    resp.headers().set("Content-Type", (Object)"application/json");
                    return resp;
                }
                return new DefaultFullHttpResponse(req.protocolVersion(), HttpResponseStatus.NOT_FOUND, Unpooled.EMPTY_BUFFER);
            });
        }
        catch (Throwable e2) {
            return CompletableFuture.failedFuture(e2);
        }
    }

    private String toJson(Map<String, Map<String, BalancerStateSnapshot>> statesByStoreByBalancer) {
        return JSONUtils.MAPPER.writeValueAsString(statesByStoreByBalancer);
    }
}

