/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.plugin.eventcollector;

import com.google.common.annotations.VisibleForTesting;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.apache.bifromq.basehlc.HLC;
import org.apache.bifromq.plugin.eventcollector.Event;
import org.apache.bifromq.plugin.eventcollector.EventPool;
import org.apache.bifromq.plugin.eventcollector.IEventCollector;
import org.pf4j.PluginManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventCollectorManager
implements IEventCollector,
AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EventCollectorManager.class);
    private static final Logger pluginLog = LoggerFactory.getLogger((String)"plugin.manager");
    private static final EventPool ZERO_OUT_HOLDERS = new EventPool();
    private final AtomicBoolean stopped = new AtomicBoolean();
    private final Map<String, IEventCollector> eventCollectors = new HashMap<String, IEventCollector>();
    private final Map<String, Timer> eventCollectorTimers = new HashMap<String, Timer>();
    private final Counter callInvokeCounter;

    public EventCollectorManager(PluginManager pluginMgr) {
        for (IEventCollector eventCollector : pluginMgr.getExtensions(IEventCollector.class)) {
            pluginLog.info("Event collector loaded: {}", (Object)eventCollector.getClass().getName());
            this.eventCollectors.put(eventCollector.getClass().getName(), eventCollector);
            this.eventCollectorTimers.put(eventCollector.getClass().getName(), Timer.builder((String)"call.exec.timer").tag("method", "EventCollector/report").tag("type", eventCollector.getClass().getSimpleName()).register((MeterRegistry)Metrics.globalRegistry));
        }
        this.callInvokeCounter = Counter.builder((String)"event.collector.report.invoke.count").register((MeterRegistry)Metrics.globalRegistry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void report(Event<?> event) {
        this.callInvokeCounter.increment();
        event.hlc(HLC.INST.get());
        for (Map.Entry<String, IEventCollector> entry : this.eventCollectors.entrySet()) {
            Timer.Sample sample = Timer.start();
            try {
                entry.getValue().report(event);
            }
            catch (Throwable e) {
                pluginLog.error("Failed to report event to collector: {}", (Object)entry.getKey());
            }
            finally {
                sample.stop(this.eventCollectorTimers.get(entry.getKey()));
            }
        }
        event.clone(ZERO_OUT_HOLDERS.get(event.type()));
    }

    @Override
    public void close() {
        if (this.stopped.compareAndSet(false, true)) {
            log.debug("Closing event collector manager");
            this.eventCollectors.values().forEach(eventCollector -> {
                try {
                    eventCollector.close();
                }
                catch (Throwable e) {
                    pluginLog.error("Failed to close event collector: {}", (Object)eventCollector.getClass().getName(), (Object)e);
                }
            });
            this.eventCollectorTimers.values().forEach(arg_0 -> ((CompositeMeterRegistry)Metrics.globalRegistry).remove(arg_0));
            Metrics.globalRegistry.remove((Meter)this.callInvokeCounter);
            log.debug("Event collector manager closed");
        }
    }

    @VisibleForTesting
    IEventCollector get(String collectorName) {
        return this.eventCollectors.get(collectorName);
    }
}

