/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.plugin.manager;

import java.lang.reflect.Constructor;
import lombok.Generated;
import org.apache.bifromq.plugin.BifroMQPlugin;
import org.apache.bifromq.plugin.BifroMQPluginContext;
import org.pf4j.DefaultExtensionFactory;
import org.pf4j.Plugin;
import org.pf4j.PluginManager;
import org.pf4j.PluginRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BifroMQExtensionFactory
extends DefaultExtensionFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BifroMQExtensionFactory.class);
    private final PluginManager pluginManager;

    public BifroMQExtensionFactory(PluginManager pluginManager) {
        this.pluginManager = pluginManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T create(Class<T> extensionClass) {
        ClassLoader originalLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(extensionClass.getClassLoader());
            Plugin ownerPlugin = this.pluginManager.whichPlugin(extensionClass).getPlugin();
            if (ownerPlugin instanceof BifroMQPlugin) {
                T t = this.createExtensionWithContext(extensionClass, (BifroMQPlugin)ownerPlugin);
                return t;
            }
            Object object = super.create(extensionClass);
            return (T)object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalLoader);
        }
    }

    private <T, C extends BifroMQPluginContext> T createExtensionWithContext(Class<T> extensionClass, BifroMQPlugin<C> ownerPlugin) {
        try {
            BifroMQPluginContext pluginContext = ownerPlugin.context();
            Constructor<T> constructor = extensionClass.getConstructor(pluginContext.getClass());
            return constructor.newInstance(pluginContext);
        }
        catch (NoSuchMethodException e) {
            log.debug("No constructor with plugin context found for extension[{}], fallback to no-arg constructor", (Object)extensionClass.getName());
            return (T)super.create(extensionClass);
        }
        catch (Throwable e) {
            throw new PluginRuntimeException(e);
        }
    }
}

