/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.inbox.server.scheduler;

import com.google.common.hash.Hashing;
import com.google.protobuf.ByteString;
import java.nio.charset.StandardCharsets;
import lombok.Generated;
import org.apache.bifromq.basekv.client.IBaseKVStoreClient;
import org.apache.bifromq.inbox.server.scheduler.BatchFetchCall;
import org.apache.bifromq.inbox.server.scheduler.FetchRequest;
import org.apache.bifromq.inbox.server.scheduler.IInboxFetchScheduler;
import org.apache.bifromq.inbox.server.scheduler.InboxReadScheduler;
import org.apache.bifromq.inbox.storage.proto.Fetched;
import org.apache.bifromq.inbox.store.schema.KVSchemaUtil;
import org.apache.bifromq.sysprops.props.InboxFetchQueuesPerRange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InboxFetchScheduler
extends InboxReadScheduler<FetchRequest, Fetched, BatchFetchCall>
implements IInboxFetchScheduler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InboxFetchScheduler.class);

    public InboxFetchScheduler(IBaseKVStoreClient inboxStoreClient) {
        super(BatchFetchCall::new, (Integer)InboxFetchQueuesPerRange.INSTANCE.get(), inboxStoreClient);
    }

    @Override
    protected int selectQueue(FetchRequest request) {
        int hash = Hashing.murmur3_32_fixed().newHasher().putString((CharSequence)request.tenantId(), StandardCharsets.UTF_8).putString((CharSequence)request.inboxId(), StandardCharsets.UTF_8).putLong(request.incarnation()).hash().asInt();
        return Math.floorMod(hash, this.queuesPerRange);
    }

    protected boolean isLinearizable(FetchRequest request) {
        return false;
    }

    protected ByteString rangeKey(FetchRequest request) {
        return KVSchemaUtil.inboxInstanceStartKey((String)request.tenantId(), (String)request.inboxId(), (long)request.incarnation());
    }
}

