/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.inbox.server.scheduler;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.apache.bifromq.basekv.client.IMutationPipeline;
import org.apache.bifromq.basekv.client.exception.BadVersionException;
import org.apache.bifromq.basekv.client.exception.TryLaterException;
import org.apache.bifromq.basekv.client.scheduler.BatchMutationCall;
import org.apache.bifromq.basekv.client.scheduler.MutationCallBatcherKey;
import org.apache.bifromq.basekv.store.proto.RWCoProcInput;
import org.apache.bifromq.basekv.store.proto.RWCoProcOutput;
import org.apache.bifromq.baserpc.client.exception.ServerNotFoundException;
import org.apache.bifromq.basescheduler.ICallTask;
import org.apache.bifromq.inbox.rpc.proto.CommitReply;
import org.apache.bifromq.inbox.rpc.proto.CommitRequest;
import org.apache.bifromq.inbox.storage.proto.BatchCommitRequest;
import org.apache.bifromq.inbox.storage.proto.InboxServiceRWCoProcInput;
import org.apache.bifromq.inbox.storage.proto.InboxVersion;

class BatchCommitCall
extends BatchMutationCall<CommitRequest, CommitReply> {
    protected BatchCommitCall(IMutationPipeline pipeline, MutationCallBatcherKey batcherKey) {
        super(pipeline, batcherKey);
    }

    protected BatchMutationCall.MutationCallTaskBatch<CommitRequest, CommitReply> newBatch(long ver) {
        return new BatchCommitCallTask(ver);
    }

    protected RWCoProcInput makeBatch(Iterable<ICallTask<CommitRequest, CommitReply, MutationCallBatcherKey>> callTasks) {
        BatchCommitRequest.Builder reqBuilder = BatchCommitRequest.newBuilder();
        callTasks.forEach(call -> {
            CommitRequest req = (CommitRequest)call.call();
            BatchCommitRequest.Params.Builder paramsBuilder = BatchCommitRequest.Params.newBuilder().setTenantId(req.getTenantId()).setInboxId(req.getInboxId()).setVersion(req.getVersion()).setNow(req.getNow());
            if (req.hasQos0UpToSeq()) {
                paramsBuilder.setQos0UpToSeq(req.getQos0UpToSeq());
            }
            if (req.hasSendBufferUpToSeq()) {
                paramsBuilder.setSendBufferUpToSeq(req.getSendBufferUpToSeq());
            }
            reqBuilder.addParams(paramsBuilder.build());
        });
        long reqId = System.nanoTime();
        return RWCoProcInput.newBuilder().setInboxService(InboxServiceRWCoProcInput.newBuilder().setReqId(reqId).setBatchCommit(reqBuilder.build()).build()).build();
    }

    protected void handleOutput(Queue<ICallTask<CommitRequest, CommitReply, MutationCallBatcherKey>> batchedTasks, RWCoProcOutput output) {
        ICallTask<CommitRequest, CommitReply, MutationCallBatcherKey> task;
        assert (batchedTasks.size() == output.getInboxService().getBatchCommit().getCodeCount());
        int i = 0;
        block5: while ((task = batchedTasks.poll()) != null) {
            CommitReply.Builder replyBuilder = CommitReply.newBuilder().setReqId(((CommitRequest)task.call()).getReqId());
            switch (output.getInboxService().getBatchCommit().getCode(i++)) {
                case OK: {
                    task.resultPromise().complete(replyBuilder.setCode(CommitReply.Code.OK).build());
                    continue block5;
                }
                case NO_INBOX: {
                    task.resultPromise().complete(replyBuilder.setCode(CommitReply.Code.NO_INBOX).build());
                    continue block5;
                }
                case CONFLICT: {
                    task.resultPromise().complete(replyBuilder.setCode(CommitReply.Code.CONFLICT).build());
                    continue block5;
                }
            }
            task.resultPromise().complete(replyBuilder.setCode(CommitReply.Code.ERROR).build());
        }
    }

    protected void handleException(ICallTask<CommitRequest, CommitReply, MutationCallBatcherKey> callTask, Throwable e) {
        if (e instanceof ServerNotFoundException) {
            callTask.resultPromise().complete(CommitReply.newBuilder().setReqId(((CommitRequest)callTask.call()).getReqId()).setCode(CommitReply.Code.TRY_LATER).build());
            return;
        }
        if (e instanceof BadVersionException) {
            callTask.resultPromise().complete(CommitReply.newBuilder().setReqId(((CommitRequest)callTask.call()).getReqId()).setCode(CommitReply.Code.TRY_LATER).build());
            return;
        }
        if (e instanceof TryLaterException) {
            callTask.resultPromise().complete(CommitReply.newBuilder().setReqId(((CommitRequest)callTask.call()).getReqId()).setCode(CommitReply.Code.TRY_LATER).build());
            return;
        }
        callTask.resultPromise().completeExceptionally(e);
    }

    private static class BatchCommitCallTask
    extends BatchMutationCall.MutationCallTaskBatch<CommitRequest, CommitReply> {
        private final Map<String, Set<InboxVersion>> inboxes = new HashMap<String, Set<InboxVersion>>();

        private BatchCommitCallTask(long ver) {
            super(ver);
        }

        protected void add(ICallTask<CommitRequest, CommitReply, MutationCallBatcherKey> callTask) {
            super.add(callTask);
            this.inboxes.computeIfAbsent(((CommitRequest)callTask.call()).getTenantId(), k -> new HashSet()).add(((CommitRequest)callTask.call()).getVersion());
        }

        protected boolean isBatchable(ICallTask<CommitRequest, CommitReply, MutationCallBatcherKey> callTask) {
            return !this.inboxes.getOrDefault(((CommitRequest)callTask.call()).getTenantId(), Collections.emptySet()).contains(((CommitRequest)callTask.call()).getVersion());
        }
    }
}

