/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.sessiondict.server;

import io.grpc.stub.StreamObserver;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.bifromq.baserpc.server.ResponsePipeline;
import org.apache.bifromq.sessiondict.rpc.proto.ExistReply;
import org.apache.bifromq.sessiondict.rpc.proto.ExistRequest;
import org.apache.bifromq.sessiondict.server.ISessionRegistry;
import org.apache.bifromq.type.ClientInfo;

class SessionExistPipeline
extends ResponsePipeline<ExistRequest, ExistReply> {
    private final ISessionRegistry sessionRegistry;

    public SessionExistPipeline(ISessionRegistry sessionRegistry, StreamObserver<ExistReply> responseObserver) {
        super(responseObserver);
        this.sessionRegistry = sessionRegistry;
    }

    protected CompletableFuture<ExistReply> handleRequest(String tenantId, ExistRequest request) {
        ExistReply.Builder respBuilder = ExistReply.newBuilder().setReqId(request.getReqId()).setCode(ExistReply.Code.OK);
        for (ExistRequest.Client client : request.getClientList()) {
            Optional<ClientInfo> clientOpt = this.sessionRegistry.get(tenantId, client.getUserId(), client.getClientId());
            respBuilder.addExist(clientOpt.isPresent());
        }
        return CompletableFuture.completedFuture(respBuilder.build());
    }
}

