/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.localengine.rocksdb;

import com.google.protobuf.ByteString;
import com.google.protobuf.UnsafeByteOperations;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.bifromq.basekv.localengine.KVEngineException;
import org.apache.bifromq.basekv.localengine.rocksdb.IRocksDBKVSpaceEpoch;
import org.apache.bifromq.basekv.localengine.rocksdb.Keys;
import org.apache.bifromq.basekv.localengine.rocksdb.RocksDBKVEngineIterator;
import org.apache.bifromq.basekv.proto.Boundary;
import org.apache.bifromq.basekv.utils.BoundaryUtil;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.DBOptions;
import org.rocksdb.Range;
import org.rocksdb.RocksDB;
import org.rocksdb.SizeApproximationFlag;
import org.rocksdb.Slice;

class RocksDBHelper {
    RocksDBHelper() {
    }

    static RocksDBHandle openDBInDir(File dir, DBOptions dbOptions, ColumnFamilyDescriptor cfDesc) {
        try {
            ArrayList cfHandles = new ArrayList();
            RocksDB db = RocksDB.open((DBOptions)dbOptions, (String)dir.getAbsolutePath(), Collections.singletonList(cfDesc), cfHandles);
            assert (cfHandles.size() == 1);
            ColumnFamilyHandle cf = (ColumnFamilyHandle)cfHandles.get(0);
            return new RocksDBHandle(db, cf);
        }
        catch (Throwable e) {
            throw new KVEngineException("Open RocksDB at dir failed", e);
        }
    }

    static void deleteDir(Path path) throws IOException {
        if (!path.toFile().exists()) {
            return;
        }
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                try {
                    Files.delete(file);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                try {
                    Files.delete(dir);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    static long sizeOfBoundary(IRocksDBKVSpaceEpoch dbHandle, Boundary boundary) {
        byte[] end;
        byte[] start = !boundary.hasStartKey() ? Keys.DATA_SECTION_START : Keys.toDataKey(boundary.getStartKey().toByteArray());
        byte[] byArray = end = !boundary.hasEndKey() ? Keys.DATA_SECTION_END : Keys.toDataKey(boundary.getEndKey().toByteArray());
        if (BoundaryUtil.compare((byte[])start, (byte[])end) < 0) {
            try (Slice startSlice = new Slice(start);){
                long l;
                try (Slice endSlice = new Slice(end);){
                    Range range = new Range(startSlice, endSlice);
                    l = dbHandle.db().getApproximateSizes(dbHandle.cf(), Collections.singletonList(range), new SizeApproximationFlag[]{SizeApproximationFlag.INCLUDE_MEMTABLES, SizeApproximationFlag.INCLUDE_FILES})[0];
                }
                return l;
            }
        }
        return 0L;
    }

    static Map<ByteString, ByteString> getMetadata(IRocksDBKVSpaceEpoch dbHandle) {
        try (RocksDBKVEngineIterator metaItr = new RocksDBKVEngineIterator(dbHandle.db(), dbHandle.cf(), null, Keys.META_SECTION_START, Keys.META_SECTION_END);){
            HashMap<ByteString, ByteString> metaMap = new HashMap<ByteString, ByteString>();
            metaItr.seekToFirst();
            while (metaItr.isValid()) {
                metaMap.put(Keys.fromMetaKey(metaItr.key()), UnsafeByteOperations.unsafeWrap((byte[])metaItr.value()));
                metaItr.next();
            }
            HashMap<ByteString, ByteString> hashMap = metaMap;
            return hashMap;
        }
    }

    record RocksDBHandle(RocksDB db, ColumnFamilyHandle cf) {
    }
}

