/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basecrdt.core.internal;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.protobuf.ByteString;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.bifromq.basecrdt.core.api.AWORSetOperation;
import org.apache.bifromq.basecrdt.core.api.CCounterOperation;
import org.apache.bifromq.basecrdt.core.api.CausalCRDTType;
import org.apache.bifromq.basecrdt.core.api.DWFlagOperation;
import org.apache.bifromq.basecrdt.core.api.EWFlagOperation;
import org.apache.bifromq.basecrdt.core.api.IAWORSet;
import org.apache.bifromq.basecrdt.core.api.ICCounter;
import org.apache.bifromq.basecrdt.core.api.IDWFlag;
import org.apache.bifromq.basecrdt.core.api.IEWFlag;
import org.apache.bifromq.basecrdt.core.api.IMVReg;
import org.apache.bifromq.basecrdt.core.api.IORMap;
import org.apache.bifromq.basecrdt.core.api.IRWORSet;
import org.apache.bifromq.basecrdt.core.api.MVRegOperation;
import org.apache.bifromq.basecrdt.core.api.ORMapOperation;
import org.apache.bifromq.basecrdt.core.api.RWORSetOperation;
import org.apache.bifromq.basecrdt.core.internal.AWORSet;
import org.apache.bifromq.basecrdt.core.internal.CCounter;
import org.apache.bifromq.basecrdt.core.internal.CausalCRDT;
import org.apache.bifromq.basecrdt.core.internal.DWFlag;
import org.apache.bifromq.basecrdt.core.internal.DotFunc;
import org.apache.bifromq.basecrdt.core.internal.DotMap;
import org.apache.bifromq.basecrdt.core.internal.DotSet;
import org.apache.bifromq.basecrdt.core.internal.EWFlag;
import org.apache.bifromq.basecrdt.core.internal.IDotFunc;
import org.apache.bifromq.basecrdt.core.internal.IDotMap;
import org.apache.bifromq.basecrdt.core.internal.IDotSet;
import org.apache.bifromq.basecrdt.core.internal.MVReg;
import org.apache.bifromq.basecrdt.core.internal.ORMapUtil;
import org.apache.bifromq.basecrdt.core.internal.RWORSet;
import org.apache.bifromq.basecrdt.proto.Replica;
import org.apache.bifromq.basecrdt.proto.StateLattice;

class ORMap
extends CausalCRDT<IDotMap, ORMapOperation>
implements IORMap {
    private final Cache<ByteString, CausalCRDT<?, ?>> subCRDTMap = Caffeine.newBuilder().weakValues().build();

    ORMap(Replica replica, CausalCRDT.DotStoreAccessor<IDotMap> dotStoreAccessor, CausalCRDT.CRDTOperationExecutor<ORMapOperation> executor) {
        super(replica, dotStoreAccessor, executor);
    }

    @Override
    public Iterator<IORMap.ORMapKey> keys() {
        final IDotMap dotMap = (IDotMap)this.dotStoreAccessor.fetch();
        return new AbstractIterator<IORMap.ORMapKey>(){
            private final Iterator<ByteString> keyItr;
            {
                this.keyItr = Iterators.concat(dotMap.dotSetKeys(), dotMap.dotFuncKeys(), dotMap.dotMapKeys(new ByteString[0]));
            }

            protected IORMap.ORMapKey computeNext() {
                if (this.keyItr.hasNext()) {
                    final ByteString typedKey = this.keyItr.next();
                    return new IORMap.ORMapKey(){

                        @Override
                        public ByteString key() {
                            return ORMapUtil.parseKey(typedKey);
                        }

                        @Override
                        public CausalCRDTType valueType() {
                            return ORMapUtil.getType(typedKey);
                        }
                    };
                }
                return (IORMap.ORMapKey)this.endOfData();
            }
        };
    }

    @Override
    public IAWORSet getAWORSet(ByteString ... keys) {
        if (keys.length == 0) {
            throw new IllegalArgumentException("No key specified");
        }
        if (keys.length == 1) {
            return (IAWORSet)this.subCRDTMap.get((Object)ORMapUtil.typedKey(keys[0], CausalCRDTType.aworset), key -> new AWORSet(this.replica, this.fetchSubDotMap((ByteString)key), op -> this.execute(ORMapOperation.update(keys).with((AWORSetOperation)op))));
        }
        return this.getORMap(keys[0]).getAWORSet(Arrays.copyOfRange(keys, 1, keys.length));
    }

    @Override
    public IRWORSet getRWORSet(ByteString ... keys) {
        if (keys.length == 0) {
            throw new IllegalArgumentException("No key specified");
        }
        if (keys.length == 1) {
            return (IRWORSet)this.subCRDTMap.get((Object)ORMapUtil.typedKey(keys[0], CausalCRDTType.rworset), key -> new RWORSet(this.replica, this.fetchSubDotMap((ByteString)key), op -> this.execute(ORMapOperation.update(keys).with((RWORSetOperation)op))));
        }
        return this.getORMap(keys[0]).getRWORSet(Arrays.copyOfRange(keys, 1, keys.length));
    }

    @Override
    public ICCounter getCCounter(ByteString ... keys) {
        if (keys.length == 0) {
            throw new IllegalArgumentException("No key specified");
        }
        if (keys.length == 1) {
            return (ICCounter)this.subCRDTMap.get((Object)ORMapUtil.typedKey(keys[0], CausalCRDTType.cctr), key -> new CCounter(this.replica, this.fetchSubDotMap((ByteString)key), op -> this.execute(ORMapOperation.update(keys).with((CCounterOperation)op))));
        }
        return this.getORMap(keys[0]).getCCounter(Arrays.copyOfRange(keys, 1, keys.length));
    }

    @Override
    public IMVReg getMVReg(ByteString ... keys) {
        if (keys.length == 0) {
            throw new IllegalArgumentException("No key specified");
        }
        if (keys.length == 1) {
            return (IMVReg)this.subCRDTMap.get((Object)ORMapUtil.typedKey(keys[0], CausalCRDTType.mvreg), key -> new MVReg(this.replica, this.fetchSubDotFunc((ByteString)key), op -> this.execute(ORMapOperation.update(keys).with((MVRegOperation)op))));
        }
        return this.getORMap(keys[0]).getMVReg(Arrays.copyOfRange(keys, 1, keys.length));
    }

    @Override
    public IDWFlag getDWFlag(ByteString ... keys) {
        if (keys.length == 0) {
            throw new IllegalArgumentException("No key specified");
        }
        if (keys.length == 1) {
            return (IDWFlag)this.subCRDTMap.get((Object)ORMapUtil.typedKey(keys[0], CausalCRDTType.dwflag), key -> new DWFlag(this.replica, this.fetchSubDotSet((ByteString)key), op -> this.execute(ORMapOperation.update(keys).with((DWFlagOperation)op))));
        }
        return this.getORMap(keys[0]).getDWFlag(Arrays.copyOfRange(keys, 1, keys.length));
    }

    @Override
    public IEWFlag getEWFlag(ByteString ... keys) {
        if (keys.length == 0) {
            throw new IllegalArgumentException("No key specified");
        }
        if (keys.length == 1) {
            return (IEWFlag)this.subCRDTMap.get((Object)ORMapUtil.typedKey(keys[0], CausalCRDTType.ewflag), key -> new EWFlag(this.replica, this.fetchSubDotSet((ByteString)key), op -> this.execute(ORMapOperation.update(keys).with((EWFlagOperation)op))));
        }
        return this.getORMap(keys[0]).getEWFlag(Arrays.copyOfRange(keys, 1, keys.length));
    }

    @Override
    public IORMap getORMap(ByteString ... keys) {
        if (keys.length == 0) {
            throw new IllegalArgumentException("No key specified");
        }
        if (keys.length == 1) {
            return (IORMap)this.subCRDTMap.get((Object)ORMapUtil.typedKey(keys[0], CausalCRDTType.ormap), key -> new ORMap(this.replica, this.fetchSubDotMap((ByteString)key), op -> this.execute(ORMapOperation.update(keys).with((ORMapOperation)op))));
        }
        return this.getORMap(keys[0]).getORMap(Arrays.copyOfRange(keys, 1, keys.length));
    }

    @Override
    protected void handleInflation(Iterable<StateLattice> adds, Iterable<StateLattice> rems) {
        StateLattice val;
        ByteString key;
        HashMap eventsByKey = Maps.newHashMap();
        for (StateLattice stateLattice : adds) {
            assert (stateLattice.getStateTypeCase() == StateLattice.StateTypeCase.SINGLEMAP);
            key = stateLattice.getSingleMap().getKey();
            val = stateLattice.getSingleMap().getVal();
            eventsByKey.computeIfAbsent(key, k -> Lists.newArrayList((Object[])new List[]{Lists.newArrayList(), Lists.newArrayList()}));
            ((List)((List)eventsByKey.get(key)).get(0)).add(val);
        }
        for (StateLattice stateLattice : rems) {
            assert (stateLattice.getStateTypeCase() == StateLattice.StateTypeCase.SINGLEMAP);
            key = stateLattice.getSingleMap().getKey();
            val = stateLattice.getSingleMap().getVal();
            eventsByKey.computeIfAbsent(key, k -> Lists.newArrayList((Object[])new List[]{Lists.newArrayList(), Lists.newArrayList()}));
            ((List)((List)eventsByKey.get(key)).get(1)).add(val);
        }
        eventsByKey.forEach((k, v) -> {
            CausalCRDT subCRDT = (CausalCRDT)this.subCRDTMap.getIfPresent(k);
            if (subCRDT != null) {
                subCRDT.afterInflation((Iterable)v.get(0), (Iterable)v.get(1));
            }
        });
    }

    private CausalCRDT.DotStoreAccessor<IDotSet> fetchSubDotSet(ByteString key) {
        AtomicReference ref = new AtomicReference();
        return () -> (IDotSet)ref.updateAndGet(v -> {
            if (v == null || v.isBottom()) {
                v = ((IDotMap)this.dotStoreAccessor.fetch()).subDotSet(key).orElse(DotSet.BOTTOM);
            }
            return v;
        });
    }

    private CausalCRDT.DotStoreAccessor<IDotFunc> fetchSubDotFunc(ByteString key) {
        AtomicReference ref = new AtomicReference();
        return () -> (IDotFunc)ref.updateAndGet(v -> {
            if (v == null || v.isBottom()) {
                v = ((IDotMap)this.dotStoreAccessor.fetch()).subDotFunc(key).orElse(DotFunc.BOTTOM);
            }
            return v;
        });
    }

    private CausalCRDT.DotStoreAccessor<IDotMap> fetchSubDotMap(ByteString key) {
        AtomicReference ref = new AtomicReference();
        return () -> (IDotMap)ref.updateAndGet(v -> {
            if (v == null || v.isBottom()) {
                v = ((IDotMap)this.dotStoreAccessor.fetch()).subDotMap(key).orElse(DotMap.BOTTOM);
            }
            return v;
        });
    }
}

