/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.config;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import java.util.function.IntPredicate;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class CalciteSystemProperty<T> {
    private static final Properties PROPERTIES = CalciteSystemProperty.loadProperties();
    public static final CalciteSystemProperty<Boolean> DEBUG = CalciteSystemProperty.booleanProperty("calcite.debug", false);
    public static final CalciteSystemProperty<Boolean> COMMUTE = CalciteSystemProperty.booleanProperty("calcite.enable.join.commute", false);
    public static final CalciteSystemProperty<Boolean> ENABLE_COLLATION_TRAIT = CalciteSystemProperty.booleanProperty("calcite.enable.collation.trait", true);
    public static final CalciteSystemProperty<Boolean> ENABLE_ENUMERABLE = CalciteSystemProperty.booleanProperty("calcite.enable.enumerable", true);
    public static final CalciteSystemProperty<Boolean> ENUMERABLE_ENABLE_TABLESCAN_ARRAY = CalciteSystemProperty.booleanProperty("calcite.enable.enumerable.tablescan.array", false);
    public static final CalciteSystemProperty<Boolean> ENUMERABLE_ENABLE_TABLESCAN_MAP = CalciteSystemProperty.booleanProperty("calcite.enable.enumerable.tablescan.map", false);
    public static final CalciteSystemProperty<Boolean> ENUMERABLE_ENABLE_TABLESCAN_MULTISET = CalciteSystemProperty.booleanProperty("calcite.enable.enumerable.tablescan.multiset", false);
    public static final CalciteSystemProperty<Boolean> ENABLE_STREAM = CalciteSystemProperty.booleanProperty("calcite.enable.stream", true);
    public static final CalciteSystemProperty<Boolean> ENABLE_REX_DIGEST_NORMALIZE = CalciteSystemProperty.booleanProperty("calcite.enable.rexnode.digest.normalize", true);
    public static final CalciteSystemProperty<Boolean> STRICT = CalciteSystemProperty.booleanProperty("calcite.strict.sql", false);
    public static final CalciteSystemProperty<Boolean> DUMP_GRAPHVIZ = CalciteSystemProperty.booleanProperty("calcite.volcano.dump.graphviz", true);
    public static final CalciteSystemProperty<Boolean> DUMP_SETS = CalciteSystemProperty.booleanProperty("calcite.volcano.dump.sets", true);
    public static final CalciteSystemProperty<Boolean> TOPDOWN_OPT = CalciteSystemProperty.booleanProperty("calcite.planner.topdown.opt", false);
    public static final CalciteSystemProperty<Boolean> INTEGRATION_TEST = CalciteSystemProperty.booleanProperty("calcite.integrationTest", false);
    public static final CalciteSystemProperty<String> TEST_DB = CalciteSystemProperty.stringProperty("calcite.test.db", "HSQLDB", (Set<String>)ImmutableSet.of((Object)"HSQLDB", (Object)"H2", (Object)"MYSQL", (Object)"ORACLE", (Object)"POSTGRESQL", (Object)"STARROCKS", (Object[])new String[]{"DORIS"}));
    public static final CalciteSystemProperty<String> TEST_DATASET_PATH = new CalciteSystemProperty<String>("calcite.test.dataset", v -> {
        String[] dirs;
        if (v != null) {
            return v;
        }
        for (String s : dirs = new String[]{"../calcite-test-dataset", "../../calcite-test-dataset"}) {
            try {
                if (!new File(s).exists() || !new File(s, "vm").exists()) continue;
                return s;
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return ".";
    });
    public static final CalciteSystemProperty<Boolean> TEST_ARROW = CalciteSystemProperty.booleanProperty("calcite.test.arrow", true);
    public static final CalciteSystemProperty<Boolean> TEST_MONGODB = CalciteSystemProperty.booleanProperty("calcite.test.mongodb", true);
    public static final CalciteSystemProperty<Boolean> TEST_SPLUNK = CalciteSystemProperty.booleanProperty("calcite.test.splunk", false);
    public static final CalciteSystemProperty<Boolean> TEST_DRUID = CalciteSystemProperty.booleanProperty("calcite.test.druid", false);
    public static final CalciteSystemProperty<Boolean> TEST_CASSANDRA = CalciteSystemProperty.booleanProperty("calcite.test.cassandra", true);
    public static final CalciteSystemProperty<Boolean> TEST_INNODB = CalciteSystemProperty.booleanProperty("calcite.test.innodb", true);
    public static final CalciteSystemProperty<Boolean> TEST_REDIS = CalciteSystemProperty.booleanProperty("calcite.test.redis", true);
    public static final CalciteSystemProperty<Boolean> TEST_WITH_DOCKER_CONTAINER = CalciteSystemProperty.booleanProperty("calcite.test.docker", true);
    public static final CalciteSystemProperty<@Nullable String> TEST_FOODMART_QUERY_IDS = new CalciteSystemProperty("calcite.ids", Function.identity());
    public static final CalciteSystemProperty<Boolean> ALLOW_INFINITE_COST_CONVERTERS = CalciteSystemProperty.booleanProperty("calcite.opt.allowInfiniteCostConverters", true);
    public static final CalciteSystemProperty<String> DEFAULT_CHARSET = CalciteSystemProperty.stringProperty("calcite.default.charset", "ISO-8859-1");
    public static final CalciteSystemProperty<String> DEFAULT_NATIONAL_CHARSET = CalciteSystemProperty.stringProperty("calcite.default.nationalcharset", "ISO-8859-1");
    public static final CalciteSystemProperty<String> DEFAULT_COLLATION = CalciteSystemProperty.stringProperty("calcite.default.collation.name", "ISO-8859-1$en_US");
    public static final CalciteSystemProperty<String> DEFAULT_COLLATION_STRENGTH = CalciteSystemProperty.stringProperty("calcite.default.collation.strength", "primary");
    public static final CalciteSystemProperty<Integer> METADATA_HANDLER_CACHE_MAXIMUM_SIZE = CalciteSystemProperty.intProperty("calcite.metadata.handler.cache.maximum.size", 1000);
    public static final CalciteSystemProperty<Integer> BINDABLE_CACHE_MAX_SIZE = CalciteSystemProperty.intProperty("calcite.bindable.cache.maxSize", 0, v -> v >= 0);
    public static final CalciteSystemProperty<Integer> BINDABLE_CACHE_CONCURRENCY_LEVEL = CalciteSystemProperty.intProperty("calcite.bindable.cache.concurrencyLevel", 1, v -> v >= 1);
    public static final CalciteSystemProperty<Integer> FUNCTION_LEVEL_CACHE_MAX_SIZE = CalciteSystemProperty.intProperty("calcite.function.cache.maxSize", 1000, v -> v >= 0);
    public static final CalciteSystemProperty<Integer> JOIN_SELECTOR_COMPACT_CODE_THRESHOLD = CalciteSystemProperty.intProperty("calcite.join.selector.compact.code.threshold", 100);
    private final T value;

    private static CalciteSystemProperty<Boolean> booleanProperty(String key, boolean defaultValue) {
        return new CalciteSystemProperty<Boolean>(key, v -> v == null ? defaultValue : v.isEmpty() || Boolean.parseBoolean(v));
    }

    private static CalciteSystemProperty<Integer> intProperty(String key, int defaultValue) {
        return CalciteSystemProperty.intProperty(key, defaultValue, v -> true);
    }

    private static CalciteSystemProperty<Integer> intProperty(String key, int defaultValue, IntPredicate valueChecker) {
        return new CalciteSystemProperty<Integer>(key, v -> {
            if (v == null) {
                return defaultValue;
            }
            try {
                int intVal = Integer.parseInt(v);
                return valueChecker.test(intVal) ? intVal : defaultValue;
            }
            catch (NumberFormatException nfe) {
                return defaultValue;
            }
        });
    }

    private static CalciteSystemProperty<String> stringProperty(String key, String defaultValue) {
        return new CalciteSystemProperty<String>(key, v -> v == null ? defaultValue : v);
    }

    private static CalciteSystemProperty<String> stringProperty(String key, String defaultValue, Set<String> allowedValues) {
        return new CalciteSystemProperty<String>(key, v -> {
            if (v == null) {
                return defaultValue;
            }
            String normalizedValue = v.toUpperCase(Locale.ROOT);
            return allowedValues.contains(normalizedValue) ? normalizedValue : defaultValue;
        });
    }

    private static Properties loadProperties() {
        Properties saffronProperties = new Properties();
        ClassLoader classLoader = (ClassLoader)MoreObjects.firstNonNull((Object)Thread.currentThread().getContextClassLoader(), (Object)CalciteSystemProperty.class.getClassLoader());
        try (InputStream stream = Objects.requireNonNull(classLoader, "classLoader").getResourceAsStream("saffron.properties");){
            if (stream != null) {
                saffronProperties.load(stream);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("while reading from saffron.properties file", e);
        }
        catch (SecurityException e) {
            // empty catch block
        }
        Properties allProperties = new Properties();
        Stream.concat(saffronProperties.entrySet().stream(), System.getProperties().entrySet().stream()).forEach(prop -> {
            String deprecatedKey = (String)prop.getKey();
            String newKey = deprecatedKey.replace("net.sf.saffron.", "calcite.").replace("saffron.", "calcite.");
            if (newKey.startsWith("calcite.")) {
                allProperties.setProperty(newKey, (String)prop.getValue());
            }
        });
        return allProperties;
    }

    private CalciteSystemProperty(String key, Function<? super @Nullable String, ? extends T> valueParser) {
        this.value = valueParser.apply(PROPERTIES.getProperty(key));
    }

    public T value() {
        return this.value;
    }
}

