/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.config;

public enum H2Param {
    HEADER_TABLE_SIZE(1),
    ENABLE_PUSH(2),
    MAX_CONCURRENT_STREAMS(3),
    INITIAL_WINDOW_SIZE(4),
    MAX_FRAME_SIZE(5),
    MAX_HEADER_LIST_SIZE(6),
    SETTINGS_NO_RFC7540_PRIORITIES(9);

    int code;
    private static final H2Param[] LOOKUP_TABLE;

    private H2Param(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public static H2Param valueOf(int code) {
        if (code < 0 || code >= LOOKUP_TABLE.length) {
            return null;
        }
        return LOOKUP_TABLE[code];
    }

    public static String toString(int code) {
        if (code < 0 || code >= LOOKUP_TABLE.length || LOOKUP_TABLE[code] == null) {
            return Integer.toString(code);
        }
        return LOOKUP_TABLE[code].name();
    }

    static {
        int max = 0;
        for (H2Param p : H2Param.values()) {
            if (p.code <= max) continue;
            max = p.code;
        }
        LOOKUP_TABLE = new H2Param[max + 1];
        H2Param[] h2ParamArray = H2Param.values();
        int n = h2ParamArray.length;
        for (int i = 0; i < n; ++i) {
            H2Param p;
            H2Param.LOOKUP_TABLE[p.code] = p = h2ParamArray[i];
        }
    }
}

