/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.testing.nio;

import org.apache.hc.core5.reactor.IOReactorMetricsListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingReactorMetricsListener
implements IOReactorMetricsListener {
    public static final IOReactorMetricsListener INSTANCE = new LoggingReactorMetricsListener();
    private final Logger logger = LoggerFactory.getLogger((String)"org.apache.hc.core5.http.pool");

    public void onThreadPoolStatus(int activeThreads, int pendingConnections) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Active threads: {}, Pending connections: {}", (Object)activeThreads, (Object)pendingConnections);
        }
    }

    public void onThreadPoolSaturation(double saturationPercentage) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Thread pool saturation: {}%", (Object)saturationPercentage);
        }
    }

    public void onResourceStarvationDetected() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Resource starvation detected!");
        }
    }

    public void onQueueWaitTime(long averageWaitTimeMillis) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Average queue wait time: {} ms", (Object)averageWaitTimeMillis);
        }
    }
}

