/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.anthropic;

import dev.langchain4j.model.anthropic.AnthropicRequestLoggingInterceptor;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AnthropicResponseLoggingInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(AnthropicResponseLoggingInterceptor.class);

    AnthropicResponseLoggingInterceptor() {
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        Response response = chain.proceed(request);
        this.log(response);
        return response;
    }

    private void log(Response response) {
        try {
            log.debug("Response:\n- status code: {}\n- headers: {}\n- body: {}", new Object[]{response.code(), AnthropicRequestLoggingInterceptor.getHeaders(response.headers()), this.getBody(response)});
        }
        catch (Exception e) {
            log.warn("Error while logging response: {}", (Object)e.getMessage());
        }
    }

    private String getBody(Response response) throws IOException {
        return AnthropicResponseLoggingInterceptor.isEventStream(response) ? "[skipping response body due to streaming]" : response.peekBody(Long.MAX_VALUE).string();
    }

    private static boolean isEventStream(Response response) {
        String contentType = response.header("Content-Type");
        return contentType != null && contentType.contains("event-stream");
    }
}

