/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.databases.cratedb;

import org.apache.hop.core.database.DatabaseMetaPlugin;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.databases.postgresql.PostgreSqlDatabaseMeta;

@DatabaseMetaPlugin(type="CRATEDB", typeDescription="CrateDB", image="cratedb.svg", documentationUrl="/database/databases/cratedb.html", classLoaderGroup="crate-db")
@GuiPlugin(id="GUI-CrateDBDatabaseMeta")
public class CrateDBDatabaseMeta
extends PostgreSqlDatabaseMeta {
    private static final String SEQUENCES_NOT_SUPPORTED = "CrateDB does not support sequences";

    public String getDriverClass() {
        return "io.crate.client.jdbc.CrateDriver";
    }

    public String getURL(String hostname, String port, String databaseName) {
        return "jdbc:crate://" + hostname + ":" + port + "/" + databaseName;
    }

    public boolean isSupportsSequences() {
        return false;
    }

    public boolean isSupportsSequenceNoMaxValueOption() {
        return false;
    }

    public boolean isSupportsAutoInc() {
        return false;
    }

    public String[] getReservedWords() {
        return new String[]{"ADD", "ALL", "ALTER", "AND", "ANY", "ARRAY", "AS", "ASC", "BETWEEN", "BY", "CALLED", "CASE", "CAST", "COLUMN", "CONSTRAINT", "COSTS", "CREATE", "CROSS", "CURRENT_DATE", "CURRENT_SCHEMA", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "DEFAULT", "DELETE", "DENY", "DESC", "DESCRIBE", "DIRECTORY", "DISTINCT", "DROP", "ELSE", "END", "ESCAPE", "EXCEPT", "EXISTS", "EXTRACT", "FALSE", "FIRST", "FOR", "FROM", "FULL", "FUNCTION", "GRANT", "GROUP", "HAVING", "IF", "IN", "INDEX", "INNER", "INPUT", "INSERT", "INTERSECT", "INTO", "IS", "JOIN", "LAST", "LEFT", "LIKE", "LIMIT", "MATCH", "NATURAL", "NOT", "NULL", "NULLS", "OBJECT", "OFFSET", "ON", "OR", "ORDER", "OUTER", "PERSISTENT", "RECURSIVE", "RESET", "RETURNS", "REVOKE", "RIGHT", "SELECT", "SESSION_USER", "SET", "SOME", "STRATIFY", "TABLE", "THEN", "TRANSIENT", "TRUE", "TRY_CAST", "UNBOUNDED", "UNION", "UPDATE", "USER", "USING", "WHEN", "WHERE", "WITH"};
    }

    public String getExtraOptionsHelpText() {
        return "https://cratedb.com/docs/jdbc/en/latest/connect.html#connection-properties";
    }

    public String getSqlListOfSequences() {
        throw new UnsupportedOperationException(SEQUENCES_NOT_SUPPORTED);
    }

    public String getSqlNextSequenceValue(String sequenceName) {
        throw new UnsupportedOperationException(SEQUENCES_NOT_SUPPORTED);
    }

    public String getSqlCurrentSequenceValue(String sequenceName) {
        throw new UnsupportedOperationException(SEQUENCES_NOT_SUPPORTED);
    }

    public String getSqlSequenceExists(String sequenceName) {
        throw new UnsupportedOperationException(SEQUENCES_NOT_SUPPORTED);
    }

    public String getFieldDefinition(IValueMeta v, String tk, String pk, boolean useAutoinc, boolean addFieldName, boolean addCr) {
        int type = v.getType();
        switch (type) {
            case 1: 
            case 5: 
            case 6: {
                Object retval = "";
                String fieldname = v.getName();
                int length = v.getLength();
                if (addFieldName) {
                    retval = (String)retval + fieldname + " ";
                }
                retval = fieldname.equalsIgnoreCase(tk) || fieldname.equalsIgnoreCase(pk) ? (String)retval + "BIGSERIAL" : (type == 5 ? (length > 9 ? (String)retval + "BIGINT" : (length > 4 ? (String)retval + "INTEGER" : (String)retval + "SMALLINT")) : (type == 6 ? (String)retval + "DOUBLE PRECISION" : (String)retval + "DOUBLE PRECISION"));
                return retval;
            }
        }
        return super.getFieldDefinition(v, tk, pk, useAutoinc, addFieldName, addCr);
    }

    public String getSqlLockTables(String[] tableNames) {
        throw new UnsupportedOperationException("CrateDB does not support locking tables");
    }

    public String getSqlUnlockTables(String[] tableName) {
        throw new UnsupportedOperationException("CrateDB does not support locking tables");
    }

    public void addDefaultOptions() {
        this.setSupportsBooleanDataType(true);
        this.setSupportsTimestampDataType(true);
    }
}

