/*
 * Decompiled with CFR 0.152.
 */
package com.addthis.metrics.reporter.config;

import com.addthis.metrics.reporter.config.AbstractGraphiteReporterConfig;
import com.addthis.metrics.reporter.config.AbstractHostPortReporterConfig;
import com.addthis.metrics.reporter.config.HostPort;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractInfluxDBReporterConfig
extends AbstractHostPortReporterConfig {
    private static final Logger log = LoggerFactory.getLogger(AbstractGraphiteReporterConfig.class);
    @NotNull
    private String protocol;
    @NotNull
    private String auth;
    @NotNull
    private String dbName;
    @NotNull
    @Min(value=0L)
    private int connectionTimeout;
    @NotNull
    @Min(value=0L)
    private int readTimeout;
    @NotNull
    private Map<String, String> tags;
    private Map<String, String> resolvedTags;

    @Override
    public List<HostPort> getFullHostList() {
        return this.getHostListAndStringList();
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getAuth() {
        return this.auth;
    }

    public void setAuth(String auth) {
        this.auth = auth;
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
        this.resolvedTags = new HashMap<String, String>(tags.size());
        for (Map.Entry<String, String> entry : tags.entrySet()) {
            this.resolvedTags.put(entry.getKey(), this.resolvePrefix(entry.getValue()));
        }
    }

    public Map<String, String> getResolvedTags() {
        return this.resolvedTags;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }
}

