/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2;

import com.amazonaws.services.dynamodbv2.LockItemFactory;
import com.amazonaws.services.dynamodbv2.LockItemPaginatedIterator;
import java.util.Objects;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.QueryRequest;
import software.amazon.awssdk.services.dynamodb.model.QueryResponse;

final class LockItemPaginatedQueryIterator
extends LockItemPaginatedIterator {
    private final DynamoDbClient dynamoDB;
    private volatile QueryRequest queryRequest;
    private final LockItemFactory lockItemFactory;
    private volatile QueryResponse queryResponse = null;

    LockItemPaginatedQueryIterator(DynamoDbClient dynamoDB, QueryRequest queryRequest, LockItemFactory lockItemFactory) {
        this.dynamoDB = Objects.requireNonNull(dynamoDB, "dynamoDB must not be null");
        this.queryRequest = Objects.requireNonNull(queryRequest, "queryRequest must not be null");
        this.lockItemFactory = Objects.requireNonNull(lockItemFactory, "lockItemFactory must not be null");
    }

    @Override
    protected boolean hasAnotherPageToLoad() {
        if (!this.hasLoadedFirstPage()) {
            return true;
        }
        return this.queryResponse.lastEvaluatedKey() != null && !this.queryResponse.lastEvaluatedKey().isEmpty();
    }

    @Override
    protected boolean hasLoadedFirstPage() {
        return this.queryResponse != null;
    }

    @Override
    protected void loadNextPageIntoResults() {
        this.queryResponse = this.dynamoDB.query(this.queryRequest);
        this.currentPageResults = this.queryResponse.items().stream().map(this.lockItemFactory::create).collect(Collectors.toList());
        this.currentPageResultsIndex = 0;
        this.queryRequest = (QueryRequest)QueryRequest.builder().tableName(this.queryRequest.tableName()).keyConditionExpression(this.queryRequest.keyConditionExpression()).expressionAttributeNames(this.queryRequest.expressionAttributeNames()).expressionAttributeValues(this.queryRequest.expressionAttributeValues()).exclusiveStartKey(this.queryResponse.lastEvaluatedKey()).build();
    }
}

