/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.api.internal;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnvUtils {
    private static final Logger LOG = LoggerFactory.getLogger(EnvUtils.class);

    public static String getLocalhostNameOrAddress(boolean returnAddress) {
        try {
            for (NetworkInterface networkInterface : Collections.list(NetworkInterface.getNetworkInterfaces())) {
                for (InetAddress inetAddress : Collections.list(networkInterface.getInetAddresses())) {
                    if (inetAddress.isLoopbackAddress()) continue;
                    if (returnAddress) {
                        return inetAddress.getHostAddress();
                    }
                    return inetAddress.getCanonicalHostName();
                }
            }
        }
        catch (Exception e) {
            LOG.error("Failed to get local host name or address", (Throwable)e);
        }
        return "";
    }
}

