/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.metrics;

import java.io.Serializable;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Metric;
import org.apache.beam.sdk.metrics.MetricName;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.metrics.MetricsContainer;
import org.apache.beam.sdk.metrics.MetricsEnvironment;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@Internal
public class DelegatingCounter
implements Metric,
Counter,
Serializable {
    private final @UnknownKeyFor @NonNull @Initialized MetricName name;
    private final @UnknownKeyFor @NonNull @Initialized boolean processWideContainer;
    private final @UnknownKeyFor @NonNull @Initialized boolean perWorkerCounter;

    public DelegatingCounter(@UnknownKeyFor @NonNull @Initialized MetricName name) {
        this(name, false, false);
    }

    public DelegatingCounter(@UnknownKeyFor @NonNull @Initialized MetricName name, @UnknownKeyFor @NonNull @Initialized boolean processWideContainer) {
        this(name, processWideContainer, false);
    }

    public DelegatingCounter(@UnknownKeyFor @NonNull @Initialized MetricName name, @UnknownKeyFor @NonNull @Initialized boolean processWideContainer, @UnknownKeyFor @NonNull @Initialized boolean perWorkerCounter) {
        this.name = name;
        this.processWideContainer = processWideContainer;
        this.perWorkerCounter = perWorkerCounter;
    }

    @Override
    public void inc() {
        this.inc(1L);
    }

    @Override
    public void inc(@UnknownKeyFor @NonNull @Initialized long n) {
        MetricsContainer container;
        if (Metrics.MetricsFlag.counterDisabled()) {
            return;
        }
        MetricsContainer metricsContainer = container = this.processWideContainer ? MetricsEnvironment.getProcessWideContainer() : MetricsEnvironment.getCurrentContainer();
        if (container == null) {
            return;
        }
        if (this.perWorkerCounter) {
            container.getPerWorkerCounter(this.name).inc(n);
        } else {
            container.getCounter(this.name).inc(n);
        }
    }

    @Override
    public void dec() {
        this.inc(-1L);
    }

    @Override
    public void dec(@UnknownKeyFor @NonNull @Initialized long n) {
        this.inc(-1L * n);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized MetricName getName() {
        return this.name;
    }
}

