/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.perspective.configuration.tabs;

import org.apache.hop.core.Const;
import org.apache.hop.core.config.HopConfig;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.gui.plugin.tab.GuiTab;
import org.apache.hop.core.util.EnvUtil;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.i18n.GlobalMessages;
import org.apache.hop.i18n.LanguageChoice;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.hopgui.HopGui;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

@GuiPlugin
public class ConfigGuiOptionsTab {
    private static final Class<?> PKG = BaseDialog.class;
    public static final String ENTER_OPTIONS_DIALOG_ENTER_NUMBER_HINT = "EnterOptionsDialog.EnterNumber.Hint";
    private FontData defaultFontData;
    private Font defaultFont;
    private FontData fixedFontData;
    private Font fixedFont;
    private FontData graphFontData;
    private Font graphFont;
    private FontData noteFontData;
    private Font noteFont;
    private Canvas wDefaultCanvas;
    private Canvas wFixedCanvas;
    private Canvas wGraphCanvas;
    private Canvas wNoteCanvas;
    private Text wIconSize;
    private Text wLineWidth;
    private Text wMiddlePct;
    private Combo wGlobalZoom;
    private Text wGridSize;
    private Label wlGridSize;
    private Button wDarkMode;
    private Button wShowCanvasGrid;
    private Button wHideViewport;
    private Button wUseDoubleClick;
    private Button wDrawBorderAroundCanvasNames;
    private Button wDisableZoomScrolling;
    private Button wHideMenuBar;
    private Button wShowTableViewToolbar;
    private Combo wDefaultLocale;
    private boolean isReloading = false;
    private boolean isInitializing = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadValues() {
        if (this.wIconSize == null || this.wIconSize.isDisposed()) {
            return;
        }
        this.isReloading = true;
        try {
            PropsUi props = PropsUi.getInstance();
            this.defaultFontData = props.getDefaultFont();
            this.fixedFontData = props.getFixedFont();
            this.graphFontData = props.getGraphFont();
            this.noteFontData = props.getNoteFont();
            Shell shell = this.wIconSize.getShell();
            Display display = shell.getDisplay();
            if (this.defaultFont != null && !this.defaultFont.isDisposed()) {
                this.defaultFont.dispose();
            }
            this.defaultFont = new Font((Device)display, this.defaultFontData);
            if (this.fixedFont != null && !this.fixedFont.isDisposed()) {
                this.fixedFont.dispose();
            }
            this.fixedFont = new Font((Device)display, this.fixedFontData);
            if (this.graphFont != null && !this.graphFont.isDisposed()) {
                this.graphFont.dispose();
            }
            this.graphFont = new Font((Device)display, this.graphFontData);
            if (this.noteFont != null && !this.noteFont.isDisposed()) {
                this.noteFont.dispose();
            }
            this.noteFont = new Font((Device)display, this.noteFontData);
            this.wDefaultCanvas.redraw();
            this.wFixedCanvas.redraw();
            this.wGraphCanvas.redraw();
            this.wNoteCanvas.redraw();
            this.wIconSize.setText(Integer.toString(props.getIconSize()));
            this.wLineWidth.setText(Integer.toString(props.getLineWidth()));
            this.wMiddlePct.setText(Integer.toString(props.getMiddlePct()));
            this.wGridSize.setText(Integer.toString(props.getCanvasGridSize()));
            this.wShowCanvasGrid.setSelection(props.isShowCanvasGridEnabled());
            this.wHideViewport.setSelection(!props.isHideViewportEnabled());
            this.wUseDoubleClick.setSelection(props.useDoubleClick());
            this.wDrawBorderAroundCanvasNames.setSelection(props.isBorderDrawnAroundCanvasNames());
            this.wHideMenuBar.setSelection(props.isHidingMenuBar());
            this.wShowTableViewToolbar.setSelection(props.isShowTableViewToolbar());
            this.wDarkMode.setSelection(props.isDarkMode());
            String globalZoomFactor = Integer.toString((int)(props.getGlobalZoomFactor() * 100.0)) + "%";
            this.wGlobalZoom.setText(globalZoomFactor);
            int idxDefault = Const.indexOfString((String)LanguageChoice.getInstance().getDefaultLocale().toString(), (String[])GlobalMessages.localeCodes);
            if (idxDefault >= 0) {
                this.wDefaultLocale.select(idxDefault);
            }
        }
        finally {
            this.isReloading = false;
        }
    }

    @GuiTab(id="10100-config-perspective-gui-options-tab", parentId="ConfigurationPerspective.Tabs.ID", description="GUI options tab")
    public void addGuiOptionsTab(CTabFolder wTabFolder) {
        this.isInitializing = true;
        Shell shell = wTabFolder.getShell();
        PropsUi props = PropsUi.getInstance();
        int margin = PropsUi.getMargin();
        CTabItem wLookTab = new CTabItem(wTabFolder, 0);
        wLookTab.setFont(GuiResource.getInstance().getFontDefault());
        wLookTab.setText(BaseMessages.getString(PKG, (String)"EnterOptionsDialog.LookAndFeel.Label", (String[])new String[0]));
        wLookTab.setImage(GuiResource.getInstance().getImageColor());
        ScrolledComposite sLookComp = new ScrolledComposite((Composite)wTabFolder, 768);
        sLookComp.setLayout((Layout)new FillLayout());
        Composite wLookComp = new Composite((Composite)sLookComp, 0);
        PropsUi.setLook((Widget)wLookComp);
        FormLayout lookLayout = new FormLayout();
        lookLayout.marginWidth = PropsUi.getFormMargin();
        lookLayout.marginHeight = PropsUi.getFormMargin();
        wLookComp.setLayout((Layout)lookLayout);
        this.defaultFontData = props.getDefaultFont();
        this.defaultFont = new Font((Device)shell.getDisplay(), this.defaultFontData);
        this.fixedFontData = props.getFixedFont();
        this.fixedFont = new Font((Device)shell.getDisplay(), this.fixedFontData);
        this.graphFontData = props.getGraphFont();
        this.graphFont = new Font((Device)shell.getDisplay(), this.graphFontData);
        this.noteFontData = props.getNoteFont();
        this.noteFont = new Font((Device)shell.getDisplay(), this.noteFontData);
        Combo lastControl = null;
        Control[] defaultLocaleControls = this.createComboField(wLookComp, "EnterOptionsDialog.DefaultLocale.Label", null, GlobalMessages.localeDescr, (Control)lastControl, margin);
        this.wDefaultLocale = (Combo)defaultLocaleControls[1];
        int idxDefault = Const.indexOfString((String)LanguageChoice.getInstance().getDefaultLocale().toString(), (String[])GlobalMessages.localeCodes);
        if (idxDefault >= 0) {
            this.wDefaultLocale.select(idxDefault);
        }
        lastControl = this.wDefaultLocale;
        this.wHideMenuBar = this.createCheckbox(wLookComp, "EnterOptionsDialog.HideMenuBar.Label", "EnterOptionsDialog.HideMenuBar.ToolTip", props.isHidingMenuBar(), (Control)lastControl, margin);
        lastControl = this.wHideMenuBar;
        this.wDarkMode = this.createCheckbox(wLookComp, "EnterOptionsDialog.DarkMode.Label", null, props.isDarkMode(), (Control)lastControl, margin);
        this.wDarkMode.setEnabled(Const.isWindows());
        lastControl = this.wDarkMode;
        ExpandBar appearanceExpandBar = new ExpandBar(wLookComp, 512);
        PropsUi.setLook((Widget)appearanceExpandBar);
        FormData fdAppearanceExpandBar = new FormData();
        fdAppearanceExpandBar.left = new FormAttachment(0, 0);
        fdAppearanceExpandBar.right = new FormAttachment(100, 0);
        fdAppearanceExpandBar.top = new FormAttachment((Control)lastControl, 2 * margin);
        appearanceExpandBar.setLayoutData((Object)fdAppearanceExpandBar);
        Composite appearanceContent = new Composite((Composite)appearanceExpandBar, 0);
        PropsUi.setLook((Widget)appearanceContent);
        FormLayout appearanceLayout = new FormLayout();
        appearanceLayout.marginWidth = PropsUi.getFormMargin();
        appearanceLayout.marginHeight = PropsUi.getFormMargin();
        appearanceContent.setLayout((Layout)appearanceLayout);
        Combo lastAppearanceControl = null;
        Control[] globalZoomControls = this.createComboField(appearanceContent, "EnterOptionsDialog.GlobalZoom.Label", null, PropsUi.getGlobalZoomFactorLevels(), (Control)lastAppearanceControl, margin);
        this.wGlobalZoom = (Combo)globalZoomControls[1];
        String globalZoomFactor = Integer.toString((int)(props.getGlobalZoomFactor() * 100.0)) + "%";
        this.wGlobalZoom.setText(globalZoomFactor);
        lastAppearanceControl = this.wGlobalZoom;
        Control[] iconSizeControls = this.createTextField(appearanceContent, "EnterOptionsDialog.IconSize.Label", null, Integer.toString(props.getIconSize()), (Control)lastAppearanceControl, margin);
        this.wIconSize = (Text)iconSizeControls[1];
        this.wIconSize.setMessage(BaseMessages.getString(PKG, (String)ENTER_OPTIONS_DIALOG_ENTER_NUMBER_HINT, (String[])new String[0]));
        this.wIconSize.addListener(25, e -> {
            String currentText = ((Text)e.widget).getText();
            String newText = currentText.substring(0, e.start) + e.text + currentText.substring(e.end);
            if (!newText.isEmpty() && !newText.matches("\\d+")) {
                e.doit = false;
            }
        });
        lastAppearanceControl = this.wIconSize;
        Control[] lineWidthControls = this.createTextField(appearanceContent, "EnterOptionsDialog.LineWidth.Label", null, Integer.toString(props.getLineWidth()), (Control)lastAppearanceControl, margin);
        this.wLineWidth = (Text)lineWidthControls[1];
        this.wLineWidth.setMessage(BaseMessages.getString(PKG, (String)ENTER_OPTIONS_DIALOG_ENTER_NUMBER_HINT, (String[])new String[0]));
        this.wLineWidth.addListener(25, e -> {
            String currentText = ((Text)e.widget).getText();
            String newText = currentText.substring(0, e.start) + e.text + currentText.substring(e.end);
            if (!newText.isEmpty() && !newText.matches("\\d+")) {
                e.doit = false;
            }
        });
        lastAppearanceControl = this.wLineWidth;
        Control[] middlePctControls = this.createTextField(appearanceContent, "EnterOptionsDialog.DialogMiddlePercentage.Label", null, Integer.toString(props.getMiddlePct()), (Control)lastAppearanceControl, margin);
        this.wMiddlePct = (Text)middlePctControls[1];
        this.wMiddlePct.setMessage(BaseMessages.getString(PKG, (String)ENTER_OPTIONS_DIALOG_ENTER_NUMBER_HINT, (String[])new String[0]));
        this.wMiddlePct.addListener(25, e -> {
            String currentText = ((Text)e.widget).getText();
            String newText = currentText.substring(0, e.start) + e.text + currentText.substring(e.end);
            if (!newText.isEmpty() && !newText.matches("\\d+")) {
                e.doit = false;
            }
        });
        ExpandItem appearanceItem = new ExpandItem(appearanceExpandBar, 0);
        appearanceItem.setText(BaseMessages.getString(PKG, (String)"EnterOptionsDialog.Section.GeneralAppearance", (String[])new String[0]));
        appearanceItem.setControl((Control)appearanceContent);
        appearanceItem.setHeight(appearanceContent.computeSize((int)-1, (int)-1).y);
        appearanceItem.setExpanded(true);
        appearanceExpandBar.addListener(17, e -> Display.getDefault().asyncExec(() -> {
            if (!wLookComp.isDisposed() && !sLookComp.isDisposed()) {
                wLookComp.layout();
                sLookComp.setMinHeight(wLookComp.computeSize((int)-1, (int)-1).y);
            }
        }));
        appearanceExpandBar.addListener(18, e -> Display.getDefault().asyncExec(() -> {
            if (!wLookComp.isDisposed() && !sLookComp.isDisposed()) {
                wLookComp.layout();
                sLookComp.setMinHeight(wLookComp.computeSize((int)-1, (int)-1).y);
            }
        }));
        lastControl = appearanceExpandBar;
        ExpandBar fontsExpandBar = new ExpandBar(wLookComp, 512);
        PropsUi.setLook((Widget)fontsExpandBar);
        FormData fdFontsExpandBar = new FormData();
        fdFontsExpandBar.left = new FormAttachment(0, 0);
        fdFontsExpandBar.right = new FormAttachment(100, 0);
        fdFontsExpandBar.top = new FormAttachment((Control)lastControl, 2 * margin);
        fontsExpandBar.setLayoutData((Object)fdFontsExpandBar);
        Composite fontsContent = new Composite((Composite)fontsExpandBar, 0);
        PropsUi.setLook((Widget)fontsContent);
        FormLayout fontsLayout = new FormLayout();
        fontsLayout.marginWidth = PropsUi.getFormMargin();
        fontsLayout.marginHeight = PropsUi.getFormMargin();
        fontsContent.setLayout((Layout)fontsLayout);
        Canvas lastFontControl = null;
        Control[] defaultFontControls = this.createFontPicker(fontsContent, "EnterOptionsDialog.DefaultFont.Label", shell, (Control)lastFontControl, margin);
        this.wDefaultCanvas = (Canvas)defaultFontControls[0];
        this.wDefaultCanvas.addPaintListener(this::paintDefaultFont);
        this.wDefaultCanvas.addListener(3, e -> this.editDefaultFont(shell));
        Button wbDefaultFont = (Button)defaultFontControls[1];
        wbDefaultFont.addListener(13, e -> this.editDefaultFont(shell));
        Button wdDefaultFont = (Button)defaultFontControls[2];
        wdDefaultFont.addListener(13, e -> this.resetDefaultFont(shell));
        lastFontControl = this.wDefaultCanvas;
        Control[] fixedFontControls = this.createFontPicker(fontsContent, "EnterOptionsDialog.FixedWidthFont.Label", shell, (Control)lastFontControl, margin);
        this.wFixedCanvas = (Canvas)fixedFontControls[0];
        this.wFixedCanvas.addPaintListener(this::paintFixedFont);
        this.wFixedCanvas.addListener(3, e -> this.editFixedFont(shell));
        Button wbFixedFont = (Button)fixedFontControls[1];
        wbFixedFont.addListener(13, e -> this.editFixedFont(shell));
        Button wdFixedFont = (Button)fixedFontControls[2];
        wdFixedFont.addListener(13, e -> this.resetFixedFont(shell));
        lastFontControl = this.wFixedCanvas;
        Control[] graphFontControls = this.createFontPicker(fontsContent, "EnterOptionsDialog.GraphFont.Label", shell, (Control)lastFontControl, margin);
        this.wGraphCanvas = (Canvas)graphFontControls[0];
        this.wGraphCanvas.addPaintListener(this::drawGraphFont);
        this.wGraphCanvas.addListener(3, e -> this.editGraphFont(shell));
        Button wbGraphFont = (Button)graphFontControls[1];
        wbGraphFont.addListener(13, e -> this.editGraphFont(shell));
        Button wdGraphFont = (Button)graphFontControls[2];
        wdGraphFont.addListener(13, e -> this.resetGraphFont(shell, props));
        lastFontControl = this.wGraphCanvas;
        Control[] noteFontControls = this.createFontPicker(fontsContent, "EnterOptionsDialog.NoteFont.Label", shell, (Control)lastFontControl, margin);
        this.wNoteCanvas = (Canvas)noteFontControls[0];
        this.wNoteCanvas.addPaintListener(this::paintNoteFont);
        this.wNoteCanvas.addListener(3, e -> this.editNoteFont(shell));
        Button wbNoteFont = (Button)noteFontControls[1];
        wbNoteFont.addListener(13, e -> this.editNoteFont(shell));
        Button wdNoteFont = (Button)noteFontControls[2];
        wdNoteFont.addListener(13, e -> this.resetNoteFont(e, props, shell.getDisplay()));
        ExpandItem fontsItem = new ExpandItem(fontsExpandBar, 0);
        fontsItem.setText(BaseMessages.getString(PKG, (String)"EnterOptionsDialog.Section.Fonts", (String[])new String[0]));
        fontsItem.setControl((Control)fontsContent);
        fontsItem.setHeight(fontsContent.computeSize((int)-1, (int)-1).y);
        fontsItem.setExpanded(true);
        fontsExpandBar.addListener(17, e -> Display.getDefault().asyncExec(() -> {
            if (!wLookComp.isDisposed() && !sLookComp.isDisposed()) {
                wLookComp.layout();
                sLookComp.setMinHeight(wLookComp.computeSize((int)-1, (int)-1).y);
            }
        }));
        fontsExpandBar.addListener(18, e -> Display.getDefault().asyncExec(() -> {
            if (!wLookComp.isDisposed() && !sLookComp.isDisposed()) {
                wLookComp.layout();
                sLookComp.setMinHeight(wLookComp.computeSize((int)-1, (int)-1).y);
            }
        }));
        lastControl = fontsExpandBar;
        ExpandBar canvasExpandBar = new ExpandBar(wLookComp, 512);
        PropsUi.setLook((Widget)canvasExpandBar);
        FormData fdCanvasExpandBar = new FormData();
        fdCanvasExpandBar.left = new FormAttachment(0, 0);
        fdCanvasExpandBar.right = new FormAttachment(100, 0);
        fdCanvasExpandBar.top = new FormAttachment((Control)lastControl, 2 * margin);
        canvasExpandBar.setLayoutData((Object)fdCanvasExpandBar);
        Composite canvasContent = new Composite((Composite)canvasExpandBar, 0);
        PropsUi.setLook((Widget)canvasContent);
        FormLayout canvasLayout = new FormLayout();
        canvasLayout.marginWidth = PropsUi.getFormMargin();
        canvasLayout.marginHeight = PropsUi.getFormMargin();
        canvasContent.setLayout((Layout)canvasLayout);
        Button lastCanvasControl = null;
        lastCanvasControl = this.wShowCanvasGrid = this.createCheckbox(canvasContent, "EnterOptionsDialog.ShowCanvasGrid.Label", "EnterOptionsDialog.ShowCanvasGrid.ToolTip", props.isShowCanvasGridEnabled(), (Control)lastCanvasControl, margin);
        Control[] gridSizeControls = this.createTextField(canvasContent, "EnterOptionsDialog.GridSize.Label", "EnterOptionsDialog.GridSize.ToolTip", Integer.toString(props.getCanvasGridSize()), (Control)lastCanvasControl, margin);
        this.wGridSize = (Text)gridSizeControls[1];
        this.wlGridSize = (Label)gridSizeControls[0];
        this.wGridSize.setMessage(BaseMessages.getString(PKG, (String)ENTER_OPTIONS_DIALOG_ENTER_NUMBER_HINT, (String[])new String[0]));
        this.wGridSize.addListener(25, e -> {
            String currentText = ((Text)e.widget).getText();
            String newText = currentText.substring(0, e.start) + e.text + currentText.substring(e.end);
            if (!newText.isEmpty() && !newText.matches("\\d+")) {
                e.doit = false;
            }
        });
        lastCanvasControl = this.wGridSize;
        lastCanvasControl = this.wHideViewport = this.createCheckbox(canvasContent, "EnterOptionsDialog.ShowViewport.Label", "EnterOptionsDialog.ShowViewport.ToolTip", !props.isHideViewportEnabled(), (Control)lastCanvasControl, margin);
        lastCanvasControl = this.wUseDoubleClick = this.createCheckbox(canvasContent, "EnterOptionsDialog.UseDoubleClickOnCanvas.Label", null, props.useDoubleClick(), (Control)lastCanvasControl, margin);
        lastCanvasControl = this.wDrawBorderAroundCanvasNames = this.createCheckbox(canvasContent, "EnterOptionsDialog.DrawBorderAroundCanvasNamesOnCanvas.Label", null, props.isBorderDrawnAroundCanvasNames(), (Control)lastCanvasControl, margin);
        this.wDisableZoomScrolling = this.createCheckbox(canvasContent, "EnterOptionsDialog.DisableZoomScrolling.Label", "EnterOptionsDialog.DisableZoomScrolling.ToolTip", props.isZoomScrollingDisabled(), (Control)lastCanvasControl, margin);
        ExpandItem canvasItem = new ExpandItem(canvasExpandBar, 0);
        canvasItem.setText(BaseMessages.getString(PKG, (String)"EnterOptionsDialog.Section.PipelineWorkflowCanvas", (String[])new String[0]));
        canvasItem.setControl((Control)canvasContent);
        canvasItem.setHeight(canvasContent.computeSize((int)-1, (int)-1).y);
        canvasItem.setExpanded(true);
        canvasExpandBar.addListener(17, e -> Display.getDefault().asyncExec(() -> {
            if (!wLookComp.isDisposed() && !sLookComp.isDisposed()) {
                wLookComp.layout();
                sLookComp.setMinHeight(wLookComp.computeSize((int)-1, (int)-1).y);
            }
        }));
        canvasExpandBar.addListener(18, e -> Display.getDefault().asyncExec(() -> {
            if (!wLookComp.isDisposed() && !sLookComp.isDisposed()) {
                wLookComp.layout();
                sLookComp.setMinHeight(wLookComp.computeSize((int)-1, (int)-1).y);
            }
        }));
        lastControl = canvasExpandBar;
        ExpandBar tablesExpandBar = new ExpandBar(wLookComp, 512);
        PropsUi.setLook((Widget)tablesExpandBar);
        FormData fdTablesExpandBar = new FormData();
        fdTablesExpandBar.left = new FormAttachment(0, 0);
        fdTablesExpandBar.right = new FormAttachment(100, 0);
        fdTablesExpandBar.top = new FormAttachment((Control)lastControl, 2 * margin);
        tablesExpandBar.setLayoutData((Object)fdTablesExpandBar);
        Composite tablesContent = new Composite((Composite)tablesExpandBar, 0);
        PropsUi.setLook((Widget)tablesContent);
        FormLayout tablesLayout = new FormLayout();
        tablesLayout.marginWidth = PropsUi.getFormMargin();
        tablesLayout.marginHeight = PropsUi.getFormMargin();
        tablesContent.setLayout((Layout)tablesLayout);
        Control lastTablesControl = null;
        this.wShowTableViewToolbar = this.createCheckbox(tablesContent, "EnterOptionsDialog.ShowTableViewToolbar.Label", "EnterOptionsDialog.ShowTableViewToolbar.ToolTip", props.isShowTableViewToolbar(), lastTablesControl, margin);
        ExpandItem tablesItem = new ExpandItem(tablesExpandBar, 0);
        tablesItem.setText(BaseMessages.getString(PKG, (String)"EnterOptionsDialog.Section.TablesGrids", (String[])new String[0]));
        tablesItem.setControl((Control)tablesContent);
        tablesItem.setHeight(tablesContent.computeSize((int)-1, (int)-1).y);
        tablesItem.setExpanded(true);
        tablesExpandBar.addListener(17, e -> Display.getDefault().asyncExec(() -> {
            if (!wLookComp.isDisposed() && !sLookComp.isDisposed()) {
                wLookComp.layout();
                sLookComp.setMinHeight(wLookComp.computeSize((int)-1, (int)-1).y);
            }
        }));
        tablesExpandBar.addListener(18, e -> Display.getDefault().asyncExec(() -> {
            if (!wLookComp.isDisposed() && !sLookComp.isDisposed()) {
                wLookComp.layout();
                sLookComp.setMinHeight(wLookComp.computeSize((int)-1, (int)-1).y);
            }
        }));
        FormData fdLookComp = new FormData();
        fdLookComp.left = new FormAttachment(0, 0);
        fdLookComp.right = new FormAttachment(100, 0);
        fdLookComp.top = new FormAttachment(0, 0);
        fdLookComp.bottom = new FormAttachment(100, 100);
        wLookComp.setLayoutData((Object)fdLookComp);
        wLookComp.pack();
        Rectangle bounds = wLookComp.getBounds();
        sLookComp.setContent((Control)wLookComp);
        sLookComp.setExpandHorizontal(true);
        sLookComp.setExpandVertical(true);
        sLookComp.setMinWidth(bounds.width);
        sLookComp.setMinHeight(bounds.height);
        wLookTab.setControl((Control)sLookComp);
        this.isInitializing = false;
    }

    private void paintNoteFont(PaintEvent pe) {
        pe.gc.setFont(this.noteFont);
        Rectangle max = this.wNoteCanvas.getBounds();
        String name = this.noteFontData.getName() + " - " + this.noteFontData.getHeight();
        Point size = pe.gc.textExtent(name);
        pe.gc.drawText(name, (max.width - size.x) / 2, (max.height - size.y) / 2, true);
    }

    private void resetNoteFont(Event e, PropsUi props, Display display) {
        this.noteFontData = props.getDefaultFontData();
        this.noteFont.dispose();
        this.noteFont = new Font((Device)display, this.noteFontData);
        this.wNoteCanvas.redraw();
        this.saveValues();
    }

    private void editNoteFont(Shell shell) {
        FontDialog fd = new FontDialog(shell);
        fd.setFontList(new FontData[]{this.noteFontData});
        FontData newfd = fd.open();
        if (newfd != null) {
            this.noteFontData = newfd;
            this.noteFont.dispose();
            this.noteFont = new Font((Device)shell.getDisplay(), this.noteFontData);
            this.wNoteCanvas.redraw();
            this.saveValues();
        }
    }

    private void drawGraphFont(PaintEvent pe) {
        pe.gc.setFont(this.graphFont);
        Rectangle max = this.wGraphCanvas.getBounds();
        String name = this.graphFontData.getName() + " - " + this.graphFontData.getHeight();
        Point size = pe.gc.textExtent(name);
        pe.gc.drawText(name, (max.width - size.x) / 2, (max.height - size.y) / 2, true);
    }

    private void editGraphFont(Shell shell) {
        FontDialog fd = new FontDialog(shell);
        fd.setFontList(new FontData[]{this.graphFontData});
        FontData newfd = fd.open();
        if (newfd != null) {
            this.graphFontData = newfd;
            this.graphFont.dispose();
            this.graphFont = new Font((Device)shell.getDisplay(), this.graphFontData);
            this.wGraphCanvas.redraw();
            this.saveValues();
        }
    }

    private void resetGraphFont(Shell shell, PropsUi props) {
        this.graphFont.dispose();
        this.graphFontData = props.getDefaultFontData();
        this.graphFont = new Font((Device)shell.getDisplay(), this.graphFontData);
        this.wGraphCanvas.redraw();
        this.saveValues();
    }

    private void resetFixedFont(Shell shell) {
        this.fixedFontData = new FontData(PropsUi.getInstance().getFixedFont().getName(), PropsUi.getInstance().getFixedFont().getHeight(), PropsUi.getInstance().getFixedFont().getStyle());
        this.fixedFont.dispose();
        this.fixedFont = new Font((Device)shell.getDisplay(), this.fixedFontData);
        this.wFixedCanvas.redraw();
        this.saveValues();
    }

    private void editFixedFont(Shell shell) {
        FontDialog fd = new FontDialog(shell);
        fd.setFontList(new FontData[]{this.fixedFontData});
        FontData newfd = fd.open();
        if (newfd != null) {
            this.fixedFontData = newfd;
            this.fixedFont.dispose();
            this.fixedFont = new Font((Device)shell.getDisplay(), this.fixedFontData);
            this.wFixedCanvas.redraw();
            this.saveValues();
        }
    }

    private void paintFixedFont(PaintEvent pe) {
        pe.gc.setFont(this.fixedFont);
        Rectangle max = this.wFixedCanvas.getBounds();
        String name = this.fixedFontData.getName() + " - " + this.fixedFontData.getHeight();
        Point size = pe.gc.textExtent(name);
        pe.gc.drawText(name, (max.width - size.x) / 2, (max.height - size.y) / 2, true);
    }

    private void resetDefaultFont(Shell shell) {
        this.defaultFontData = new FontData(PropsUi.getInstance().getFixedFont().getName(), PropsUi.getInstance().getFixedFont().getHeight(), PropsUi.getInstance().getFixedFont().getStyle());
        this.defaultFont.dispose();
        this.defaultFont = new Font((Device)shell.getDisplay(), this.defaultFontData);
        this.wDefaultCanvas.redraw();
        this.saveValues();
    }

    private void paintDefaultFont(PaintEvent pe) {
        pe.gc.setFont(this.defaultFont);
        Rectangle max = this.wDefaultCanvas.getBounds();
        String name = this.defaultFontData.getName() + " - " + this.defaultFontData.getHeight();
        Point size = pe.gc.textExtent(name);
        pe.gc.drawText(name, (max.width - size.x) / 2, (max.height - size.y) / 2, true);
    }

    private void editDefaultFont(Shell shell) {
        FontDialog fd = new FontDialog(shell);
        fd.setFontList(new FontData[]{this.defaultFontData});
        FontData newfd = fd.open();
        if (newfd != null) {
            this.defaultFontData = newfd;
            this.defaultFont.dispose();
            this.defaultFont = new Font((Device)shell.getDisplay(), this.defaultFontData);
            this.wDefaultCanvas.redraw();
            this.saveValues();
        }
    }

    private FormData layoutResetOptionButton(Button button) {
        FormData fd = new FormData();
        Image editButton = GuiResource.getInstance().getImageResetOption();
        if (editButton != null) {
            button.setImage(editButton);
            button.setBackground(GuiResource.getInstance().getColorWhite());
            fd.width = editButton.getBounds().width + 20;
            fd.height = editButton.getBounds().height;
        } else {
            button.setText(BaseMessages.getString(PKG, (String)"EnterOptionsDialog.Button.Reset", (String[])new String[0]));
        }
        button.setToolTipText(BaseMessages.getString(PKG, (String)"EnterOptionsDialog.Button.Reset.Tooltip", (String[])new String[0]));
        return fd;
    }

    private FormData layoutEditOptionButton(Button button) {
        FormData fd = new FormData();
        Image editButton = GuiResource.getInstance().getImageEdit();
        if (editButton != null) {
            button.setImage(editButton);
            button.setBackground(GuiResource.getInstance().getColorWhite());
            fd.width = editButton.getBounds().width + 20;
            fd.height = editButton.getBounds().height;
        } else {
            button.setText(BaseMessages.getString(PKG, (String)"EnterOptionsDialog.Button.Edit", (String[])new String[0]));
        }
        button.setToolTipText(BaseMessages.getString(PKG, (String)"EnterOptionsDialog.Button.Edit.Tooltip", (String[])new String[0]));
        return fd;
    }

    private void saveValues() {
        if (this.isReloading || this.isInitializing) {
            return;
        }
        PropsUi props = PropsUi.getInstance();
        props.setDefaultFont(this.defaultFontData);
        props.setFixedFont(this.fixedFontData);
        props.setGraphFont(this.graphFontData);
        props.setNoteFont(this.noteFontData);
        props.setIconSize(Const.toInt((String)this.wIconSize.getText(), (int)props.getIconSize()));
        props.setLineWidth(Const.toInt((String)this.wLineWidth.getText(), (int)props.getLineWidth()));
        props.setMiddlePct(Const.toInt((String)this.wMiddlePct.getText(), (int)props.getMiddlePct()));
        props.setCanvasGridSize(Const.toInt((String)this.wGridSize.getText(), (int)1));
        props.setGlobalZoomFactor(Const.toDouble((String)this.wGlobalZoom.getText().replace("%", ""), (double)100.0) / 100.0);
        props.setShowCanvasGridEnabled(this.wShowCanvasGrid.getSelection());
        props.setHideViewportEnabled(!this.wHideViewport.getSelection());
        props.setUseDoubleClickOnCanvas(this.wUseDoubleClick.getSelection());
        props.setDrawBorderAroundCanvasNames(this.wDrawBorderAroundCanvasNames.getSelection());
        props.setZoomScrollingDisabled(this.wDisableZoomScrolling.getSelection());
        props.setDarkMode(this.wDarkMode.getSelection());
        props.setHidingMenuBar(this.wHideMenuBar.getSelection());
        props.setShowTableViewToolbar(this.wShowTableViewToolbar.getSelection());
        int defaultLocaleIndex = this.wDefaultLocale.getSelectionIndex();
        if (defaultLocaleIndex < 0 || defaultLocaleIndex >= GlobalMessages.localeCodes.length) {
            defaultLocaleIndex = 0;
        }
        String defaultLocale = GlobalMessages.localeCodes[defaultLocaleIndex];
        LanguageChoice.getInstance().setDefaultLocale(EnvUtil.createLocale((String)defaultLocale));
        try {
            HopConfig.getInstance().saveToFile();
        }
        catch (Exception e) {
            new ErrorDialog(HopGui.getInstance().getShell(), "Error", "Error saving configuration to file", e);
        }
    }

    private Control[] createTextField(Composite parent, String labelKey, String tooltipKey, String initialValue, Control lastControl, int margin) {
        Label label = new Label(parent, 16384);
        PropsUi.setLook((Widget)label);
        label.setText(BaseMessages.getString(PKG, (String)labelKey, (String[])new String[0]));
        FormData fdLabel = new FormData();
        fdLabel.left = new FormAttachment(0, 0);
        fdLabel.right = new FormAttachment(100, 0);
        fdLabel.top = lastControl != null ? new FormAttachment(lastControl, margin) : new FormAttachment(0, margin);
        label.setLayoutData((Object)fdLabel);
        Text text = new Text(parent, 18436);
        PropsUi.setLook((Widget)text);
        text.setText(initialValue);
        if (tooltipKey != null) {
            text.setToolTipText(BaseMessages.getString(PKG, (String)tooltipKey, (String[])new String[0]));
        }
        text.addListener(24, e -> this.saveValues());
        FormData fdText = new FormData();
        fdText.left = new FormAttachment(0, 0);
        fdText.right = new FormAttachment(100, 0);
        fdText.top = new FormAttachment((Control)label, margin / 2);
        text.setLayoutData((Object)fdText);
        return new Control[]{label, text};
    }

    private Control[] createComboField(Composite parent, String labelKey, String tooltipKey, String[] items, Control lastControl, int margin) {
        Label label = new Label(parent, 16384);
        PropsUi.setLook((Widget)label);
        label.setText(BaseMessages.getString(PKG, (String)labelKey, (String[])new String[0]));
        FormData fdLabel = new FormData();
        fdLabel.left = new FormAttachment(0, 0);
        fdLabel.right = new FormAttachment(100, 0);
        fdLabel.top = lastControl != null ? new FormAttachment(lastControl, margin) : new FormAttachment(0, margin);
        label.setLayoutData((Object)fdLabel);
        Combo combo = new Combo(parent, 18444);
        PropsUi.setLook((Widget)combo);
        combo.setItems(items);
        if (tooltipKey != null) {
            combo.setToolTipText(BaseMessages.getString(PKG, (String)tooltipKey, (String[])new String[0]));
        }
        combo.addListener(24, e -> this.saveValues());
        FormData fdCombo = new FormData();
        fdCombo.left = new FormAttachment(0, 0);
        fdCombo.right = new FormAttachment(100, 0);
        fdCombo.top = new FormAttachment((Control)label, margin / 2);
        combo.setLayoutData((Object)fdCombo);
        return new Control[]{label, combo};
    }

    private Button createCheckbox(Composite parent, String labelKey, String tooltipKey, boolean selected, Control lastControl, int margin) {
        Button checkbox = new Button(parent, 32);
        PropsUi.setLook((Widget)checkbox);
        checkbox.setText(BaseMessages.getString(PKG, (String)labelKey, (String[])new String[0]));
        if (tooltipKey != null) {
            checkbox.setToolTipText(BaseMessages.getString(PKG, (String)tooltipKey, (String[])new String[0]));
        }
        checkbox.setSelection(selected);
        checkbox.addListener(13, e -> this.saveValues());
        FormData fdCheckbox = new FormData();
        fdCheckbox.left = new FormAttachment(0, 0);
        fdCheckbox.right = new FormAttachment(100, 0);
        fdCheckbox.top = lastControl != null ? new FormAttachment(lastControl, margin) : new FormAttachment(0, margin);
        checkbox.setLayoutData((Object)fdCheckbox);
        return checkbox;
    }

    private Control[] createFontPicker(Composite parent, String labelKey, Shell shell, Control lastControl, int margin) {
        int h = (int)(40.0 * PropsUi.getInstance().getZoomFactor());
        Label label = new Label(parent, 16384);
        PropsUi.setLook((Widget)label);
        label.setText(BaseMessages.getString(PKG, (String)labelKey, (String[])new String[0]));
        FormData fdLabel = new FormData();
        fdLabel.left = new FormAttachment(0, 0);
        fdLabel.right = new FormAttachment(100, 0);
        fdLabel.top = lastControl != null ? new FormAttachment(lastControl, margin) : new FormAttachment(0, margin);
        label.setLayoutData((Object)fdLabel);
        Button resetButton = new Button(parent, 0x1000008);
        PropsUi.setLook((Widget)resetButton);
        FormData fdResetButton = this.layoutResetOptionButton(resetButton);
        fdResetButton.right = new FormAttachment(100, 0);
        fdResetButton.top = new FormAttachment((Control)label, margin / 2);
        fdResetButton.height = h;
        resetButton.setLayoutData((Object)fdResetButton);
        Button editButton = new Button(parent, 8);
        PropsUi.setLook((Widget)editButton);
        FormData fdEditButton = this.layoutEditOptionButton(editButton);
        fdEditButton.right = new FormAttachment((Control)resetButton, -margin);
        fdEditButton.top = new FormAttachment((Control)label, margin / 2);
        fdEditButton.height = h;
        editButton.setLayoutData((Object)fdEditButton);
        Canvas canvas = new Canvas(parent, 2048);
        PropsUi.setLook((Widget)canvas);
        FormData fdCanvas = new FormData();
        fdCanvas.left = new FormAttachment(0, 0);
        fdCanvas.right = new FormAttachment((Control)editButton, -margin);
        fdCanvas.top = new FormAttachment((Control)label, margin / 2);
        fdCanvas.height = h;
        canvas.setLayoutData((Object)fdCanvas);
        return new Control[]{canvas, editButton, resetButton};
    }
}

