/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.structuredstreaming.translation.batch;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.beam.runners.core.SideInputReader;
import org.apache.beam.runners.spark.SparkCommonPipelineOptions;
import org.apache.beam.runners.spark.structuredstreaming.metrics.MetricsAccumulator;
import org.apache.beam.runners.spark.structuredstreaming.translation.PipelineTranslator;
import org.apache.beam.runners.spark.structuredstreaming.translation.TransformTranslator;
import org.apache.beam.runners.spark.structuredstreaming.translation.batch.DoFnPartitionIteratorFactory;
import org.apache.beam.runners.spark.structuredstreaming.translation.batch.DoFnRunnerFactory;
import org.apache.beam.runners.spark.structuredstreaming.translation.batch.functions.SideInputValues;
import org.apache.beam.runners.spark.structuredstreaming.translation.batch.functions.SparkSideInputReader;
import org.apache.beam.runners.spark.structuredstreaming.translation.helpers.EncoderHelpers;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.reflect.DoFnSignature;
import org.apache.beam.sdk.transforms.reflect.DoFnSignatures;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.apache.beam.sdk.values.WindowedValue;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Maps;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.TypedColumn;
import org.apache.spark.sql.functions;
import org.apache.spark.storage.StorageLevel;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class ParDoTranslatorBatch<@UnknownKeyFor InputT, @UnknownKeyFor OutputT>
extends TransformTranslator<PCollection<? extends InputT>, PCollectionTuple, ParDo.MultiOutput<InputT, OutputT>> {
    ParDoTranslatorBatch() {
        super(0.0f);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean canTranslate(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized ParDo.MultiOutput<InputT, OutputT> transform) {
        DoFn doFn = transform.getFn();
        DoFnSignature signature = DoFnSignatures.signatureForDoFn((DoFn)doFn);
        org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkState((!signature.processElement().isSplittable() ? 1 : 0) != 0, (String)"Not expected to directly translate splittable DoFn, should have been overridden: %s", (Object)doFn);
        org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkState((!signature.usesState() && !signature.usesTimers() ? 1 : 0) != 0, (Object)"States and timers are not supported for the moment.");
        org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkState((signature.onWindowExpiration() == null ? 1 : 0) != 0, (String)"onWindowExpiration is not supported: %s", (Object)doFn);
        org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkState((!signature.processElement().requiresTimeSortedInput() ? 1 : 0) != 0, (Object)"@RequiresTimeSortedInput is not supported for the moment");
        SparkSideInputReader.validateMaterializations(transform.getSideInputs().values());
        return true;
    }

    @Override
    public void translate(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized ParDo.MultiOutput<InputT, OutputT> transform, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized TransformTranslator. @UnknownKeyFor @NonNull @Initialized Context cxt) throws @UnknownKeyFor @NonNull @Initialized IOException {
        PCollection input = (PCollection)cxt.getInput();
        SideInputReader sideInputReader = this.createSideInputReader(transform.getSideInputs().values(), cxt);
        MetricsAccumulator metrics = MetricsAccumulator.getInstance(cxt.getSparkSession());
        TupleTag mainOut = transform.getMainOutputTag();
        Map<TupleTag<?>, PCollection<?>> outputs = this.skipUnconsumedOutputs(cxt.getOutputs(), mainOut, transform.getAdditionalOutputTags(), cxt);
        if (outputs.size() > 1) {
            Map<String, Integer> tagColIdx = this.tagsColumnIndex(outputs.keySet());
            List encoders = this.createEncoders(outputs, tagColIdx, cxt);
            DoFnPartitionIteratorFactory doFnMapper = DoFnPartitionIteratorFactory.multiOutput(cxt.getOptionsSupplier(), metrics, DoFnRunnerFactory.simple(cxt.getCurrentTransform(), input, sideInputReader, false), tagColIdx);
            SparkCommonPipelineOptions opts = (SparkCommonPipelineOptions)cxt.getOptions().as(SparkCommonPipelineOptions.class);
            StorageLevel storageLevel = StorageLevel.fromString((String)opts.getStorageLevel());
            Dataset allTagsDS = cxt.getDataset(input).mapPartitions(doFnMapper, EncoderHelpers.oneOfEncoder(encoders));
            allTagsDS.persist(storageLevel);
            for (TupleTag<?> tag : outputs.keySet()) {
                int colIdx = (Integer)Preconditions.checkStateNotNull((Object)tagColIdx.get(tag.getId()), (Object)"Unknown tag");
                TypedColumn col = functions.col((String)Integer.toString(colIdx)).as(encoders.get(colIdx));
                cxt.putDataset(cxt.getOutput(tag), allTagsDS.filter(col.isNotNull()).select(col), false);
            }
        } else {
            PCollection output = cxt.getOutput(mainOut);
            boolean filterMainOutput = cxt.getOutputs().size() > 1;
            UnresolvedParDo unresolvedParDo = new UnresolvedParDo(input, DoFnRunnerFactory.simple(cxt.getCurrentTransform(), input, sideInputReader, filterMainOutput), () -> cxt.windowedEncoder(output.getCoder()));
            cxt.putUnresolved(output, unresolvedParDo);
        }
    }

    private /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> skipUnconsumedOutputs(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> outputs, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> mainTag, @UnknownKeyFor @NonNull @Initialized TupleTagList otherTags, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized TransformTranslator. @UnknownKeyFor @NonNull @Initialized Context cxt) {
        switch (outputs.size()) {
            case 1: {
                return outputs;
            }
            case 2: {
                TupleTag otherTag = otherTags.get(0);
                return cxt.isLeaf((PCollection)Preconditions.checkStateNotNull(outputs.get(otherTag))) ? Collections.singletonMap(mainTag, (PCollection)Preconditions.checkStateNotNull(outputs.get(mainTag))) : outputs;
            }
        }
        HashMap filtered = Maps.newHashMapWithExpectedSize((int)outputs.size());
        for (Map.Entry<TupleTag<?>, PCollection<?>> e : outputs.entrySet()) {
            if (!e.getKey().equals(mainTag) && cxt.isLeaf(e.getValue())) continue;
            filtered.put(e.getKey(), e.getValue());
        }
        return filtered;
    }

    private @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Integer> tagsColumnIndex(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> tags) {
        HashMap index = Maps.newHashMapWithExpectedSize((int)tags.size());
        for (TupleTag<?> tag : tags) {
            index.put(tag.getId(), index.size());
        }
        return index;
    }

    private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Encoder<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized Object>>> createEncoders(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> outputs, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Integer> tagIdColIdx, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized TransformTranslator. @UnknownKeyFor @NonNull @Initialized Context ctx) {
        ArrayList<Encoder<WindowedValue<Object>>> encoders = new ArrayList<Encoder<WindowedValue<Object>>>(outputs.size());
        for (Map.Entry<TupleTag<?>, PCollection<?>> e : outputs.entrySet()) {
            Encoder enc = ctx.windowedEncoder(e.getValue().getCoder());
            int colIdx = (Integer)Preconditions.checkStateNotNull((Object)tagIdColIdx.get(e.getKey().getId()));
            encoders.add(colIdx, enc);
        }
        return encoders;
    }

    private <T> @UnknownKeyFor @NonNull @Initialized SideInputReader createSideInputReader(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> views, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized TransformTranslator. @UnknownKeyFor @NonNull @Initialized Context cxt) {
        if (views.isEmpty()) {
            return SparkSideInputReader.empty();
        }
        HashMap broadcasts = Maps.newHashMapWithExpectedSize((int)views.size());
        for (PCollectionView<?> view : views) {
            PCollection pCol = (PCollection)Preconditions.checkStateNotNull((Object)view.getPCollection());
            Broadcast broadcast = cxt.getSideInputBroadcast(pCol, SideInputValues.loader(pCol));
            broadcasts.put(view.getTagInternal().getId(), broadcast);
        }
        return SparkSideInputReader.create(broadcasts);
    }

    private static class UnresolvedParDo<@UnknownKeyFor InT, @UnknownKeyFor T>
    implements PipelineTranslator.UnresolvedTranslation<InT, T> {
        private final @UnknownKeyFor @NonNull @Initialized PCollection<InT> input;
        private final @UnknownKeyFor @NonNull @Initialized DoFnRunnerFactory<InT, T> doFnFact;
        private final @UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized Encoder<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>>> encoder;

        UnresolvedParDo(@UnknownKeyFor @NonNull @Initialized PCollection<InT> input, @UnknownKeyFor @NonNull @Initialized DoFnRunnerFactory<InT, T> doFnFact, @UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized Encoder<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>>> encoder) {
            this.input = input;
            this.doFnFact = doFnFact;
            this.encoder = encoder;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<InT> getInput() {
            return this.input;
        }

        @Override
        public <T2> @UnknownKeyFor @NonNull @Initialized PipelineTranslator.UnresolvedTranslation<InT, T2> fuse(@UnknownKeyFor @NonNull @Initialized PipelineTranslator.UnresolvedTranslation<T, T2> next) {
            UnresolvedParDo nextParDo = (UnresolvedParDo)next;
            return new UnresolvedParDo<InT, T>(this.input, this.doFnFact.fuse(nextParDo.doFnFact), nextParDo.encoder);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Dataset<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>> resolve(@UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized PipelineOptions> options, @UnknownKeyFor @NonNull @Initialized Dataset<@UnknownKeyFor @NonNull @Initialized WindowedValue<InT>> input) {
            MetricsAccumulator metrics = MetricsAccumulator.getInstance(input.sparkSession());
            DoFnPartitionIteratorFactory<InT, ?, WindowedValue<T>> doFnMapper = DoFnPartitionIteratorFactory.singleOutput(options, metrics, this.doFnFact);
            return input.mapPartitions(doFnMapper, this.encoder.get());
        }
    }
}

