/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.calculator.calculations.file;

import org.apache.hop.core.exception.HopFileNotFoundException;
import org.apache.hop.core.row.ValueDataUtil;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.transforms.calculator.CalculationInput;
import org.apache.hop.pipeline.transforms.calculator.CalculationOutput;
import org.apache.hop.pipeline.transforms.calculator.ICalculation;

public class MessageDigest
implements ICalculation {
    private final String code;
    private final String algorithmType;
    private final String description;

    public MessageDigest(ALGORITHM algorithm) {
        this.code = algorithm.name();
        this.algorithmType = algorithm.type;
        this.description = BaseMessages.getString((Class)PKG, (String)algorithm.messageKey, (String[])new String[0]);
    }

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public int getDefaultResultType() {
        return 2;
    }

    @Override
    public CalculationOutput calculate(CalculationInput in) throws HopFileNotFoundException {
        return new CalculationOutput(this.getDefaultResultType(), ValueDataUtil.createChecksum((Object)in.dataA, (String)this.algorithmType, (boolean)in.isFailIfNoFile));
    }

    public static enum ALGORITHM {
        MD5("MD5", "CalculatorMetaFunction.CalcFunctions.MD5"),
        SHA1("SHA-1", "CalculatorMetaFunction.CalcFunctions.SHA1"),
        SHA256("SHA-256", "CalculatorMetaFunction.CalcFunctions.SHA256"),
        SHA384("SHA-384", "CalculatorMetaFunction.CalcFunctions.SHA384"),
        SHA512("SHA-512", "CalculatorMetaFunction.CalcFunctions.SHA512");

        final String type;
        final String messageKey;

        private ALGORITHM(String type, String messageKey) {
            this.type = type;
            this.messageKey = messageKey;
        }
    }
}

