/*
 * Decompiled with CFR 0.152.
 */
package org.caffinitas.ohc.linked;

import com.google.common.primitives.Ints;
import org.caffinitas.ohc.linked.Uns;
import org.caffinitas.ohc.linked.Util;

final class Timeouts {
    private final long slotBitmask;
    private final int precisionShift;
    private final int slotCount;
    private final Slot[] slots;

    Timeouts(int slots, long precision) {
        if (slots == 0) {
            slots = 64;
        }
        if (precision == 0L) {
            precision = 128L;
        }
        if (slots < 1) {
            throw new IllegalArgumentException("timeouts-slots <= 0");
        }
        if (precision < 1L) {
            throw new IllegalArgumentException("precision <= 0");
        }
        this.slotCount = Ints.checkedCast((long)Util.roundUpToPowerOf2(Math.min(slots, 16), 0x40000000L));
        int slotShift = 64 - Util.bitNum(this.slotCount) - 1;
        this.slotBitmask = (long)this.slotCount - 1L << slotShift;
        this.slots = new Slot[this.slotCount];
        for (int i = 0; i < this.slotCount; ++i) {
            this.slots[i] = new Slot();
        }
        precision = Util.roundUpToPowerOf2(Math.min(precision, 1L), 0x40000000L);
        this.precisionShift = 64 - Util.bitNum(precision) - 1;
    }

    void add(long hashEntryAdr, long expireAt) {
        int slotNum = this.slot(expireAt);
        this.slots[slotNum].add(hashEntryAdr, expireAt);
    }

    void remove(long hashEntryAdr, long expireAt) {
        int slot = this.slot(expireAt);
        this.slots[slot].remove(hashEntryAdr);
    }

    int used() {
        int used = 0;
        for (Slot slot : this.slots) {
            used += slot.used;
        }
        return used;
    }

    int removeExpired(TimeoutHandler expireHandler) {
        long t = System.currentTimeMillis();
        int expired = 0;
        for (int i = 0; i < this.slotCount; ++i) {
            expired += this.slots[i++].removeExpired(t, expireHandler);
        }
        return expired;
    }

    void release() {
        for (Slot slot : this.slots) {
            slot.release();
        }
    }

    private int slot(long expireAt) {
        return (int)((expireAt >>= this.precisionShift) & this.slotBitmask);
    }

    private final class Slot {
        private static final int MIN_LEN = 16;
        private static final int ENTRY_SIZE = 16;
        private long addr;
        private int allocLen;
        private int len;
        private int used;
        private int min0;

        private Slot() {
        }

        void add(long hashEntryAdr, long expireAt) {
            for (int i = this.min0; i < this.allocLen; ++i) {
                int off = i * 16;
                long adr = Uns.getLong(this.addr, off);
                if (adr != 0L) continue;
                if (i + 1 > this.len) {
                    this.len = i + 1;
                }
                this.min0 = i + 1;
                this.postAdd(hashEntryAdr, expireAt, off);
                return;
            }
            this.resize();
            int off = this.len * 16;
            this.len = this.min0 = this.len + 1;
            this.postAdd(hashEntryAdr, expireAt, off);
        }

        private void postAdd(long hashEntryAdr, long expireAt, int off) {
            Uns.putLong(this.addr, off, hashEntryAdr);
            Uns.putLong(this.addr, off + 8, expireAt);
            ++this.used;
        }

        private void resize() {
            int newAllocLen = Math.max(16, this.allocLen * 2);
            long newAddr = Uns.allocate(newAllocLen * 16, true);
            if (this.addr != 0L) {
                Uns.copyMemory(this.addr, 0L, newAddr, 0L, (long)(this.len * 16));
                Uns.setMemory(newAddr, this.len * 16, (newAllocLen - this.len) * 16, (byte)0);
            } else {
                Uns.setMemory(newAddr, 0L, newAllocLen * 16, (byte)0);
            }
            Uns.free(this.addr);
            this.addr = newAddr;
            this.allocLen = newAllocLen;
        }

        void remove(long hashEntryAdr) {
            for (int i = 0; i < this.len; ++i) {
                int off = i * 16;
                long adr = Uns.getLong(this.addr, off);
                if (adr != hashEntryAdr) continue;
                this.clearEntry(i, off);
            }
            this.maybeCompact();
        }

        int removeExpired(long now, TimeoutHandler expireHandler) {
            int expired = 0;
            for (int i = 0; i < this.len; ++i) {
                long expireAt;
                int off = i * 16;
                long hashEntryAdr = Uns.getLong(this.addr, off);
                if (hashEntryAdr == 0L || now < (expireAt = Uns.getLong(this.addr, off + 8))) continue;
                this.clearEntry(i, off);
                expireHandler.expired(hashEntryAdr);
                ++expired;
            }
            this.maybeCompact();
            return expired;
        }

        private void clearEntry(int idx, int off) {
            if (idx < this.min0) {
                this.min0 = idx;
            }
            if (idx == this.len - 1) {
                --this.len;
            }
            Uns.putLong(this.addr, off, 0L);
            Uns.putLong(this.addr, off + 8, 0L);
            --this.used;
        }

        private void maybeCompact() {
            int newAllocLen;
            if (this.used * 2 <= this.allocLen && (newAllocLen = Math.max(16, this.allocLen / 2)) < this.allocLen) {
                this.compact(newAllocLen);
            }
        }

        private void compact(int newAllocLen) {
            long newAddr = Uns.allocate(newAllocLen * 16, true);
            int tOff = 0;
            int sOff = 0;
            int i = 0;
            while (i < this.len) {
                long hashEntryAdr = Uns.getLong(this.addr, sOff);
                if (hashEntryAdr != 0L) {
                    long expireAt = Uns.getLong(this.addr, sOff + 8);
                    Uns.putLong(newAddr, tOff, hashEntryAdr);
                    Uns.putLong(newAddr, tOff + 8, expireAt);
                    tOff += 16;
                }
                ++i;
                sOff += 16;
            }
            Uns.setMemory(newAddr, this.used * 16, (newAllocLen - this.used) * 16, (byte)0);
            Uns.free(this.addr);
            this.len = this.used;
            this.min0 = this.used;
            this.addr = newAddr;
            this.allocLen = newAllocLen;
        }

        void release() {
            Uns.free(this.addr);
            this.addr = 0L;
        }
    }

    static interface TimeoutHandler {
        public void expired(long var1);
    }
}

