/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.runtime;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.sql.Array;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BinaryOperator;
import java.util.regex.Pattern;
import org.apache.calcite.DataContext;
import org.apache.calcite.avatica.util.ByteString;
import org.apache.calcite.avatica.util.DateTimeUtils;
import org.apache.calcite.avatica.util.Spaces;
import org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.calcite.interpreter.Row;
import org.apache.calcite.linq4j.AbstractEnumerable;
import org.apache.calcite.linq4j.CartesianProductEnumerator;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.linq4j.Linq4j;
import org.apache.calcite.linq4j.Nullness;
import org.apache.calcite.linq4j.function.Deterministic;
import org.apache.calcite.linq4j.function.Function1;
import org.apache.calcite.linq4j.function.NonDeterministic;
import org.apache.calcite.linq4j.tree.Primitive;
import org.apache.calcite.rel.type.TimeFrame;
import org.apache.calcite.rel.type.TimeFrameSet;
import org.apache.calcite.runtime.FlatLists;
import org.apache.calcite.runtime.Like;
import org.apache.calcite.util.NumberUtil;
import org.apache.calcite.util.Static;
import org.apache.calcite.util.TimeWithTimeZoneString;
import org.apache.calcite.util.TimestampWithTimeZoneString;
import org.apache.calcite.util.Unsafe;
import org.apache.calcite.util.Util;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.codec.language.Soundex;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.PolyNull;

@Deterministic
public class SqlFunctions {
    private static final DecimalFormat DOUBLE_FORMAT = NumberUtil.decimalFormat("0.0E0");
    private static final TimeZone LOCAL_TZ = TimeZone.getDefault();
    private static final DateTimeFormatter ROOT_DAY_FORMAT = DateTimeFormatter.ofPattern("EEEE", Locale.ROOT);
    private static final DateTimeFormatter ROOT_MONTH_FORMAT = DateTimeFormatter.ofPattern("MMMM", Locale.ROOT);
    private static final Soundex SOUNDEX = new Soundex();
    private static final int SOUNDEX_LENGTH = 4;
    private static final Pattern FROM_BASE64_REGEXP = Pattern.compile("[\\t\\n\\r\\s]");
    private static final Function1<List<Object>, Enumerable<Object>> LIST_AS_ENUMERABLE = a0 -> a0 == null ? Linq4j.emptyEnumerable() : Linq4j.asEnumerable((List)a0);
    private static final Function1<Object[], Enumerable<@Nullable Object[]>> ARRAY_CARTESIAN_PRODUCT = lists -> {
        ArrayList<@Nullable @Nullable Enumerator> enumerators = new ArrayList<Enumerator>();
        for (Object list : lists) {
            enumerators.add(Linq4j.enumerator((Collection)((List)list)));
        }
        final @Nullable @Nullable Enumerator product = Linq4j.product(enumerators);
        return new AbstractEnumerable<Object[]>(){

            public Enumerator<@Nullable Object[]> enumerator() {
                return Linq4j.transform((Enumerator)product, List::toArray);
            }
        };
    };
    private static final ThreadLocal<@Nullable Map<String, AtomicLong>> THREAD_SEQUENCES = ThreadLocal.withInitial(HashMap::new);
    private static final Pattern PATTERN_0_STAR_E = Pattern.compile("0*E");
    private static final ByteString SINGLE_SPACE_BYTE_STRING = ByteString.of((String)"20", (int)16);

    private SqlFunctions() {
    }

    @NonDeterministic
    public static boolean throwUnless(boolean condition, String message) {
        if (!condition) {
            throw new IllegalStateException(message);
        }
        return condition;
    }

    public static String toBase64(String string) {
        return SqlFunctions.toBase64_(string.getBytes(StandardCharsets.UTF_8));
    }

    public static String toBase64(ByteString string) {
        return SqlFunctions.toBase64_(string.getBytes());
    }

    private static String toBase64_(byte[] bytes) {
        String base64 = Base64.getEncoder().encodeToString(bytes);
        StringBuilder str = new StringBuilder(base64.length() + base64.length() / 76);
        Splitter.fixedLength((int)76).split((CharSequence)base64).iterator().forEachRemaining(s -> {
            str.append((String)s);
            str.append("\n");
        });
        return str.substring(0, str.length() - 1);
    }

    public static @Nullable ByteString fromBase64(String base64) {
        try {
            base64 = FROM_BASE64_REGEXP.matcher(base64).replaceAll("");
            return new ByteString(Base64.getDecoder().decode(base64));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static String md5(String string) {
        return DigestUtils.md5Hex((byte[])string.getBytes(StandardCharsets.UTF_8));
    }

    public static String md5(ByteString string) {
        return DigestUtils.md5Hex((byte[])string.getBytes());
    }

    public static String sha1(String string) {
        return DigestUtils.sha1Hex((byte[])string.getBytes(StandardCharsets.UTF_8));
    }

    public static String sha1(ByteString string) {
        return DigestUtils.sha1Hex((byte[])string.getBytes());
    }

    public static String regexpReplace(String s, String regex, String replacement) {
        return SqlFunctions.regexpReplace(s, regex, replacement, 1, 0, null);
    }

    public static String regexpReplace(String s, String regex, String replacement, int pos) {
        return SqlFunctions.regexpReplace(s, regex, replacement, pos, 0, null);
    }

    public static String regexpReplace(String s, String regex, String replacement, int pos, int occurrence) {
        return SqlFunctions.regexpReplace(s, regex, replacement, pos, occurrence, null);
    }

    public static String regexpReplace(String s, String regex, String replacement, int pos, int occurrence, @Nullable String matchType) {
        if (pos < 1 || pos > s.length()) {
            throw Static.RESOURCE.invalidInputForRegexpReplace(Integer.toString(pos)).ex();
        }
        int flags = SqlFunctions.makeRegexpFlags(matchType);
        Pattern pattern = Pattern.compile(regex, flags);
        return Unsafe.regexpReplace(s, pattern, replacement, pos, occurrence);
    }

    private static int makeRegexpFlags(@Nullable String stringFlags) {
        int flags = 0;
        if (stringFlags != null) {
            block6: for (int i = 0; i < stringFlags.length(); ++i) {
                switch (stringFlags.charAt(i)) {
                    case 'i': {
                        flags |= 2;
                        continue block6;
                    }
                    case 'c': {
                        flags &= 0xFFFFFFFD;
                        continue block6;
                    }
                    case 'n': {
                        flags |= 0x20;
                        continue block6;
                    }
                    case 'm': {
                        flags |= 8;
                        continue block6;
                    }
                    default: {
                        throw Static.RESOURCE.invalidInputForRegexpReplace(stringFlags).ex();
                    }
                }
            }
        }
        return flags;
    }

    public static String lpad(String originalValue, int returnLength, String pattern) {
        if (returnLength < 0) {
            throw Static.RESOURCE.illegalNegativePadLength().ex();
        }
        if (pattern.isEmpty()) {
            throw Static.RESOURCE.illegalEmptyPadPattern().ex();
        }
        if (returnLength <= originalValue.length()) {
            return originalValue.substring(0, returnLength);
        }
        int paddingLengthRequired = returnLength - originalValue.length();
        int patternLength = pattern.length();
        StringBuilder paddedS = new StringBuilder();
        for (int i = 0; i < paddingLengthRequired; ++i) {
            char curChar = pattern.charAt(i % patternLength);
            paddedS.append(curChar);
        }
        paddedS.append(originalValue);
        return paddedS.toString();
    }

    public static String lpad(String originalValue, int returnLength) {
        return SqlFunctions.lpad(originalValue, returnLength, " ");
    }

    public static ByteString lpad(ByteString originalValue, int returnLength, ByteString pattern) {
        int i;
        if (returnLength < 0) {
            throw Static.RESOURCE.illegalNegativePadLength().ex();
        }
        if (pattern.length() == 0) {
            throw Static.RESOURCE.illegalEmptyPadPattern().ex();
        }
        if (returnLength <= originalValue.length()) {
            return originalValue.substring(0, returnLength);
        }
        int paddingLengthRequired = returnLength - originalValue.length();
        int patternLength = pattern.length();
        byte[] bytes = new byte[returnLength];
        for (i = 0; i < paddingLengthRequired; ++i) {
            byte curByte;
            bytes[i] = curByte = pattern.byteAt(i % patternLength);
        }
        for (i = paddingLengthRequired; i < returnLength; ++i) {
            bytes[i] = originalValue.byteAt(i - paddingLengthRequired);
        }
        return new ByteString(bytes);
    }

    public static ByteString lpad(ByteString originalValue, int returnLength) {
        return SqlFunctions.lpad(originalValue, returnLength, SINGLE_SPACE_BYTE_STRING);
    }

    public static String rpad(String originalValue, int returnLength, String pattern) {
        if (returnLength < 0) {
            throw Static.RESOURCE.illegalNegativePadLength().ex();
        }
        if (pattern.isEmpty()) {
            throw Static.RESOURCE.illegalEmptyPadPattern().ex();
        }
        if (returnLength <= originalValue.length()) {
            return originalValue.substring(0, returnLength);
        }
        int paddingLengthRequired = returnLength - originalValue.length();
        int patternLength = pattern.length();
        StringBuilder paddedS = new StringBuilder();
        paddedS.append(originalValue);
        for (int i = 0; i < paddingLengthRequired; ++i) {
            char curChar = pattern.charAt(i % patternLength);
            paddedS.append(curChar);
        }
        return paddedS.toString();
    }

    public static String rpad(String originalValue, int returnLength) {
        return SqlFunctions.rpad(originalValue, returnLength, " ");
    }

    public static ByteString rpad(ByteString originalValue, int returnLength, ByteString pattern) {
        int i;
        if (returnLength < 0) {
            throw Static.RESOURCE.illegalNegativePadLength().ex();
        }
        if (pattern.length() == 0) {
            throw Static.RESOURCE.illegalEmptyPadPattern().ex();
        }
        int originalLength = originalValue.length();
        if (returnLength <= originalLength) {
            return originalValue.substring(0, returnLength);
        }
        int paddingLengthRequired = returnLength - originalLength;
        int patternLength = pattern.length();
        byte[] bytes = new byte[returnLength];
        for (i = 0; i < originalLength; ++i) {
            bytes[i] = originalValue.byteAt(i);
        }
        for (i = returnLength - paddingLengthRequired; i < returnLength; ++i) {
            byte curByte;
            bytes[i] = curByte = pattern.byteAt(i % patternLength);
        }
        return new ByteString(bytes);
    }

    public static ByteString rpad(ByteString originalValue, int returnLength) {
        return SqlFunctions.rpad(originalValue, returnLength, SINGLE_SPACE_BYTE_STRING);
    }

    public static boolean endsWith(String s0, String s1) {
        return s0.endsWith(s1);
    }

    public static boolean endsWith(ByteString s0, ByteString s1) {
        return s0.endsWith(s1);
    }

    public static boolean startsWith(String s0, String s1) {
        return s0.startsWith(s1);
    }

    public static boolean startsWith(ByteString s0, ByteString s1) {
        return s0.startsWith(s1);
    }

    public static String substring(String c, int s) {
        int s0 = s - 1;
        if (s0 <= 0) {
            return c;
        }
        if (s > c.length()) {
            return "";
        }
        return c.substring(s0);
    }

    public static String substring(String c, int s, int l) {
        int lc = c.length();
        int e = s + l;
        if (l < 0) {
            throw Static.RESOURCE.illegalNegativeSubstringLength().ex();
        }
        if (s > lc || e < 1) {
            return "";
        }
        int s0 = Math.max(s - 1, 0);
        int e0 = Math.min(e - 1, lc);
        return c.substring(s0, e0);
    }

    public static ByteString substring(ByteString c, int s) {
        int s0 = s - 1;
        if (s0 <= 0) {
            return c;
        }
        if (s > c.length()) {
            return ByteString.EMPTY;
        }
        return c.substring(s0);
    }

    public static ByteString substring(ByteString c, int s, int l) {
        int lc = c.length();
        int e = s + l;
        if (l < 0) {
            throw Static.RESOURCE.illegalNegativeSubstringLength().ex();
        }
        if (s > lc || e < 1) {
            return ByteString.EMPTY;
        }
        int s0 = Math.max(s - 1, 0);
        int e0 = Math.min(e - 1, lc);
        return c.substring(s0, e0);
    }

    public static String upper(String s) {
        return s.toUpperCase(Locale.ROOT);
    }

    public static String lower(String s) {
        return s.toLowerCase(Locale.ROOT);
    }

    public static String initcap(String s) {
        int len = s.length();
        boolean start = true;
        StringBuilder newS = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            char curCh;
            char c = curCh = s.charAt(i);
            if (start) {
                if (c > '/' && c < ':') {
                    start = false;
                } else if (c > '@' && c < '[') {
                    start = false;
                } else if (c > '`' && c < '{') {
                    start = false;
                    curCh = (char)(c - 32);
                }
            } else if (c <= '/' || c >= ':') {
                if (c > '@' && c < '[') {
                    curCh = (char)(c + 32);
                } else if (c <= '`' || c >= '{') {
                    start = true;
                }
            }
            newS.append(curCh);
        }
        return newS.toString();
    }

    public static String reverse(String s) {
        StringBuilder buf = new StringBuilder(s);
        return buf.reverse().toString();
    }

    public static int ascii(String s) {
        return s.isEmpty() ? 0 : s.codePointAt(0);
    }

    public static String repeat(String s, int n) {
        if (n < 1) {
            return "";
        }
        return Strings.repeat((String)s, (int)n);
    }

    public static String space(int n) {
        return SqlFunctions.repeat(" ", n);
    }

    public static int strcmp(String s0, String s1) {
        return (int)Math.signum(s1.compareTo(s0));
    }

    public static String soundex(String s) {
        return SOUNDEX.soundex(s);
    }

    public static int difference(String s0, String s1) {
        String result0 = SqlFunctions.soundex(s0);
        String result1 = SqlFunctions.soundex(s1);
        for (int i = 0; i < 4; ++i) {
            if (result0.charAt(i) == result1.charAt(i)) continue;
            return i;
        }
        return 4;
    }

    public static String left(String s, int n) {
        if (n <= 0) {
            return "";
        }
        int len = s.length();
        if (n >= len) {
            return s;
        }
        return s.substring(0, n);
    }

    public static ByteString left(ByteString s, int n) {
        if (n <= 0) {
            return ByteString.EMPTY;
        }
        int len = s.length();
        if (n >= len) {
            return s;
        }
        return s.substring(0, n);
    }

    public static String right(String s, int n) {
        if (n <= 0) {
            return "";
        }
        int len = s.length();
        if (n >= len) {
            return s;
        }
        return s.substring(len - n);
    }

    public static ByteString right(ByteString s, int n) {
        if (n <= 0) {
            return ByteString.EMPTY;
        }
        int len = s.length();
        if (n >= len) {
            return s;
        }
        return s.substring(len - n);
    }

    public static @Nullable String charFromAscii(int n) {
        if (n < 0) {
            return null;
        }
        return String.valueOf(Character.toChars(n % 256));
    }

    public static String charFromUtf8(int n) {
        return String.valueOf(Character.toChars(n));
    }

    public static int octetLength(ByteString s) {
        return s.length();
    }

    public static int charLength(String s) {
        return s.length();
    }

    public static String concat(String s0, String s1) {
        return s0 + s1;
    }

    public static ByteString concat(ByteString s0, ByteString s1) {
        return s0.concat(s1);
    }

    public static String concatMulti(String ... args) {
        return String.join((CharSequence)"", args);
    }

    public static String rtrim(String s) {
        return SqlFunctions.trim(false, true, " ", s);
    }

    public static String ltrim(String s) {
        return SqlFunctions.trim(true, false, " ", s);
    }

    public static String trim(boolean left, boolean right, String seek, String s) {
        return SqlFunctions.trim(left, right, seek, s, true);
    }

    public static String trim(boolean left, boolean right, String seek, String s, boolean strict) {
        if (strict && seek.length() != 1) {
            throw Static.RESOURCE.trimError().ex();
        }
        int j = s.length();
        if (right) {
            while (true) {
                if (j == 0) {
                    return "";
                }
                if (seek.indexOf(s.charAt(j - 1)) < 0) break;
                --j;
            }
        }
        int i = 0;
        if (left) {
            while (true) {
                if (i == j) {
                    return "";
                }
                if (seek.indexOf(s.charAt(i)) < 0) break;
                ++i;
            }
        }
        return s.substring(i, j);
    }

    public static ByteString trim(ByteString s) {
        return SqlFunctions.trim_(s, true, true);
    }

    public static ByteString rtrim(ByteString s) {
        return SqlFunctions.trim_(s, false, true);
    }

    private static ByteString trim_(ByteString s, boolean left, boolean right) {
        int j = s.length();
        if (right) {
            while (true) {
                if (j == 0) {
                    return ByteString.EMPTY;
                }
                if (s.byteAt(j - 1) != 0) break;
                --j;
            }
        }
        int i = 0;
        if (left) {
            while (true) {
                if (i == j) {
                    return ByteString.EMPTY;
                }
                if (s.byteAt(i) != 0) break;
                ++i;
            }
        }
        return s.substring(i, j);
    }

    public static String overlay(String s, String r, int start) {
        return s.substring(0, start - 1) + r + s.substring(start - 1 + r.length());
    }

    public static String overlay(String s, String r, int start, int length) {
        return s.substring(0, start - 1) + r + s.substring(start - 1 + length);
    }

    public static ByteString overlay(ByteString s, ByteString r, int start) {
        return s.substring(0, start - 1).concat(r).concat(s.substring(start - 1 + r.length()));
    }

    public static ByteString overlay(ByteString s, ByteString r, int start, int length) {
        return s.substring(0, start - 1).concat(r).concat(s.substring(start - 1 + length));
    }

    public static boolean like(String s, String pattern) {
        String regex = Like.sqlToRegexLike(pattern, null);
        return Pattern.matches(regex, s);
    }

    public static boolean like(String s, String pattern, String escape) {
        String regex = Like.sqlToRegexLike(pattern, escape);
        return Pattern.matches(regex, s);
    }

    public static boolean ilike(String s, String pattern) {
        String regex = Like.sqlToRegexLike(pattern, null);
        return Pattern.compile(regex, 2).matcher(s).matches();
    }

    public static boolean ilike(String s, String pattern, String escape) {
        String regex = Like.sqlToRegexLike(pattern, escape);
        return Pattern.compile(regex, 2).matcher(s).matches();
    }

    public static boolean rlike(String s, String pattern) {
        return Pattern.compile(pattern).matcher(s).find();
    }

    public static boolean similar(String s, String pattern) {
        String regex = Like.sqlToRegexSimilar(pattern, null);
        return Pattern.matches(regex, s);
    }

    public static boolean similar(String s, String pattern, String escape) {
        String regex = Like.sqlToRegexSimilar(pattern, escape);
        return Pattern.matches(regex, s);
    }

    public static boolean posixRegex(String s, String regex, boolean caseSensitive) {
        Pattern pattern = Like.posixRegexToPattern(regex, caseSensitive);
        return pattern.matcher(s).find();
    }

    public static boolean eq(BigDecimal b0, BigDecimal b1) {
        return b0.stripTrailingZeros().equals(b1.stripTrailingZeros());
    }

    public static boolean eq(@Nullable Object @Nullable [] b0, @Nullable Object @Nullable [] b1) {
        return Arrays.deepEquals(b0, b1);
    }

    public static boolean eq(Object b0, Object b1) {
        return b0.equals(b1);
    }

    public static boolean eq(String s0, String s1, Comparator<String> comparator) {
        return comparator.compare(s0, s1) == 0;
    }

    public static boolean eqAny(Object b0, Object b1) {
        if (b0.getClass().equals(b1.getClass())) {
            if (BigDecimal.class.isInstance(b0)) {
                return SqlFunctions.eq((BigDecimal)b0, (BigDecimal)b1);
            }
            return b0.equals(b1);
        }
        if (SqlFunctions.allAssignable(Number.class, b0, b1)) {
            return SqlFunctions.eq(SqlFunctions.toBigDecimal((Number)b0), SqlFunctions.toBigDecimal((Number)b1));
        }
        return false;
    }

    private static boolean allAssignable(Class clazz, Object o0, Object o1) {
        return clazz.isInstance(o0) && clazz.isInstance(o1);
    }

    public static boolean ne(BigDecimal b0, BigDecimal b1) {
        return b0.compareTo(b1) != 0;
    }

    public static boolean ne(Object b0, Object b1) {
        return !SqlFunctions.eq(b0, b1);
    }

    public static boolean ne(String s0, String s1, Comparator<String> comparator) {
        return !SqlFunctions.eq(s0, s1, comparator);
    }

    public static boolean neAny(Object b0, Object b1) {
        return !SqlFunctions.eqAny(b0, b1);
    }

    public static boolean lt(boolean b0, boolean b1) {
        return Boolean.compare(b0, b1) < 0;
    }

    public static boolean lt(String b0, String b1) {
        return b0.compareTo(b1) < 0;
    }

    public static boolean lt(String b0, String b1, Comparator<String> comparator) {
        return comparator.compare(b0, b1) < 0;
    }

    public static boolean lt(ByteString b0, ByteString b1) {
        return b0.compareTo(b1) < 0;
    }

    public static boolean lt(BigDecimal b0, BigDecimal b1) {
        return b0.compareTo(b1) < 0;
    }

    public static <T extends Comparable<T>> boolean ltNullable(T b0, T b1) {
        return b1 == null || b0 != null && b0.compareTo(b1) < 0;
    }

    public static boolean lt(byte b0, byte b1) {
        return b0 < b1;
    }

    public static boolean lt(char b0, char b1) {
        return b0 < b1;
    }

    public static boolean lt(short b0, short b1) {
        return b0 < b1;
    }

    public static boolean lt(int b0, int b1) {
        return b0 < b1;
    }

    public static boolean lt(long b0, long b1) {
        return b0 < b1;
    }

    public static boolean lt(float b0, float b1) {
        return b0 < b1;
    }

    public static boolean lt(double b0, double b1) {
        return b0 < b1;
    }

    public static boolean ltAny(Object b0, Object b1) {
        if (b0.getClass().equals(b1.getClass()) && b0 instanceof Comparable) {
            return ((Comparable)b0).compareTo(b1) < 0;
        }
        if (SqlFunctions.allAssignable(Number.class, b0, b1)) {
            return SqlFunctions.lt(SqlFunctions.toBigDecimal((Number)b0), SqlFunctions.toBigDecimal((Number)b1));
        }
        throw SqlFunctions.notComparable("<", b0, b1);
    }

    public static boolean le(boolean b0, boolean b1) {
        return Boolean.compare(b0, b1) <= 0;
    }

    public static boolean le(String b0, String b1) {
        return b0.compareTo(b1) <= 0;
    }

    public static boolean le(String b0, String b1, Comparator<String> comparator) {
        return comparator.compare(b0, b1) <= 0;
    }

    public static boolean le(ByteString b0, ByteString b1) {
        return b0.compareTo(b1) <= 0;
    }

    public static boolean le(BigDecimal b0, BigDecimal b1) {
        return b0.compareTo(b1) <= 0;
    }

    public static boolean leAny(Object b0, Object b1) {
        if (b0.getClass().equals(b1.getClass()) && b0 instanceof Comparable) {
            return ((Comparable)b0).compareTo(b1) <= 0;
        }
        if (SqlFunctions.allAssignable(Number.class, b0, b1)) {
            return SqlFunctions.le(SqlFunctions.toBigDecimal((Number)b0), SqlFunctions.toBigDecimal((Number)b1));
        }
        throw SqlFunctions.notComparable("<=", b0, b1);
    }

    public static boolean gt(boolean b0, boolean b1) {
        return Boolean.compare(b0, b1) > 0;
    }

    public static boolean gt(String b0, String b1) {
        return b0.compareTo(b1) > 0;
    }

    public static boolean gt(String b0, String b1, Comparator<String> comparator) {
        return comparator.compare(b0, b1) > 0;
    }

    public static boolean gt(ByteString b0, ByteString b1) {
        return b0.compareTo(b1) > 0;
    }

    public static boolean gt(BigDecimal b0, BigDecimal b1) {
        return b0.compareTo(b1) > 0;
    }

    public static <T extends Comparable<T>> boolean gtNullable(T b0, T b1) {
        return b1 == null || b0 != null && b0.compareTo(b1) > 0;
    }

    public static boolean gt(byte b0, byte b1) {
        return b0 > b1;
    }

    public static boolean gt(char b0, char b1) {
        return b0 > b1;
    }

    public static boolean gt(short b0, short b1) {
        return b0 > b1;
    }

    public static boolean gt(int b0, int b1) {
        return b0 > b1;
    }

    public static boolean gt(long b0, long b1) {
        return b0 > b1;
    }

    public static boolean gt(float b0, float b1) {
        return b0 > b1;
    }

    public static boolean gt(double b0, double b1) {
        return b0 > b1;
    }

    public static boolean gtAny(Object b0, Object b1) {
        if (b0.getClass().equals(b1.getClass()) && b0 instanceof Comparable) {
            return ((Comparable)b0).compareTo(b1) > 0;
        }
        if (SqlFunctions.allAssignable(Number.class, b0, b1)) {
            return SqlFunctions.gt(SqlFunctions.toBigDecimal((Number)b0), SqlFunctions.toBigDecimal((Number)b1));
        }
        throw SqlFunctions.notComparable(">", b0, b1);
    }

    public static boolean ge(boolean b0, boolean b1) {
        return Boolean.compare(b0, b1) >= 0;
    }

    public static boolean ge(String b0, String b1) {
        return b0.compareTo(b1) >= 0;
    }

    public static boolean ge(String b0, String b1, Comparator<String> comparator) {
        return comparator.compare(b0, b1) >= 0;
    }

    public static boolean ge(ByteString b0, ByteString b1) {
        return b0.compareTo(b1) >= 0;
    }

    public static boolean ge(BigDecimal b0, BigDecimal b1) {
        return b0.compareTo(b1) >= 0;
    }

    public static boolean geAny(Object b0, Object b1) {
        if (b0.getClass().equals(b1.getClass()) && b0 instanceof Comparable) {
            return ((Comparable)b0).compareTo(b1) >= 0;
        }
        if (SqlFunctions.allAssignable(Number.class, b0, b1)) {
            return SqlFunctions.ge(SqlFunctions.toBigDecimal((Number)b0), SqlFunctions.toBigDecimal((Number)b1));
        }
        throw SqlFunctions.notComparable(">=", b0, b1);
    }

    public static int plus(int b0, int b1) {
        return b0 + b1;
    }

    public static @PolyNull Integer plus(@PolyNull Integer b0, int b1) {
        return b0 == null ? (Integer)Nullness.castNonNull(null) : Integer.valueOf(b0 + b1);
    }

    public static @PolyNull Integer plus(int b0, @PolyNull Integer b1) {
        return b1 == null ? (Integer)Nullness.castNonNull(null) : Integer.valueOf(b0 + b1);
    }

    public static @PolyNull Integer plus(@PolyNull Integer b0, @PolyNull Integer b1) {
        return b0 == null || b1 == null ? (Integer)Nullness.castNonNull(null) : Integer.valueOf(b0 + b1);
    }

    public static @PolyNull Long plus(@PolyNull Long b0, @PolyNull Integer b1) {
        return b0 == null || b1 == null ? (Long)Nullness.castNonNull(null) : Long.valueOf(b0 + b1.longValue());
    }

    public static @PolyNull Long plus(@PolyNull Integer b0, @PolyNull Long b1) {
        return b0 == null || b1 == null ? (Long)Nullness.castNonNull(null) : Long.valueOf(b0.longValue() + b1);
    }

    public static @PolyNull BigDecimal plus(@PolyNull BigDecimal b0, @PolyNull BigDecimal b1) {
        return b0 == null || b1 == null ? (BigDecimal)Nullness.castNonNull(null) : b0.add(b1);
    }

    public static @PolyNull Object plusAny(@PolyNull Object b0, @PolyNull Object b1) {
        if (b0 == null || b1 == null) {
            return Nullness.castNonNull(null);
        }
        if (SqlFunctions.allAssignable(Number.class, b0, b1)) {
            return SqlFunctions.plus(SqlFunctions.toBigDecimal((Number)b0), SqlFunctions.toBigDecimal((Number)b1));
        }
        throw SqlFunctions.notArithmetic("+", b0, b1);
    }

    public static int minus(int b0, int b1) {
        return b0 - b1;
    }

    public static @PolyNull Integer minus(@PolyNull Integer b0, int b1) {
        return b0 == null ? (Integer)Nullness.castNonNull(null) : Integer.valueOf(b0 - b1);
    }

    public static @PolyNull Integer minus(int b0, @PolyNull Integer b1) {
        return b1 == null ? (Integer)Nullness.castNonNull(null) : Integer.valueOf(b0 - b1);
    }

    public static @PolyNull Integer minus(@PolyNull Integer b0, @PolyNull Integer b1) {
        return b0 == null || b1 == null ? (Integer)Nullness.castNonNull(null) : Integer.valueOf(b0 - b1);
    }

    public static @PolyNull Long minus(@PolyNull Long b0, @PolyNull Integer b1) {
        return b0 == null || b1 == null ? (Long)Nullness.castNonNull(null) : Long.valueOf(b0 - b1.longValue());
    }

    public static @PolyNull Long minus(@PolyNull Integer b0, @PolyNull Long b1) {
        return b0 == null || b1 == null ? (Long)Nullness.castNonNull(null) : Long.valueOf(b0.longValue() - b1);
    }

    public static @PolyNull BigDecimal minus(@PolyNull BigDecimal b0, @PolyNull BigDecimal b1) {
        return b0 == null || b1 == null ? (BigDecimal)Nullness.castNonNull(null) : b0.subtract(b1);
    }

    public static @PolyNull Object minusAny(@PolyNull Object b0, @PolyNull Object b1) {
        if (b0 == null || b1 == null) {
            return Nullness.castNonNull(null);
        }
        if (SqlFunctions.allAssignable(Number.class, b0, b1)) {
            return SqlFunctions.minus(SqlFunctions.toBigDecimal((Number)b0), SqlFunctions.toBigDecimal((Number)b1));
        }
        throw SqlFunctions.notArithmetic("-", b0, b1);
    }

    public static int divide(int b0, int b1) {
        return b0 / b1;
    }

    public static @PolyNull Integer divide(@PolyNull Integer b0, int b1) {
        return b0 == null ? (Integer)Nullness.castNonNull(null) : Integer.valueOf(b0 / b1);
    }

    public static @PolyNull Integer divide(int b0, @PolyNull Integer b1) {
        return b1 == null ? (Integer)Nullness.castNonNull(null) : Integer.valueOf(b0 / b1);
    }

    public static @PolyNull Integer divide(@PolyNull Integer b0, @PolyNull Integer b1) {
        return b0 == null || b1 == null ? (Integer)Nullness.castNonNull(null) : Integer.valueOf(b0 / b1);
    }

    public static @PolyNull Long divide(Long b0, @PolyNull Integer b1) {
        return b0 == null || b1 == null ? (Long)Nullness.castNonNull(null) : Long.valueOf(b0 / b1.longValue());
    }

    public static @PolyNull Long divide(@PolyNull Integer b0, @PolyNull Long b1) {
        return b0 == null || b1 == null ? (Long)Nullness.castNonNull(null) : Long.valueOf(b0.longValue() / b1);
    }

    public static @PolyNull BigDecimal divide(@PolyNull BigDecimal b0, @PolyNull BigDecimal b1) {
        return b0 == null || b1 == null ? (BigDecimal)Nullness.castNonNull(null) : b0.divide(b1, MathContext.DECIMAL64);
    }

    public static @PolyNull Object divideAny(@PolyNull Object b0, @PolyNull Object b1) {
        if (b0 == null || b1 == null) {
            return Nullness.castNonNull(null);
        }
        if (SqlFunctions.allAssignable(Number.class, b0, b1)) {
            return SqlFunctions.divide(SqlFunctions.toBigDecimal((Number)b0), SqlFunctions.toBigDecimal((Number)b1));
        }
        throw SqlFunctions.notArithmetic("/", b0, b1);
    }

    public static int divide(int b0, BigDecimal b1) {
        return BigDecimal.valueOf(b0).divide(b1, RoundingMode.HALF_DOWN).intValue();
    }

    public static long divide(long b0, BigDecimal b1) {
        return BigDecimal.valueOf(b0).divide(b1, RoundingMode.HALF_DOWN).longValue();
    }

    public static int multiply(int b0, int b1) {
        return b0 * b1;
    }

    public static @PolyNull Integer multiply(@PolyNull Integer b0, int b1) {
        return b0 == null ? (Integer)Nullness.castNonNull(null) : Integer.valueOf(b0 * b1);
    }

    public static @PolyNull Integer multiply(int b0, @PolyNull Integer b1) {
        return b1 == null ? (Integer)Nullness.castNonNull(null) : Integer.valueOf(b0 * b1);
    }

    public static @PolyNull Integer multiply(@PolyNull Integer b0, @PolyNull Integer b1) {
        return b0 == null || b1 == null ? (Integer)Nullness.castNonNull(null) : Integer.valueOf(b0 * b1);
    }

    public static @PolyNull Long multiply(@PolyNull Long b0, @PolyNull Integer b1) {
        return b0 == null || b1 == null ? (Long)Nullness.castNonNull(null) : Long.valueOf(b0 * b1.longValue());
    }

    public static @PolyNull Long multiply(@PolyNull Integer b0, @PolyNull Long b1) {
        return b0 == null || b1 == null ? (Long)Nullness.castNonNull(null) : Long.valueOf(b0.longValue() * b1);
    }

    public static @PolyNull BigDecimal multiply(@PolyNull BigDecimal b0, @PolyNull BigDecimal b1) {
        return b0 == null || b1 == null ? (BigDecimal)Nullness.castNonNull(null) : b0.multiply(b1);
    }

    public static @PolyNull Object multiplyAny(@PolyNull Object b0, @PolyNull Object b1) {
        if (b0 == null || b1 == null) {
            return Nullness.castNonNull(null);
        }
        if (SqlFunctions.allAssignable(Number.class, b0, b1)) {
            return SqlFunctions.multiply(SqlFunctions.toBigDecimal((Number)b0), SqlFunctions.toBigDecimal((Number)b1));
        }
        throw SqlFunctions.notArithmetic("*", b0, b1);
    }

    private static RuntimeException notArithmetic(String op, Object b0, Object b1) {
        return Static.RESOURCE.invalidTypesForArithmetic(b0.getClass().toString(), op, b1.getClass().toString()).ex();
    }

    private static RuntimeException notComparable(String op, Object b0, Object b1) {
        return Static.RESOURCE.invalidTypesForComparison(b0.getClass().toString(), op, b1.getClass().toString()).ex();
    }

    public static long bitAnd(long b0, long b1) {
        return b0 & b1;
    }

    public static ByteString bitAnd(ByteString b0, ByteString b1) {
        return SqlFunctions.binaryOperator(b0, b1, (x, y) -> (byte)(x & y));
    }

    public static long bitOr(long b0, long b1) {
        return b0 | b1;
    }

    public static ByteString bitOr(ByteString b0, ByteString b1) {
        return SqlFunctions.binaryOperator(b0, b1, (x, y) -> (byte)(x | y));
    }

    public static long bitXor(long b0, long b1) {
        return b0 ^ b1;
    }

    public static ByteString bitXor(ByteString b0, ByteString b1) {
        return SqlFunctions.binaryOperator(b0, b1, (x, y) -> (byte)(x ^ y));
    }

    private static ByteString binaryOperator(ByteString b0, ByteString b1, BinaryOperator<Byte> bitOp) {
        if (b0.length() == 0) {
            return b1;
        }
        if (b1.length() == 0) {
            return b0;
        }
        if (b0.length() != b1.length()) {
            throw Static.RESOURCE.differentLengthForBitwiseOperands(b0.length(), b1.length()).ex();
        }
        byte[] result = new byte[b0.length()];
        for (int i = 0; i < b0.length(); ++i) {
            result[i] = (Byte)bitOp.apply(b0.byteAt(i), b1.byteAt(i));
        }
        return new ByteString(result);
    }

    public static double exp(double b0) {
        return Math.exp(b0);
    }

    public static double exp(BigDecimal b0) {
        return Math.exp(b0.doubleValue());
    }

    public static double power(double b0, double b1) {
        return Math.pow(b0, b1);
    }

    public static double power(double b0, BigDecimal b1) {
        return Math.pow(b0, b1.doubleValue());
    }

    public static double power(BigDecimal b0, double b1) {
        return Math.pow(b0.doubleValue(), b1);
    }

    public static double power(BigDecimal b0, BigDecimal b1) {
        return Math.pow(b0.doubleValue(), b1.doubleValue());
    }

    public static double ln(double d) {
        return Math.log(d);
    }

    public static double ln(BigDecimal d) {
        return Math.log(d.doubleValue());
    }

    public static double log10(double b0) {
        return Math.log10(b0);
    }

    public static double log10(BigDecimal d) {
        return Math.log10(d.doubleValue());
    }

    public static byte mod(byte b0, byte b1) {
        return (byte)(b0 % b1);
    }

    public static short mod(short b0, short b1) {
        return (short)(b0 % b1);
    }

    public static int mod(int b0, int b1) {
        return b0 % b1;
    }

    public static long mod(long b0, long b1) {
        return b0 % b1;
    }

    public static BigDecimal mod(BigDecimal b0, int b1) {
        return SqlFunctions.mod(b0, BigDecimal.valueOf(b1));
    }

    public static BigDecimal mod(int b0, BigDecimal b1) {
        return SqlFunctions.mod(BigDecimal.valueOf(b0), b1);
    }

    public static BigDecimal mod(BigDecimal b0, BigDecimal b1) {
        BigDecimal[] bigDecimals = b0.divideAndRemainder(b1);
        return bigDecimals[1];
    }

    public static double floor(double b0) {
        return Math.floor(b0);
    }

    public static float floor(float b0) {
        return (float)Math.floor(b0);
    }

    public static BigDecimal floor(BigDecimal b0) {
        return b0.setScale(0, RoundingMode.FLOOR);
    }

    public static byte floor(byte b0, byte b1) {
        return (byte)SqlFunctions.floor((int)b0, (int)b1);
    }

    public static short floor(short b0, short b1) {
        return (short)SqlFunctions.floor((int)b0, (int)b1);
    }

    public static int floor(int b0, int b1) {
        int r = b0 % b1;
        if (r < 0) {
            r += b1;
        }
        return b0 - r;
    }

    public static long floor(long b0, long b1) {
        long r = b0 % b1;
        if (r < 0L) {
            r += b1;
        }
        return b0 - r;
    }

    public static BigDecimal floor(BigDecimal b0, int b1) {
        return SqlFunctions.floor(b0, BigDecimal.valueOf(b1));
    }

    public static int floor(int b0, BigDecimal b1) {
        return SqlFunctions.floor(b0, b1.intValue());
    }

    public static BigDecimal floor(BigDecimal b0, BigDecimal b1) {
        BigDecimal[] bigDecimals = b0.divideAndRemainder(b1);
        BigDecimal r = bigDecimals[1];
        if (r.signum() < 0) {
            r = r.add(b1);
        }
        return b0.subtract(r);
    }

    public static double ceil(double b0) {
        return Math.ceil(b0);
    }

    public static float ceil(float b0) {
        return (float)Math.ceil(b0);
    }

    public static BigDecimal ceil(BigDecimal b0) {
        return b0.setScale(0, RoundingMode.CEILING);
    }

    public static byte ceil(byte b0, byte b1) {
        return SqlFunctions.floor((byte)(b0 + b1 - 1), b1);
    }

    public static short ceil(short b0, short b1) {
        return SqlFunctions.floor((short)(b0 + b1 - 1), b1);
    }

    public static int ceil(int b0, int b1) {
        int r = b0 % b1;
        if (r > 0) {
            r -= b1;
        }
        return b0 - r;
    }

    public static long ceil(long b0, long b1) {
        return SqlFunctions.floor(b0 + b1 - 1L, b1);
    }

    public static BigDecimal ceil(BigDecimal b0, int b1) {
        return SqlFunctions.ceil(b0, BigDecimal.valueOf(b1));
    }

    public static int ceil(int b0, BigDecimal b1) {
        return SqlFunctions.ceil(b0, b1.intValue());
    }

    public static BigDecimal ceil(BigDecimal b0, BigDecimal b1) {
        BigDecimal[] bigDecimals = b0.divideAndRemainder(b1);
        BigDecimal r = bigDecimals[1];
        if (r.signum() > 0) {
            r = r.subtract(b1);
        }
        return b0.subtract(r);
    }

    public static byte abs(byte b0) {
        return (byte)Math.abs(b0);
    }

    public static short abs(short b0) {
        return (short)Math.abs(b0);
    }

    public static int abs(int b0) {
        return Math.abs(b0);
    }

    public static long abs(long b0) {
        return Math.abs(b0);
    }

    public static float abs(float b0) {
        return Math.abs(b0);
    }

    public static double abs(double b0) {
        return Math.abs(b0);
    }

    public static BigDecimal abs(BigDecimal b0) {
        return b0.abs();
    }

    public static double acos(BigDecimal b0) {
        return Math.acos(b0.doubleValue());
    }

    public static double acos(double b0) {
        return Math.acos(b0);
    }

    public static double asin(BigDecimal b0) {
        return Math.asin(b0.doubleValue());
    }

    public static double asin(double b0) {
        return Math.asin(b0);
    }

    public static double atan(BigDecimal b0) {
        return Math.atan(b0.doubleValue());
    }

    public static double atan(double b0) {
        return Math.atan(b0);
    }

    public static double atan2(double b0, BigDecimal b1) {
        return Math.atan2(b0, b1.doubleValue());
    }

    public static double atan2(BigDecimal b0, double b1) {
        return Math.atan2(b0.doubleValue(), b1);
    }

    public static double atan2(BigDecimal b0, BigDecimal b1) {
        return Math.atan2(b0.doubleValue(), b1.doubleValue());
    }

    public static double atan2(double b0, double b1) {
        return Math.atan2(b0, b1);
    }

    public static double cbrt(BigDecimal b) {
        return SqlFunctions.cbrt(b.doubleValue());
    }

    public static double cbrt(double b) {
        return Math.cbrt(b);
    }

    public static double cos(BigDecimal b0) {
        return Math.cos(b0.doubleValue());
    }

    public static double cos(double b0) {
        return Math.cos(b0);
    }

    public static double cosh(BigDecimal b) {
        return SqlFunctions.cosh(b.doubleValue());
    }

    public static double cosh(double b) {
        return Math.cosh(b);
    }

    public static double cot(BigDecimal b0) {
        return 1.0 / Math.tan(b0.doubleValue());
    }

    public static double cot(double b0) {
        return 1.0 / Math.tan(b0);
    }

    public static double degrees(BigDecimal b0) {
        return Math.toDegrees(b0.doubleValue());
    }

    public static double degrees(double b0) {
        return Math.toDegrees(b0);
    }

    public static double radians(BigDecimal b0) {
        return Math.toRadians(b0.doubleValue());
    }

    public static double radians(double b0) {
        return Math.toRadians(b0);
    }

    public static int sround(int b0) {
        return SqlFunctions.sround(b0, 0);
    }

    public static int sround(int b0, int b1) {
        return SqlFunctions.sround(BigDecimal.valueOf(b0), b1).intValue();
    }

    public static long sround(long b0) {
        return SqlFunctions.sround(b0, 0);
    }

    public static long sround(long b0, int b1) {
        return SqlFunctions.sround(BigDecimal.valueOf(b0), b1).longValue();
    }

    public static BigDecimal sround(BigDecimal b0) {
        return SqlFunctions.sround(b0, 0);
    }

    public static BigDecimal sround(BigDecimal b0, int b1) {
        return b0.movePointRight(b1).setScale(0, RoundingMode.HALF_UP).movePointLeft(b1);
    }

    public static double sround(double b0) {
        return SqlFunctions.sround(b0, 0);
    }

    public static double sround(double b0, int b1) {
        return SqlFunctions.sround(BigDecimal.valueOf(b0), b1).doubleValue();
    }

    public static int struncate(int b0) {
        return SqlFunctions.struncate(b0, 0);
    }

    public static int struncate(int b0, int b1) {
        return SqlFunctions.struncate(BigDecimal.valueOf(b0), b1).intValue();
    }

    public static long struncate(long b0) {
        return SqlFunctions.struncate(b0, 0);
    }

    public static long struncate(long b0, int b1) {
        return SqlFunctions.struncate(BigDecimal.valueOf(b0), b1).longValue();
    }

    public static BigDecimal struncate(BigDecimal b0) {
        return SqlFunctions.struncate(b0, 0);
    }

    public static BigDecimal struncate(BigDecimal b0, int b1) {
        return b0.movePointRight(b1).setScale(0, RoundingMode.DOWN).movePointLeft(b1);
    }

    public static double struncate(double b0) {
        return SqlFunctions.struncate(b0, 0);
    }

    public static double struncate(double b0, int b1) {
        return SqlFunctions.struncate(BigDecimal.valueOf(b0), b1).doubleValue();
    }

    public static int sign(int b0) {
        return Integer.signum(b0);
    }

    public static long sign(long b0) {
        return Long.signum(b0);
    }

    public static BigDecimal sign(BigDecimal b0) {
        return BigDecimal.valueOf(b0.signum());
    }

    public static double sign(double b0) {
        return Math.signum(b0);
    }

    public static double sin(BigDecimal b0) {
        return Math.sin(b0.doubleValue());
    }

    public static double sin(double b0) {
        return Math.sin(b0);
    }

    public static double sinh(BigDecimal b) {
        return SqlFunctions.sinh(b.doubleValue());
    }

    public static double sinh(double b) {
        return Math.sinh(b);
    }

    public static double tan(BigDecimal b0) {
        return Math.tan(b0.doubleValue());
    }

    public static double tan(double b0) {
        return Math.tan(b0);
    }

    public static double tanh(BigDecimal b) {
        return SqlFunctions.tanh(b.doubleValue());
    }

    public static double tanh(double b) {
        return Math.tanh(b);
    }

    public static <T extends Comparable<T>> T lesser(T b0, T b1) {
        return b0 == null || b0.compareTo(b1) > 0 ? b1 : b0;
    }

    public static <T extends Comparable<T>> T least(T b0, T b1) {
        return b0 == null || b1 != null && b0.compareTo(b1) > 0 ? b1 : b0;
    }

    public static boolean greater(boolean b0, boolean b1) {
        return b0 || b1;
    }

    public static boolean lesser(boolean b0, boolean b1) {
        return b0 && b1;
    }

    public static byte greater(byte b0, byte b1) {
        return b0 > b1 ? b0 : b1;
    }

    public static byte lesser(byte b0, byte b1) {
        return b0 > b1 ? b1 : b0;
    }

    public static char greater(char b0, char b1) {
        return b0 > b1 ? b0 : b1;
    }

    public static char lesser(char b0, char b1) {
        return b0 > b1 ? b1 : b0;
    }

    public static short greater(short b0, short b1) {
        return b0 > b1 ? b0 : b1;
    }

    public static short lesser(short b0, short b1) {
        return b0 > b1 ? b1 : b0;
    }

    public static int greater(int b0, int b1) {
        return b0 > b1 ? b0 : b1;
    }

    public static int lesser(int b0, int b1) {
        return b0 > b1 ? b1 : b0;
    }

    public static long greater(long b0, long b1) {
        return b0 > b1 ? b0 : b1;
    }

    public static long lesser(long b0, long b1) {
        return b0 > b1 ? b1 : b0;
    }

    public static float greater(float b0, float b1) {
        return b0 > b1 ? b0 : b1;
    }

    public static float lesser(float b0, float b1) {
        return b0 > b1 ? b1 : b0;
    }

    public static double greater(double b0, double b1) {
        return b0 > b1 ? b0 : b1;
    }

    public static double lesser(double b0, double b1) {
        return b0 > b1 ? b1 : b0;
    }

    public static <T extends Comparable<T>> T greater(T b0, T b1) {
        return b0 == null || b0.compareTo(b1) < 0 ? b1 : b0;
    }

    public static <T extends Comparable<T>> T greatest(T b0, T b1) {
        return b0 == null || b1 != null && b0.compareTo(b1) < 0 ? b1 : b0;
    }

    public static String toString(float x) {
        if (x == 0.0f) {
            return "0E0";
        }
        BigDecimal bigDecimal = new BigDecimal(x, MathContext.DECIMAL32).stripTrailingZeros();
        String s = bigDecimal.toString();
        return PATTERN_0_STAR_E.matcher(s).replaceAll("E").replace("E+", "E");
    }

    public static String toString(double x) {
        if (x == 0.0) {
            return "0E0";
        }
        BigDecimal bigDecimal = new BigDecimal(x, MathContext.DECIMAL64).stripTrailingZeros();
        String s = bigDecimal.toString();
        return PATTERN_0_STAR_E.matcher(s).replaceAll("E").replace("E+", "E");
    }

    public static String toString(BigDecimal x) {
        String s = x.toString();
        if (s.equals("0")) {
            return s;
        }
        if (s.startsWith("0.")) {
            return s.substring(1);
        }
        if (s.startsWith("-0.")) {
            return "-" + s.substring(2);
        }
        return s;
    }

    public static String toString(boolean x) {
        return x ? "TRUE" : "FALSE";
    }

    @NonDeterministic
    private static Object cannotConvert(Object o, Class toType) {
        throw Static.RESOURCE.cannotConvert(String.valueOf(o), toType.toString()).ex();
    }

    public static boolean toBoolean(String s) {
        if ((s = SqlFunctions.trim(true, true, " ", s)).equalsIgnoreCase("TRUE")) {
            return true;
        }
        if (s.equalsIgnoreCase("FALSE")) {
            return false;
        }
        throw Static.RESOURCE.invalidCharacterForCast(s).ex();
    }

    public static boolean toBoolean(Number number) {
        return !number.equals(0);
    }

    public static boolean toBoolean(Object o) {
        return o instanceof Boolean ? (Boolean)o : (o instanceof Number ? SqlFunctions.toBoolean((Number)o) : (o instanceof String ? SqlFunctions.toBoolean((String)o) : (Boolean)SqlFunctions.cannotConvert(o, Boolean.TYPE)));
    }

    public static byte toByte(Object o) {
        return o instanceof Byte ? (Byte)o : (o instanceof Number ? SqlFunctions.toByte((Number)o) : Byte.parseByte(o.toString()));
    }

    public static byte toByte(Number number) {
        return number.byteValue();
    }

    public static char toChar(String s) {
        return s.charAt(0);
    }

    public static Character toCharBoxed(String s) {
        return Character.valueOf(s.charAt(0));
    }

    public static short toShort(String s) {
        return Short.parseShort(s.trim());
    }

    public static short toShort(Number number) {
        return number.shortValue();
    }

    public static short toShort(Object o) {
        return o instanceof Short ? (Short)o : (o instanceof Number ? SqlFunctions.toShort((Number)o) : (o instanceof String ? SqlFunctions.toShort((String)o) : (Short)SqlFunctions.cannotConvert(o, Short.TYPE)));
    }

    public static int toInt(Date v) {
        return SqlFunctions.toInt(v, LOCAL_TZ);
    }

    public static int toInt(Date v, TimeZone timeZone) {
        return DateTimeUtils.sqlDateToUnixDate((Date)v, (TimeZone)timeZone);
    }

    public static @PolyNull Integer toIntOptional(@PolyNull Date v) {
        return v == null ? (Integer)Nullness.castNonNull(null) : Integer.valueOf(SqlFunctions.toInt(v));
    }

    public static @PolyNull Integer toIntOptional(@PolyNull Date v, TimeZone timeZone) {
        return v == null ? (Integer)Nullness.castNonNull(null) : Integer.valueOf(SqlFunctions.toInt(v, timeZone));
    }

    public static int toInt(Time v) {
        return DateTimeUtils.sqlTimeToUnixTime((Time)v, (TimeZone)LOCAL_TZ);
    }

    public static @PolyNull Integer toIntOptional(@PolyNull Time v) {
        return v == null ? (Integer)Nullness.castNonNull(null) : Integer.valueOf(SqlFunctions.toInt(v));
    }

    public static int toInt(String s) {
        return Integer.parseInt(s.trim());
    }

    public static int toInt(Number number) {
        return number.intValue();
    }

    public static int toInt(Object o) {
        return o instanceof Integer ? (Integer)o : (o instanceof Number ? SqlFunctions.toInt((Number)o) : (o instanceof String ? SqlFunctions.toInt((String)o) : (o instanceof Date ? SqlFunctions.toInt((Date)o) : (o instanceof Time ? SqlFunctions.toInt((Time)o) : (Integer)SqlFunctions.cannotConvert(o, Integer.TYPE)))));
    }

    public static @PolyNull Integer toIntOptional(@PolyNull Object o) {
        return o == null ? (Integer)Nullness.castNonNull(null) : Integer.valueOf(SqlFunctions.toInt(o));
    }

    public static long toLong(java.util.Date v) {
        return DateTimeUtils.utilDateToUnixTimestamp((java.util.Date)v, (TimeZone)LOCAL_TZ);
    }

    public static long toLong(Timestamp v) {
        return SqlFunctions.toLong(v, LOCAL_TZ);
    }

    public static long toLong(Timestamp v, TimeZone timeZone) {
        return DateTimeUtils.sqlTimestampToUnixTimestamp((Timestamp)v, (TimeZone)timeZone);
    }

    public static @PolyNull Long toLongOptional(@PolyNull Timestamp v) {
        return v == null ? (Long)Nullness.castNonNull(null) : Long.valueOf(SqlFunctions.toLong(v, LOCAL_TZ));
    }

    public static @PolyNull Long toLongOptional(@PolyNull Timestamp v, TimeZone timeZone) {
        if (v == null) {
            return (Long)Nullness.castNonNull(null);
        }
        return SqlFunctions.toLong(v, timeZone);
    }

    public static long toLong(String s) {
        if (s.startsWith("199") && s.contains(":")) {
            return Timestamp.valueOf(s).getTime();
        }
        return Long.parseLong(s.trim());
    }

    public static long toLong(Number number) {
        return number.longValue();
    }

    public static long toLong(Object o) {
        return o instanceof Long ? (Long)o : (o instanceof Number ? SqlFunctions.toLong((Number)o) : (o instanceof String ? SqlFunctions.toLong((String)o) : (o instanceof Date ? (long)SqlFunctions.toInt((Date)o) : (o instanceof Time ? (long)SqlFunctions.toInt((Time)o) : (o instanceof Timestamp ? SqlFunctions.toLong((Timestamp)o) : (o instanceof java.util.Date ? SqlFunctions.toLong((java.util.Date)o) : (Long)SqlFunctions.cannotConvert(o, Long.TYPE)))))));
    }

    public static @PolyNull Long toLongOptional(@PolyNull Object o) {
        return o == null ? (Long)Nullness.castNonNull(null) : Long.valueOf(SqlFunctions.toLong(o));
    }

    public static float toFloat(String s) {
        return Float.parseFloat(s.trim());
    }

    public static float toFloat(Number number) {
        return number.floatValue();
    }

    public static float toFloat(Object o) {
        return o instanceof Float ? ((Float)o).floatValue() : (o instanceof Number ? SqlFunctions.toFloat((Number)o) : (o instanceof String ? SqlFunctions.toFloat((String)o) : ((Float)SqlFunctions.cannotConvert(o, Float.TYPE)).floatValue()));
    }

    public static double toDouble(String s) {
        return Double.parseDouble(s.trim());
    }

    public static double toDouble(Number number) {
        return number.doubleValue();
    }

    public static double toDouble(Object o) {
        return o instanceof Double ? (Double)o : (o instanceof Number ? SqlFunctions.toDouble((Number)o) : (o instanceof String ? SqlFunctions.toDouble((String)o) : (Double)SqlFunctions.cannotConvert(o, Double.TYPE)));
    }

    public static BigDecimal toBigDecimal(String s) {
        return new BigDecimal(s.trim());
    }

    public static BigDecimal toBigDecimal(Number number) {
        return number instanceof BigDecimal ? (BigDecimal)number : (number instanceof BigInteger ? new BigDecimal((BigInteger)number) : (number instanceof Long ? new BigDecimal(number.longValue()) : new BigDecimal(number.doubleValue())));
    }

    public static BigDecimal toBigDecimal(Object o) {
        return o instanceof Number ? SqlFunctions.toBigDecimal((Number)o) : SqlFunctions.toBigDecimal(o.toString());
    }

    public static Date internalToDate(int v) {
        LocalDate date = LocalDate.ofEpochDay(v);
        return Date.valueOf(date);
    }

    public static @PolyNull Date internalToDate(@PolyNull Integer v) {
        return v == null ? (Date)Nullness.castNonNull(null) : SqlFunctions.internalToDate((int)v);
    }

    public static Time internalToTime(int v) {
        return new Time(v - LOCAL_TZ.getOffset(v));
    }

    public static @PolyNull Time internalToTime(@PolyNull Integer v) {
        return v == null ? (Time)Nullness.castNonNull(null) : SqlFunctions.internalToTime((int)v);
    }

    public static @PolyNull Integer toTimeWithLocalTimeZone(@PolyNull String v) {
        if (v == null) {
            return (Integer)Nullness.castNonNull(null);
        }
        return new TimeWithTimeZoneString(v).withTimeZone(DateTimeUtils.UTC_ZONE).getLocalTimeString().getMillisOfDay();
    }

    public static @PolyNull Integer toTimeWithLocalTimeZone(@PolyNull String v, TimeZone timeZone) {
        if (v == null) {
            return (Integer)Nullness.castNonNull(null);
        }
        return new TimeWithTimeZoneString(v + " " + timeZone.getID()).withTimeZone(DateTimeUtils.UTC_ZONE).getLocalTimeString().getMillisOfDay();
    }

    public static int timeWithLocalTimeZoneToTime(int v, TimeZone timeZone) {
        return TimeWithTimeZoneString.fromMillisOfDay(v).withTimeZone(timeZone).getLocalTimeString().getMillisOfDay();
    }

    public static long timeWithLocalTimeZoneToTimestamp(String date, int v, TimeZone timeZone) {
        TimeWithTimeZoneString tTZ = TimeWithTimeZoneString.fromMillisOfDay(v).withTimeZone(DateTimeUtils.UTC_ZONE);
        return new TimestampWithTimeZoneString(date + " " + tTZ.toString()).withTimeZone(timeZone).getLocalTimestampString().getMillisSinceEpoch();
    }

    public static long timeWithLocalTimeZoneToTimestampWithLocalTimeZone(String date, int v) {
        TimeWithTimeZoneString tTZ = TimeWithTimeZoneString.fromMillisOfDay(v).withTimeZone(DateTimeUtils.UTC_ZONE);
        return new TimestampWithTimeZoneString(date + " " + tTZ.toString()).getLocalTimestampString().getMillisSinceEpoch();
    }

    public static String timeWithLocalTimeZoneToString(int v, TimeZone timeZone) {
        return TimeWithTimeZoneString.fromMillisOfDay(v).withTimeZone(timeZone).toString();
    }

    public static Timestamp internalToTimestamp(long v) {
        LocalDateTime dateTime = LocalDateTime.ofEpochSecond(Math.floorDiv(v, 1000L), (int)(Math.floorMod(v, 1000L) * 1000000L), ZoneOffset.UTC);
        return Timestamp.valueOf(dateTime);
    }

    public static @PolyNull Timestamp internalToTimestamp(@PolyNull Long v) {
        return v == null ? (Timestamp)Nullness.castNonNull(null) : SqlFunctions.internalToTimestamp((long)v);
    }

    public static int timestampWithLocalTimeZoneToDate(long v, TimeZone timeZone) {
        return TimestampWithTimeZoneString.fromMillisSinceEpoch(v).withTimeZone(timeZone).getLocalDateString().getDaysSinceEpoch();
    }

    public static int timestampWithLocalTimeZoneToTime(long v, TimeZone timeZone) {
        return TimestampWithTimeZoneString.fromMillisSinceEpoch(v).withTimeZone(timeZone).getLocalTimeString().getMillisOfDay();
    }

    public static long timestampWithLocalTimeZoneToTimestamp(long v, TimeZone timeZone) {
        return TimestampWithTimeZoneString.fromMillisSinceEpoch(v).withTimeZone(timeZone).getLocalTimestampString().getMillisSinceEpoch();
    }

    public static String timestampWithLocalTimeZoneToString(long v, TimeZone timeZone) {
        return TimestampWithTimeZoneString.fromMillisSinceEpoch(v).withTimeZone(timeZone).toString();
    }

    public static int timestampWithLocalTimeZoneToTimeWithLocalTimeZone(long v) {
        return TimestampWithTimeZoneString.fromMillisSinceEpoch(v).getLocalTimeString().getMillisOfDay();
    }

    public static long timestampSeconds(long v) {
        return v * 1000L;
    }

    public static long timestampMillis(long v) {
        return v;
    }

    public static long timestampMicros(long v) {
        return v / 1000L;
    }

    public static long unixSeconds(long v) {
        return v / 1000L;
    }

    public static long unixMillis(long v) {
        return v;
    }

    public static long unixMicros(long v) {
        return v * 1000L;
    }

    public static int dateFromUnixDate(int v) {
        return v;
    }

    public static int unixDate(int v) {
        return v;
    }

    public static @PolyNull Long toTimestampWithLocalTimeZone(@PolyNull String v) {
        if (v == null) {
            return (Long)Nullness.castNonNull(null);
        }
        return new TimestampWithTimeZoneString(v).withTimeZone(DateTimeUtils.UTC_ZONE).getLocalTimestampString().getMillisSinceEpoch();
    }

    public static @PolyNull Long toTimestampWithLocalTimeZone(@PolyNull String v, TimeZone timeZone) {
        if (v == null) {
            return (Long)Nullness.castNonNull(null);
        }
        return new TimestampWithTimeZoneString(v + " " + timeZone.getID()).withTimeZone(DateTimeUtils.UTC_ZONE).getLocalTimestampString().getMillisSinceEpoch();
    }

    public static @PolyNull String truncate(@PolyNull String s, int maxLength) {
        if (s == null) {
            return s;
        }
        if (s.length() > maxLength) {
            return s.substring(0, maxLength);
        }
        return s;
    }

    public static @PolyNull String truncateOrPad(@PolyNull String s, int maxLength) {
        if (s == null) {
            return s;
        }
        int length = s.length();
        if (length > maxLength) {
            return s.substring(0, maxLength);
        }
        return length < maxLength ? Spaces.padRight((String)s, (int)maxLength) : s;
    }

    public static @PolyNull ByteString truncate(@PolyNull ByteString s, int maxLength) {
        if (s == null) {
            return s;
        }
        if (s.length() > maxLength) {
            return s.substring(0, maxLength);
        }
        return s;
    }

    public static @PolyNull ByteString truncateOrPad(@PolyNull ByteString s, int maxLength) {
        if (s == null) {
            return s;
        }
        int length = s.length();
        if (length > maxLength) {
            return s.substring(0, maxLength);
        }
        if (length < maxLength) {
            return s.concat(new ByteString(new byte[maxLength - length]));
        }
        return s;
    }

    public static int position(String seek, String s) {
        return s.indexOf(seek) + 1;
    }

    public static int position(ByteString seek, ByteString s) {
        return s.indexOf(seek) + 1;
    }

    public static int position(String seek, String s, int from) {
        int from0 = from - 1;
        if (from0 > s.length() || from0 < 0) {
            return 0;
        }
        return s.indexOf(seek, from0) + 1;
    }

    public static int position(ByteString seek, ByteString s, int from) {
        int from0 = from - 1;
        if (from0 > s.length() || from0 < 0) {
            return 0;
        }
        return s.indexOf(seek, from0) + 1;
    }

    public static long round(long v, long x) {
        return SqlFunctions.truncate(v + x / 2L, x);
    }

    public static long truncate(long v, long x) {
        long remainder = v % x;
        if (remainder < 0L) {
            remainder += x;
        }
        return v - remainder;
    }

    public static int round(int v, int x) {
        return SqlFunctions.truncate(v + x / 2, x);
    }

    public static int truncate(int v, int x) {
        int remainder = v % x;
        if (remainder < 0) {
            remainder += x;
        }
        return v - remainder;
    }

    public static String dayNameWithTimestamp(long timestamp, Locale locale) {
        return SqlFunctions.timeStampToLocalDate(timestamp).format(ROOT_DAY_FORMAT.withLocale(locale));
    }

    public static String dayNameWithDate(int date, Locale locale) {
        return SqlFunctions.dateToLocalDate(date).format(ROOT_DAY_FORMAT.withLocale(locale));
    }

    public static String monthNameWithTimestamp(long timestamp, Locale locale) {
        return SqlFunctions.timeStampToLocalDate(timestamp).format(ROOT_MONTH_FORMAT.withLocale(locale));
    }

    public static String monthNameWithDate(int date, Locale locale) {
        return SqlFunctions.dateToLocalDate(date).format(ROOT_MONTH_FORMAT.withLocale(locale));
    }

    private static LocalDate dateToLocalDate(int date) {
        int y0 = (int)DateTimeUtils.unixDateExtract((TimeUnitRange)TimeUnitRange.YEAR, (long)date);
        int m0 = (int)DateTimeUtils.unixDateExtract((TimeUnitRange)TimeUnitRange.MONTH, (long)date);
        int d0 = (int)DateTimeUtils.unixDateExtract((TimeUnitRange)TimeUnitRange.DAY, (long)date);
        return LocalDate.of(y0, m0, d0);
    }

    private static LocalDate timeStampToLocalDate(long timestamp) {
        int date = SqlFunctions.timestampToDate(timestamp);
        return SqlFunctions.dateToLocalDate(date);
    }

    public static int timestampToDate(long timestamp) {
        return (int)(timestamp / 86400000L);
    }

    public static int timestampToTime(long timestamp) {
        return (int)(timestamp % 86400000L);
    }

    @NonDeterministic
    public static long currentTimestamp(DataContext root) {
        return (Long)DataContext.Variable.CURRENT_TIMESTAMP.get(root);
    }

    @NonDeterministic
    public static int currentTime(DataContext root) {
        int time = SqlFunctions.timestampToTime(SqlFunctions.currentTimestamp(root));
        if (time < 0) {
            time = (int)((long)time + 86400000L);
        }
        return time;
    }

    @NonDeterministic
    public static int currentDate(DataContext root) {
        long timestamp = SqlFunctions.currentTimestamp(root);
        int date = SqlFunctions.timestampToDate(timestamp);
        int time = SqlFunctions.timestampToTime(timestamp);
        if (time < 0) {
            --date;
        }
        return date;
    }

    @NonDeterministic
    public static long localTimestamp(DataContext root) {
        return (Long)DataContext.Variable.LOCAL_TIMESTAMP.get(root);
    }

    @NonDeterministic
    public static int localTime(DataContext root) {
        return SqlFunctions.timestampToTime(SqlFunctions.localTimestamp(root));
    }

    @NonDeterministic
    public static TimeZone timeZone(DataContext root) {
        return (TimeZone)DataContext.Variable.TIME_ZONE.get(root);
    }

    @Deterministic
    public static String user(DataContext root) {
        return (String)Objects.requireNonNull(DataContext.Variable.USER.get(root));
    }

    @Deterministic
    public static String systemUser(DataContext root) {
        return (String)Objects.requireNonNull(DataContext.Variable.SYSTEM_USER.get(root));
    }

    @NonDeterministic
    public static Locale locale(DataContext root) {
        return (Locale)DataContext.Variable.LOCALE.get(root);
    }

    public static int customDateAdd(DataContext root, String timeFrameName, int interval, int date) {
        TimeFrameSet timeFrameSet = (TimeFrameSet)Objects.requireNonNull(DataContext.Variable.TIME_FRAME_SET.get(root));
        TimeFrame timeFrame = timeFrameSet.get(timeFrameName);
        return timeFrameSet.addDate(date, interval, timeFrame);
    }

    public static long customTimestampAdd(DataContext root, String timeFrameName, long interval, long timestamp) {
        TimeFrameSet timeFrameSet = (TimeFrameSet)Objects.requireNonNull(DataContext.Variable.TIME_FRAME_SET.get(root));
        TimeFrame timeFrame = timeFrameSet.get(timeFrameName);
        return timeFrameSet.addTimestamp(timestamp, interval, timeFrame);
    }

    public static int customDateDiff(DataContext root, String timeFrameName, int date, int date2) {
        TimeFrameSet timeFrameSet = (TimeFrameSet)Objects.requireNonNull(DataContext.Variable.TIME_FRAME_SET.get(root));
        TimeFrame timeFrame = timeFrameSet.get(timeFrameName);
        return timeFrameSet.diffDate(date, date2, timeFrame);
    }

    public static long customTimestampDiff(DataContext root, String timeFrameName, long timestamp, long timestamp2) {
        TimeFrameSet timeFrameSet = (TimeFrameSet)Objects.requireNonNull(DataContext.Variable.TIME_FRAME_SET.get(root));
        TimeFrame timeFrame = timeFrameSet.get(timeFrameName);
        return timeFrameSet.diffTimestamp(timestamp, timestamp2, timeFrame);
    }

    public static int customDateFloor(DataContext root, String timeFrameName, int date) {
        TimeFrameSet timeFrameSet = (TimeFrameSet)Objects.requireNonNull(DataContext.Variable.TIME_FRAME_SET.get(root));
        TimeFrame timeFrame = timeFrameSet.get(timeFrameName);
        return timeFrameSet.floorDate(date, timeFrame);
    }

    public static int customDateCeil(DataContext root, String timeFrameName, int date) {
        TimeFrameSet timeFrameSet = (TimeFrameSet)Objects.requireNonNull(DataContext.Variable.TIME_FRAME_SET.get(root));
        TimeFrame timeFrame = timeFrameSet.get(timeFrameName);
        return timeFrameSet.ceilDate(date, timeFrame);
    }

    public static long customTimestampFloor(DataContext root, String timeFrameName, long timestamp) {
        TimeFrameSet timeFrameSet = (TimeFrameSet)Objects.requireNonNull(DataContext.Variable.TIME_FRAME_SET.get(root));
        TimeFrame timeFrame = timeFrameSet.get(timeFrameName);
        return timeFrameSet.floorTimestamp(timestamp, timeFrame);
    }

    public static long customTimestampCeil(DataContext root, String timeFrameName, long timestamp) {
        TimeFrameSet timeFrameSet = (TimeFrameSet)Objects.requireNonNull(DataContext.Variable.TIME_FRAME_SET.get(root));
        TimeFrame timeFrame = timeFrameSet.get(timeFrameName);
        return timeFrameSet.ceilTimestamp(timestamp, timeFrame);
    }

    public static String translate3(String s, String search, String replacement) {
        return StringUtils.replaceChars((String)s, (String)search, (String)replacement);
    }

    public static String replace(String s, String search, String replacement) {
        return s.replace(search, replacement);
    }

    public static @Nullable Object arrayItem(List list, int item) {
        if (item < 1 || item > list.size()) {
            return null;
        }
        return list.get(item - 1);
    }

    public static @Nullable Object mapItem(Map map, Object item) {
        return map.get(item);
    }

    public static @Nullable Object item(Object object, Object index) {
        if (object instanceof Map) {
            return SqlFunctions.mapItem((Map)object, index);
        }
        if (object instanceof List && index instanceof Number) {
            return SqlFunctions.arrayItem((List)object, ((Number)index).intValue());
        }
        if (index instanceof Number) {
            return SqlFunctions.structAccess(object, ((Number)index).intValue() - 1, null);
        }
        if (index instanceof String) {
            return SqlFunctions.structAccess(object, -1, index.toString());
        }
        return null;
    }

    public static @Nullable Object arrayItemOptional(@Nullable List list, int item) {
        if (list == null) {
            return null;
        }
        return SqlFunctions.arrayItem(list, item);
    }

    public static @Nullable Object mapItemOptional(@Nullable Map map, Object item) {
        if (map == null) {
            return null;
        }
        return SqlFunctions.mapItem(map, item);
    }

    public static @Nullable Object itemOptional(@Nullable Object object, Object index) {
        if (object == null) {
            return null;
        }
        return SqlFunctions.item(object, index);
    }

    public static boolean isTrue(@Nullable Boolean b) {
        return b != null && b != false;
    }

    public static boolean isFalse(@Nullable Boolean b) {
        return b != null && b == false;
    }

    public static boolean isNotTrue(@Nullable Boolean b) {
        return b == null || b == false;
    }

    public static boolean isNotFalse(@Nullable Boolean b) {
        return b == null || b != false;
    }

    public static @PolyNull Boolean not(@PolyNull Boolean b) {
        return b == null ? (Boolean)Nullness.castNonNull(null) : Boolean.valueOf(b == false);
    }

    public static @PolyNull List arrayToList(@PolyNull Array a) {
        if (a == null) {
            return (List)Nullness.castNonNull(null);
        }
        try {
            return Primitive.asList((Object)a.getArray());
        }
        catch (SQLException e) {
            throw Util.toUnchecked(e);
        }
    }

    @NonDeterministic
    public static long sequenceCurrentValue(String key) {
        return SqlFunctions.getAtomicLong(key).get();
    }

    @NonDeterministic
    public static long sequenceNextValue(String key) {
        return SqlFunctions.getAtomicLong(key).incrementAndGet();
    }

    private static AtomicLong getAtomicLong(String key) {
        Map<String, AtomicLong> map = Objects.requireNonNull(THREAD_SEQUENCES.get(), "THREAD_SEQUENCES.get()");
        AtomicLong atomic = map.get(key);
        if (atomic == null) {
            atomic = new AtomicLong();
            map.put(key, atomic);
        }
        return atomic;
    }

    public static List slice(List list) {
        ArrayList<Object> result = new ArrayList<Object>(list.size());
        for (Object e : list) {
            result.add(SqlFunctions.structAccess(e, 0, null));
        }
        return result;
    }

    public static @Nullable Object element(List list) {
        switch (list.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return list.get(0);
            }
        }
        throw Static.RESOURCE.moreThanOneValueInList(list.toString()).ex();
    }

    public static boolean memberOf(@Nullable Object object, Collection collection) {
        return collection.contains(object);
    }

    public static <E> Collection<E> multisetIntersectDistinct(Collection<E> c1, Collection<E> c2) {
        HashSet<E> result = new HashSet<E>(c1);
        result.retainAll(c2);
        return new ArrayList<E>(result);
    }

    public static <E> Collection<E> multisetIntersectAll(Collection<E> c1, Collection<E> c2) {
        ArrayList<E> result = new ArrayList<E>(c1.size());
        ArrayList<E> c2Copy = new ArrayList<E>(c2);
        for (E e : c1) {
            if (!c2Copy.remove(e)) continue;
            result.add(e);
        }
        return result;
    }

    public static <E> Collection<E> multisetExceptAll(Collection<E> c1, Collection<E> c2) {
        LinkedList<E> result = new LinkedList<E>(c1);
        for (E e : c2) {
            result.remove(e);
        }
        return result;
    }

    public static <E> Collection<E> multisetExceptDistinct(Collection<E> c1, Collection<E> c2) {
        HashSet<E> result = new HashSet<E>(c1);
        result.removeAll(c2);
        return new ArrayList<E>(result);
    }

    public static boolean isASet(Collection collection) {
        if (collection instanceof Set) {
            return true;
        }
        HashSet set = new HashSet(Math.max((int)((float)collection.size() / 0.75f) + 1, 16));
        for (Object e : collection) {
            if (set.add(e)) continue;
            return false;
        }
        return true;
    }

    public static boolean submultisetOf(Collection possibleSubMultiset, Collection multiset) {
        if (possibleSubMultiset.size() > multiset.size()) {
            return false;
        }
        LinkedList multisetLocal = new LinkedList(multiset);
        for (Object e : possibleSubMultiset) {
            if (multisetLocal.remove(e)) continue;
            return false;
        }
        return true;
    }

    public static Collection multisetUnionDistinct(Collection collection1, Collection collection2) {
        HashSet resultCollection = new HashSet(Math.max((int)((float)(collection1.size() + collection2.size()) / 0.75f) + 1, 16));
        resultCollection.addAll(collection1);
        resultCollection.addAll(collection2);
        return new ArrayList(resultCollection);
    }

    public static Collection multisetUnionAll(Collection collection1, Collection collection2) {
        ArrayList resultCollection = new ArrayList(collection1.size() + collection2.size());
        resultCollection.addAll(collection1);
        resultCollection.addAll(collection2);
        return resultCollection;
    }

    public static List reverse(List list) {
        Collections.reverse(list);
        return list;
    }

    public static Function1<List<Object>, Enumerable<Object>> flatList() {
        return inputList -> Linq4j.asEnumerable((List)inputList).select(v -> SqlFunctions.structAccess(v, 0, null));
    }

    public static Function1<Object, Enumerable<FlatLists.ComparableList<Comparable>>> flatProduct(int[] fieldCounts, boolean withOrdinality, FlatProductInputType[] inputTypes) {
        if (fieldCounts.length == 1) {
            if (!withOrdinality && inputTypes[0] == FlatProductInputType.SCALAR) {
                return LIST_AS_ENUMERABLE;
            }
            return row -> SqlFunctions.p2(new Object[]{row}, fieldCounts, withOrdinality, inputTypes);
        }
        return lists -> SqlFunctions.p2((Object[])lists, fieldCounts, withOrdinality, inputTypes);
    }

    private static Enumerable<FlatLists.ComparableList<Comparable>> p2(Object[] lists, int[] fieldCounts, boolean withOrdinality, FlatProductInputType[] inputTypes) {
        ArrayList<Enumerator<List<Enumerator>>> enumerators = new ArrayList<Enumerator<List<Enumerator>>>();
        int totalFieldCount = 0;
        for (int i = 0; i < lists.length; ++i) {
            int fieldCount = fieldCounts[i];
            FlatProductInputType inputType = inputTypes[i];
            Object inputObject = lists[i];
            switch (inputType) {
                case SCALAR: {
                    List list = (List)inputObject;
                    enumerators.add(Linq4j.transform((Enumerator)Linq4j.enumerator((Collection)list), FlatLists::of));
                    break;
                }
                case LIST: {
                    List listList = (List)inputObject;
                    enumerators.add(Linq4j.enumerator((Collection)listList));
                    break;
                }
                case MAP: {
                    Map map = (Map)inputObject;
                    Enumerator enumerator = Linq4j.enumerator(map.entrySet());
                    Enumerator transformed = Linq4j.transform((Enumerator)enumerator, e -> FlatLists.of(e.getKey(), e.getValue()));
                    enumerators.add(transformed);
                    break;
                }
            }
            if (fieldCount < 0) {
                ++totalFieldCount;
                continue;
            }
            totalFieldCount += fieldCount;
        }
        if (withOrdinality) {
            ++totalFieldCount;
        }
        return SqlFunctions.product(enumerators, totalFieldCount, withOrdinality);
    }

    public static Object[] array(Object ... args) {
        return args;
    }

    public static <E extends Comparable> Enumerable<FlatLists.ComparableList<E>> product(final List<Enumerator<List<E>>> enumerators, final int fieldCount, final boolean withOrdinality) {
        return new AbstractEnumerable<FlatLists.ComparableList<E>>(){

            public Enumerator<FlatLists.ComparableList<E>> enumerator() {
                return new ProductComparableListEnumerator(enumerators, fieldCount, withOrdinality);
            }
        };
    }

    public static @Nullable Object structAccess(@Nullable Object structObject, int index, @Nullable String fieldName) {
        if (structObject == null) {
            return null;
        }
        if (structObject instanceof Object[]) {
            return ((Object[])structObject)[index];
        }
        if (structObject instanceof List) {
            return ((List)structObject).get(index);
        }
        if (structObject instanceof Row) {
            return ((Row)structObject).getObject(index);
        }
        Class<?> beanClass = structObject.getClass();
        try {
            if (fieldName == null) {
                throw new IllegalStateException("Field name cannot be null for struct field access");
            }
            Field structField = beanClass.getDeclaredField(fieldName);
            return structField.get(structObject);
        }
        catch (IllegalAccessException | NoSuchFieldException ex) {
            throw Static.RESOURCE.failedToAccessField(fieldName, index, beanClass.getName()).ex(ex);
        }
    }

    public static enum FlatProductInputType {
        SCALAR,
        LIST,
        MAP;

    }

    private static class ProductComparableListEnumerator<E extends Comparable>
    extends CartesianProductEnumerator<List<E>, FlatLists.ComparableList<E>> {
        final Object[] flatElements;
        final List<Object> list;
        private final boolean withOrdinality;
        private int ordinality;

        ProductComparableListEnumerator(List<Enumerator<List<E>>> enumerators, int fieldCount, boolean withOrdinality) {
            super(enumerators);
            this.withOrdinality = withOrdinality;
            this.flatElements = new Object[fieldCount];
            this.list = Arrays.asList(this.flatElements);
        }

        public boolean moveNext() {
            boolean hasNext = super.moveNext();
            if (hasNext && this.withOrdinality) {
                ++this.ordinality;
            }
            return hasNext;
        }

        public FlatLists.ComparableList<E> current() {
            int i = 0;
            for (Object element : this.elements) {
                Object[] a;
                if (element.getClass().isArray()) {
                    a = (Object[])element;
                } else {
                    List list2 = (List)element;
                    a = list2.toArray();
                }
                System.arraycopy(a, 0, this.flatElements, i, a.length);
                i += a.length;
            }
            if (this.withOrdinality) {
                this.flatElements[i] = this.ordinality;
            }
            return (FlatLists.ComparableList)FlatLists.of(this.list);
        }

        public void reset() {
            super.reset();
            if (this.withOrdinality) {
                this.ordinality = 0;
            }
        }
    }
}

