/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn.jdbc.queries;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.hadoop.hive.metastore.DatabaseProduct;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.txn.jdbc.QueryHandler;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class TxnIdForWriteIdHandler
implements QueryHandler<Long> {
    private final long writeId;
    private final String dbName;
    private final String tableName;

    public TxnIdForWriteIdHandler(long writeId, String dbName, String tableName) {
        this.writeId = writeId;
        this.dbName = dbName;
        this.tableName = tableName;
    }

    @Override
    public String getParameterizedQueryString(DatabaseProduct databaseProduct) throws MetaException {
        return "SELECT \"T2W_TXNID\" FROM \"TXN_TO_WRITE_ID\" WHERE \"T2W_DATABASE\" = ? AND \"T2W_TABLE\" = ? AND \"T2W_WRITEID\" = " + this.writeId;
    }

    @Override
    public SqlParameterSource getQueryParameters() {
        return new MapSqlParameterSource().addValue("writeId", (Object)this.writeId).addValue("dbName", (Object)this.dbName).addValue("tableName", (Object)this.tableName);
    }

    public Long extractData(ResultSet rs) throws SQLException, DataAccessException {
        long txnId = -1L;
        if (rs.next()) {
            txnId = rs.getLong(1);
        }
        return txnId;
    }
}

