/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.model;

import java.util.BitSet;
import javax.jdo.JDODetachedFieldAccessException;
import org.apache.hadoop.hive.metastore.api.AddPackageRequest;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Package;
import org.apache.hadoop.hive.metastore.model.MDatabase;
import org.datanucleus.enhancement.Detachable;
import org.datanucleus.enhancement.ExecutionContextReference;
import org.datanucleus.enhancement.Persistable;
import org.datanucleus.enhancement.StateManager;
import org.datanucleus.enhancer.EnhancementHelper;

public class MPackage
implements Detachable,
Persistable {
    private String name;
    private MDatabase database;
    private String owner;
    private String header;
    private String body;
    private int createTime = (int)(System.currentTimeMillis() / 1000L);
    public static final int MAX_HEADER_SIZE = 0x3FFFFFFF;
    public static final int MAX_BODY_SIZE = 0x3FFFFFFF;
    protected transient StateManager dnStateManager;
    protected transient byte dnFlags;
    protected Object[] dnDetachedState;
    private static final String[] dnFieldNames = MPackage.__dnFieldNamesInit();
    private static final int dnInheritedFieldCount = MPackage.__dnGetInheritedFieldCount();

    public static MPackage populate(MPackage result, MDatabase mDatabase, AddPackageRequest pkg) throws MetaException {
        result.setName(pkg.getPackageName());
        result.setOwner(pkg.getOwnerName());
        result.setHeader(pkg.getHeader());
        result.setBody(pkg.getBody());
        result.setDatabase(mDatabase);
        return result;
    }

    public String getName() {
        return MPackage.dnGetname(this);
    }

    public void setName(String name) {
        MPackage.dnSetname(this, name);
    }

    public MDatabase getDatabase() {
        return MPackage.dnGetdatabase(this);
    }

    public void setDatabase(MDatabase database) {
        MPackage.dnSetdatabase(this, database);
    }

    public String getOwner() {
        return MPackage.dnGetowner(this);
    }

    public void setOwner(String owner) {
        MPackage.dnSetowner(this, owner);
    }

    public String getHeader() {
        return MPackage.dnGetheader(this);
    }

    public void setHeader(String header) throws MetaException {
        if (header.length() > 0x3FFFFFFF) {
            throw new MetaException("Header is too long: " + header.length() + " max size: 1073741823");
        }
        MPackage.dnSetheader(this, header);
    }

    public String getBody() {
        return MPackage.dnGetbody(this);
    }

    public void setBody(String body) throws MetaException {
        if (body.length() > 0x3FFFFFFF) {
            throw new MetaException("Source code is too long: " + body.length() + " max size: 1073741823");
        }
        MPackage.dnSetbody(this, body);
    }

    public Package toPackage() {
        return new Package(this.getDatabase().getCatalogName(), this.getDatabase().getName(), this.getName(), this.getOwner(), this.getHeader(), this.getBody());
    }

    static {
        EnhancementHelper.registerClass((Class)MPackage.___dn$loadClass("org.apache.hadoop.hive.metastore.model.MPackage"), (Persistable)new MPackage());
    }

    public void dnCopyKeyFieldsFromObjectId(Persistable.ObjectIdFieldConsumer fc, Object oid) {
    }

    protected void dnCopyKeyFieldsFromObjectId(Object oid) {
    }

    public void dnCopyKeyFieldsToObjectId(Object oid) {
    }

    public void dnCopyKeyFieldsToObjectId(Persistable.ObjectIdFieldSupplier fs, Object oid) {
    }

    public final Object dnGetObjectId() {
        if (this.dnStateManager != null) {
            return this.dnStateManager.getObjectId((Persistable)this);
        }
        if (!this.dnIsDetached()) {
            return null;
        }
        return this.dnDetachedState[0];
    }

    public final Object dnGetVersion() {
        if (this.dnStateManager != null) {
            return this.dnStateManager.getVersion((Persistable)this);
        }
        if (!this.dnIsDetached()) {
            return null;
        }
        return this.dnDetachedState[1];
    }

    protected final void dnPreSerialize() {
        if (this.dnStateManager != null) {
            this.dnStateManager.preSerialize((Persistable)this);
        }
    }

    public final ExecutionContextReference dnGetExecutionContext() {
        return this.dnStateManager != null ? this.dnStateManager.getExecutionContextReference() : null;
    }

    public final StateManager dnGetStateManager() {
        return this.dnStateManager;
    }

    public final Object dnGetTransactionalObjectId() {
        return this.dnStateManager != null ? this.dnStateManager.getTransactionalObjectId((Persistable)this) : null;
    }

    public final boolean dnIsDeleted() {
        return this.dnStateManager != null ? this.dnStateManager.isDeleted((Persistable)this) : false;
    }

    public final boolean dnIsDirty() {
        if (this.dnStateManager != null) {
            return this.dnStateManager.isDirty((Persistable)this);
        }
        if (!this.dnIsDetached()) {
            return false;
        }
        return ((BitSet)this.dnDetachedState[3]).length() > 0;
    }

    public final boolean dnIsNew() {
        return this.dnStateManager != null ? this.dnStateManager.isNew((Persistable)this) : false;
    }

    public final boolean dnIsPersistent() {
        return this.dnStateManager != null ? this.dnStateManager.isPersistent((Persistable)this) : false;
    }

    public final boolean dnIsTransactional() {
        return this.dnStateManager != null ? this.dnStateManager.isTransactional((Persistable)this) : false;
    }

    public void dnMakeDirty(String fieldName) {
        if (this.dnStateManager != null) {
            this.dnStateManager.makeDirty((Persistable)this, fieldName);
        }
        if (this.dnIsDetached() && fieldName != null) {
            String fldName = null;
            fldName = fieldName.indexOf(46) >= 0 ? fieldName.substring(fieldName.lastIndexOf(46) + 1) : fieldName;
            int i = 0;
            while (i < dnFieldNames.length) {
                if (dnFieldNames[i].equals(fldName)) {
                    if (((BitSet)this.dnDetachedState[2]).get(i + dnInheritedFieldCount)) {
                        ((BitSet)this.dnDetachedState[3]).set(i + dnInheritedFieldCount);
                        return;
                    }
                    throw new JDODetachedFieldAccessException("You have just attempted to access a field/property that hasn't been detached. Please detach it first before performing this operation");
                }
                ++i;
            }
        }
    }

    public Object dnNewObjectIdInstance() {
        return null;
    }

    public Object dnNewObjectIdInstance(Object key) {
        return null;
    }

    public final void dnProvideFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argment is null");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.dnProvideField(indices[i]);
            } while (--i >= 0);
        }
    }

    public final void dnReplaceFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argument is null");
        }
        int i = indices.length;
        if (i > 0) {
            int j = 0;
            do {
                this.dnReplaceField(indices[j]);
            } while (++j < i);
        }
    }

    public final void dnReplaceFlags() {
        if (this.dnStateManager != null) {
            this.dnFlags = this.dnStateManager.replacingFlags((Persistable)this);
        }
    }

    public final synchronized void dnReplaceStateManager(StateManager sm) {
        if (this.dnStateManager != null) {
            this.dnStateManager = this.dnStateManager.replacingStateManager((Persistable)this, sm);
        } else {
            this.dnStateManager = sm;
            this.dnFlags = 1;
        }
    }

    public final synchronized void dnReplaceDetachedState() {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        this.dnDetachedState = this.dnStateManager.replacingDetachedState((Detachable)this, this.dnDetachedState);
    }

    public boolean dnIsDetached() {
        return this.dnStateManager == null && this.dnDetachedState != null;
    }

    public Persistable dnNewInstance(StateManager sm) {
        MPackage result = new MPackage();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        return result;
    }

    public Persistable dnNewInstance(StateManager sm, Object obj) {
        MPackage result = new MPackage();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        result.dnCopyKeyFieldsFromObjectId(obj);
        return result;
    }

    public void dnReplaceField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.body = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 1: {
                this.createTime = this.dnStateManager.replacingIntField((Persistable)this, index);
                break;
            }
            case 2: {
                this.database = (MDatabase)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 3: {
                this.header = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 4: {
                this.name = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 5: {
                this.owner = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void dnProvideField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.body);
                break;
            }
            case 1: {
                this.dnStateManager.providedIntField((Persistable)this, index, this.createTime);
                break;
            }
            case 2: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.database);
                break;
            }
            case 3: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.header);
                break;
            }
            case 4: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.name);
                break;
            }
            case 5: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.owner);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    protected final void dnCopyField(MPackage obj, int index) {
        switch (index) {
            case 0: {
                this.body = obj.body;
                break;
            }
            case 1: {
                this.createTime = obj.createTime;
                break;
            }
            case 2: {
                this.database = obj.database;
                break;
            }
            case 3: {
                this.header = obj.header;
                break;
            }
            case 4: {
                this.name = obj.name;
                break;
            }
            case 5: {
                this.owner = obj.owner;
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void dnCopyFields(Object obj, int[] indices) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        if (indices == null) {
            throw new IllegalStateException("fieldNumbers is null");
        }
        if (!(obj instanceof MPackage)) {
            throw new IllegalArgumentException("object is not an object of type org.apache.hadoop.hive.metastore.model.MPackage");
        }
        MPackage other = (MPackage)obj;
        if (this.dnStateManager != other.dnStateManager) {
            throw new IllegalArgumentException("state managers do not match");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.dnCopyField(other, indices[i]);
            } while (--i >= 0);
        }
    }

    private static final String[] __dnFieldNamesInit() {
        return new String[]{"body", "createTime", "database", "header", "name", "owner"};
    }

    protected static int __dnGetInheritedFieldCount() {
        return 0;
    }

    protected static int dnGetManagedFieldCount() {
        return 6;
    }

    public static Class ___dn$loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    private static String dnGetbody(MPackage objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 0)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 0, objPC.body);
        }
        if (objPC.dnIsDetached() && !((BitSet)objPC.dnDetachedState[2]).get(0)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"body\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.body;
    }

    private static void dnSetbody(MPackage objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 0, objPC.body, val);
        } else {
            objPC.body = val;
            if (objPC.dnIsDetached()) {
                ((BitSet)objPC.dnDetachedState[3]).set(0);
            }
        }
    }

    private static int dnGetcreateTime(MPackage objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 1)) {
            return objPC.dnStateManager.getIntField((Persistable)objPC, 1, objPC.createTime);
        }
        if (objPC.dnIsDetached() && !((BitSet)objPC.dnDetachedState[2]).get(1)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"createTime\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.createTime;
    }

    private static void dnSetcreateTime(MPackage objPC, int val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setIntField((Persistable)objPC, 1, objPC.createTime, val);
        } else {
            objPC.createTime = val;
            if (objPC.dnIsDetached()) {
                ((BitSet)objPC.dnDetachedState[3]).set(1);
            }
        }
    }

    private static MDatabase dnGetdatabase(MPackage objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 2)) {
            return (MDatabase)objPC.dnStateManager.getObjectField((Persistable)objPC, 2, (Object)objPC.database);
        }
        if (objPC.dnIsDetached() && !((BitSet)objPC.dnDetachedState[2]).get(2) && !((BitSet)objPC.dnDetachedState[3]).get(2)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"database\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.database;
    }

    private static void dnSetdatabase(MPackage objPC, MDatabase val) {
        if (objPC.dnStateManager == null) {
            objPC.database = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 2, (Object)objPC.database, (Object)val);
        }
        if (objPC.dnIsDetached()) {
            ((BitSet)objPC.dnDetachedState[3]).set(2);
        }
    }

    private static String dnGetheader(MPackage objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 3)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 3, objPC.header);
        }
        if (objPC.dnIsDetached() && !((BitSet)objPC.dnDetachedState[2]).get(3)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"header\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.header;
    }

    private static void dnSetheader(MPackage objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 3, objPC.header, val);
        } else {
            objPC.header = val;
            if (objPC.dnIsDetached()) {
                ((BitSet)objPC.dnDetachedState[3]).set(3);
            }
        }
    }

    private static String dnGetname(MPackage objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 4)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 4, objPC.name);
        }
        if (objPC.dnIsDetached() && !((BitSet)objPC.dnDetachedState[2]).get(4)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"name\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.name;
    }

    private static void dnSetname(MPackage objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 4, objPC.name, val);
        } else {
            objPC.name = val;
            if (objPC.dnIsDetached()) {
                ((BitSet)objPC.dnDetachedState[3]).set(4);
            }
        }
    }

    private static String dnGetowner(MPackage objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 5)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 5, objPC.owner);
        }
        if (objPC.dnIsDetached() && !((BitSet)objPC.dnDetachedState[2]).get(5)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"owner\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.owner;
    }

    private static void dnSetowner(MPackage objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 5, objPC.owner, val);
        } else {
            objPC.owner = val;
            if (objPC.dnIsDetached()) {
                ((BitSet)objPC.dnDetachedState[3]).set(5);
            }
        }
    }
}

