/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.dataconnector;

import java.net.ConnectException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.DataConnector;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.dataconnector.IDataConnectorProvider;

public abstract class AbstractDataConnectorProvider
implements IDataConnectorProvider {
    protected String scoped_db = null;
    protected Object handle = null;
    protected DataConnector connector = null;
    protected String driverClassName = null;

    public AbstractDataConnectorProvider(String dbName, DataConnector connector, String driverClassName) {
        this.scoped_db = dbName;
        this.connector = connector;
        this.driverClassName = driverClassName;
    }

    @Override
    public final void setScope(String scoped_db) {
        if (scoped_db != null) {
            this.scoped_db = scoped_db;
        }
    }

    @Override
    public void open() throws ConnectException, MetaException {
    }

    @Override
    public void close() throws ConnectException {
    }

    @Override
    public List<Table> getTables(String regex) throws MetaException {
        return null;
    }

    @Override
    public List<String> getTableNames() throws MetaException {
        return null;
    }

    @Override
    public Table getTable(String tableName) throws MetaException {
        return null;
    }

    @Override
    public boolean createTable(Table table) throws MetaException {
        throw new MetaException("Creation of table in remote datasource is not supported.");
    }

    @Override
    public boolean dropTable(String tableName) throws MetaException {
        throw new MetaException("Deletion of table in remote datasource is not supported.");
    }

    @Override
    public boolean alterTable(String tableName, Table table) throws MetaException {
        throw new MetaException("Alter table in remote datasource is not supported.");
    }

    protected Table buildTableFromColsList(String tableName, List<FieldSchema> cols) {
        StorageDescriptor sd = new StorageDescriptor();
        sd.setCols(cols);
        SerDeInfo serdeInfo = new SerDeInfo();
        serdeInfo.setName(tableName);
        serdeInfo.setSerializationLib("org.apache.hive.storage.jdbc.JdbcSerDe");
        HashMap<String, String> serdeParams = new HashMap<String, String>();
        serdeParams.put("serialization.format", "1");
        serdeInfo.setParameters(serdeParams);
        sd.setSerdeInfo(serdeInfo);
        sd.setInputFormat(this.getInputClass());
        sd.setOutputFormat(this.getOutputClass());
        sd.setLocation(this.getTableLocation(tableName));
        sd.setBucketCols(new ArrayList());
        sd.setSortCols(new ArrayList());
        Table table = new Table();
        table.setTableName(tableName);
        table.setTableType(TableType.EXTERNAL_TABLE.toString());
        table.setSd(sd);
        table.setParameters(new HashMap());
        table.setPartitionKeys(new ArrayList());
        return table;
    }

    protected abstract String getInputClass();

    protected abstract String getOutputClass();

    protected abstract String getTableLocation(String var1);

    protected abstract String getDatasourceType();
}

