/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.cpc;

import java.util.Arrays;
import org.apache.datasketches.cpc.CpcSketch;
import org.apache.datasketches.hive.cpc.ObjectInspectorValidator;
import org.apache.datasketches.hive.cpc.SketchEvaluator;
import org.apache.datasketches.hive.cpc.UnionState;
import org.apache.datasketches.memory.Memory;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.udf.generic.AbstractGenericUDAFResolver;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFParameterInfo;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;

@Description(name="unionSketch", value="_FUNC_(sketch, lgK, seed) - Compute the union of sketches of given size and seed", extended="Example:\n> SELECT UnionSketch(sketch) FROM src;\nThe return value is a binary blob that can be operated on by other sketch related functions. The lgK parameter controls the sketch size and relative error expected from the sketch. It is optional an must be from 4 to 26. The default is 11, which is expected to yield errors of roughly +-1.5% in the estimation of uniques with 95% confidence. The seed parameter is optional")
public class UnionSketchUDAF
extends AbstractGenericUDAFResolver {
    public GenericUDAFEvaluator getEvaluator(GenericUDAFParameterInfo info) throws SemanticException {
        ObjectInspector[] inspectors = info.getParameterObjectInspectors();
        if (inspectors.length < 1) {
            throw new UDFArgumentException("Please specify at least 1 argument");
        }
        if (inspectors.length > 3) {
            throw new UDFArgumentTypeException(inspectors.length - 1, "Please specify no more than 3 arguments");
        }
        ObjectInspectorValidator.validateGivenPrimitiveCategory(inspectors[0], 0, PrimitiveObjectInspector.PrimitiveCategory.BINARY);
        if (inspectors.length > 1) {
            ObjectInspectorValidator.validateIntegralParameter(inspectors[1], 1);
            if (!ObjectInspectorUtils.isConstantObjectInspector((ObjectInspector)inspectors[1])) {
                throw new UDFArgumentTypeException(1, "The second argument must be a constant");
            }
        }
        if (inspectors.length > 2) {
            ObjectInspectorValidator.validateIntegralParameter(inspectors[2], 2);
            if (!ObjectInspectorUtils.isConstantObjectInspector((ObjectInspector)inspectors[2])) {
                throw new UDFArgumentTypeException(2, "The third argument must be a constant");
            }
        }
        return new UnionSketchUDAFEvaluator();
    }

    public static class UnionSketchUDAFEvaluator
    extends SketchEvaluator {
        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            return new UnionState();
        }

        public ObjectInspector init(GenericUDAFEvaluator.Mode mode, ObjectInspector[] parameters) throws HiveException {
            super.init(mode, parameters);
            if (mode == GenericUDAFEvaluator.Mode.PARTIAL1 || mode == GenericUDAFEvaluator.Mode.COMPLETE) {
                this.inputInspector_ = (PrimitiveObjectInspector)parameters[0];
                if (parameters.length > 1) {
                    this.lgKInspector_ = (PrimitiveObjectInspector)parameters[1];
                }
                if (parameters.length > 2) {
                    this.seedInspector_ = (PrimitiveObjectInspector)parameters[2];
                }
            } else {
                this.intermediateInspector_ = (StandardStructObjectInspector)parameters[0];
            }
            if (mode == GenericUDAFEvaluator.Mode.PARTIAL1 || mode == GenericUDAFEvaluator.Mode.PARTIAL2) {
                return ObjectInspectorFactory.getStandardStructObjectInspector(Arrays.asList("lgK", "seed", "sketch"), Arrays.asList(PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.INT), PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.LONG), PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.BINARY)));
            }
            return PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.BINARY);
        }

        public void iterate(GenericUDAFEvaluator.AggregationBuffer buf, Object[] parameters) throws HiveException {
            byte[] serializedSketch;
            if (parameters[0] == null) {
                return;
            }
            UnionState state = (UnionState)buf;
            if (!state.isInitialized()) {
                this.initializeState(state, parameters);
            }
            if ((serializedSketch = (byte[])this.inputInspector_.getPrimitiveJavaObject(parameters[0])) == null) {
                return;
            }
            state.update(CpcSketch.heapify((Memory)Memory.wrap((byte[])serializedSketch), (long)state.getSeed()));
        }

        private void initializeState(UnionState state, Object[] parameters) {
            int lgK = 11;
            if (this.lgKInspector_ != null) {
                lgK = PrimitiveObjectInspectorUtils.getInt((Object)parameters[1], (PrimitiveObjectInspector)this.lgKInspector_);
            }
            long seed = 9001L;
            if (this.seedInspector_ != null) {
                seed = PrimitiveObjectInspectorUtils.getLong((Object)parameters[2], (PrimitiveObjectInspector)this.seedInspector_);
            }
            state.init(lgK, seed);
        }
    }
}

