/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jdo.annotations;

import java.util.Map;
import javax.jdo.annotations.Column;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.api.jdo.metadata.JDOAnnotationUtils;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.MultitenancyMetaData;
import org.datanucleus.metadata.annotations.AnnotationObject;
import org.datanucleus.metadata.annotations.ClassAnnotationHandler;
import org.datanucleus.util.StringUtils;

public class MultiTenantHandler
implements ClassAnnotationHandler {
    public void processClassAnnotation(AnnotationObject annotation, AbstractClassMetaData cmd, ClassLoaderResolver clr) {
        MultitenancyMetaData mtmd = cmd.newMultitenancyMetaData();
        Map annotationValues = annotation.getNameValueMap();
        String columnName = (String)annotationValues.get("column");
        Column[] columns = (Column[])annotationValues.get("columns");
        if (columns != null && columns.length > 0) {
            ColumnMetaData colmd = JDOAnnotationUtils.getColumnMetaDataForColumnAnnotation(columns[0]);
            if (StringUtils.isWhitespace((String)colmd.getName())) {
                colmd.setName(columnName);
            }
            mtmd.setColumnMetaData(colmd);
        } else {
            mtmd.setColumnName(columnName);
        }
        String indexed = (String)annotationValues.get("indexed");
        if (!StringUtils.isWhitespace((String)indexed)) {
            mtmd.setIndexed(Boolean.parseBoolean(indexed));
        }
    }
}

