/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.teradata;

import com.google.common.collect.ImmutableMap;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeSpec;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveCharWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.HiveVarcharWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritableV2;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BinaryObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ByteObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DateObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveCharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveDecimalObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveVarcharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.LongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ShortObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.TimestampObjectInspector;
import org.apache.hadoop.hive.serde2.teradata.TeradataBinaryDataInputStream;
import org.apache.hadoop.hive.serde2.teradata.TeradataBinaryDataOutputStream;
import org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeInfo;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SerDeSpec(schemaProps={"columns", "columns.types"})
public class TeradataBinarySerde
extends AbstractSerDe {
    private static final Logger LOG = LoggerFactory.getLogger(TeradataBinarySerde.class);
    public static final String TD_SCHEMA_LITERAL = "teradata.schema.literal";
    private StructObjectInspector rowOI;
    private ArrayList<Object> row;
    private byte[] inForNull;
    private int numCols;
    private List<String> columnNames;
    private List<TypeInfo> columnTypes;
    private TeradataBinaryDataOutputStream out;
    private BytesWritable serializeBytesWritable;
    private byte[] outForNull;
    public static final String TD_TIMESTAMP_PRECISION = "teradata.timestamp.precision";
    private int timestampPrecision;
    private static final int DEFAULT_TIMESTAMP_BYTE_NUM = 19;
    private static final String DEFAULT_TIMESTAMP_PRECISION = "6";
    public static final String TD_CHAR_SET = "teradata.char.charset";
    private String charCharset;
    private static final String DEFAULT_CHAR_CHARSET = "UNICODE";
    private static final Map<String, Integer> CHARSET_TO_BYTE_NUM = ImmutableMap.of((Object)"LATIN", (Object)2, (Object)"UNICODE", (Object)3);

    @Override
    public void initialize(Configuration configuration, Properties tableProperties, Properties partitionProperties) throws SerDeException {
        int i;
        super.initialize(configuration, tableProperties, partitionProperties);
        this.columnNames = Arrays.asList(this.properties.getProperty("columns").split(","));
        String columnTypeProperty = this.properties.getProperty("columns.types");
        LOG.debug("columns.types: " + columnTypeProperty);
        this.columnTypes = columnTypeProperty.length() == 0 ? new ArrayList<TypeInfo>() : TypeInfoUtils.getTypeInfosFromTypeString(columnTypeProperty);
        assert (this.columnNames.size() == this.columnTypes.size());
        this.numCols = this.columnNames.size();
        this.timestampPrecision = Integer.parseInt(this.properties.getProperty(TD_TIMESTAMP_PRECISION, DEFAULT_TIMESTAMP_PRECISION));
        this.charCharset = this.properties.getProperty(TD_CHAR_SET, DEFAULT_CHAR_CHARSET);
        if (!CHARSET_TO_BYTE_NUM.containsKey(this.charCharset)) {
            throw new SerDeException(String.format("%s isn't supported in Teradata Char Charset %s", this.charCharset, CHARSET_TO_BYTE_NUM.keySet()));
        }
        ArrayList<ObjectInspector> columnOIs = new ArrayList<ObjectInspector>(this.numCols);
        for (i = 0; i < this.numCols; ++i) {
            if (this.columnTypes.get(i).getCategory() != ObjectInspector.Category.PRIMITIVE) {
                throw new SerDeException(this.getClass().getName() + " only accepts primitive columns, but column[" + i + "] named " + this.columnNames.get(i) + " has category " + this.columnTypes.get(i).getCategory());
            }
            columnOIs.add(TypeInfoUtils.getStandardWritableObjectInspectorFromTypeInfo(this.columnTypes.get(i)));
        }
        this.rowOI = ObjectInspectorFactory.getStandardStructObjectInspector(this.columnNames, columnOIs);
        this.row = new ArrayList(this.numCols);
        for (i = 0; i < this.numCols; ++i) {
            this.row.add(null);
        }
        int byteNumForNullArray = this.numCols / 8 + (this.numCols % 8 == 0 ? 0 : 1);
        LOG.debug(String.format("The Null Bytes for each record will have %s bytes", byteNumForNullArray));
        this.inForNull = new byte[byteNumForNullArray];
        this.out = new TeradataBinaryDataOutputStream();
        this.serializeBytesWritable = new BytesWritable();
        this.outForNull = new byte[byteNumForNullArray];
    }

    @Override
    public Class<? extends Writable> getSerializedClass() {
        return ByteWritable.class;
    }

    @Override
    public Writable serialize(Object obj, ObjectInspector objInspector) throws SerDeException {
        try {
            Object objectForField;
            int i;
            this.out.reset();
            StructObjectInspector outputRowOI = (StructObjectInspector)objInspector;
            List<? extends StructField> fieldRefs = outputRowOI.getAllStructFieldRefs();
            if (fieldRefs.size() != this.numCols) {
                throw new SerDeException("Cannot serialize the object because there are " + fieldRefs.size() + " fieldRefs but the table defined " + this.numCols + " columns.");
            }
            for (i = 0; i < this.numCols; ++i) {
                objectForField = outputRowOI.getStructFieldData(obj, fieldRefs.get(i));
                this.outForNull[i / 8] = objectForField == null ? (byte)(this.outForNull[i / 8] | 1 << 7 - i % 8) : (byte)(this.outForNull[i / 8] & ~(1 << 7 - i % 8));
            }
            this.out.write(this.outForNull);
            for (i = 0; i < this.numCols; ++i) {
                objectForField = outputRowOI.getStructFieldData(obj, fieldRefs.get(i));
                this.serializeField(objectForField, fieldRefs.get(i).getFieldObjectInspector(), this.columnTypes.get(i));
            }
            this.serializeBytesWritable.set(this.out.toByteArray(), 0, this.out.size());
            return this.serializeBytesWritable;
        }
        catch (IOException e) {
            throw new SerDeException(e);
        }
    }

    private void serializeField(Object objectForField, ObjectInspector oi, TypeInfo ti) throws IOException, SerDeException {
        switch (oi.getCategory()) {
            case PRIMITIVE: {
                PrimitiveObjectInspector poi = (PrimitiveObjectInspector)oi;
                switch (poi.getPrimitiveCategory()) {
                    case BYTE: {
                        ByteObjectInspector boi = (ByteObjectInspector)poi;
                        byte b = 0;
                        if (objectForField != null) {
                            b = boi.get(objectForField);
                        }
                        this.out.write(b);
                        return;
                    }
                    case SHORT: {
                        ShortObjectInspector spoi = (ShortObjectInspector)poi;
                        short s = 0;
                        if (objectForField != null) {
                            s = spoi.get(objectForField);
                        }
                        this.out.writeShort(s);
                        return;
                    }
                    case INT: {
                        IntObjectInspector ioi = (IntObjectInspector)poi;
                        int i = 0;
                        if (objectForField != null) {
                            i = ioi.get(objectForField);
                        }
                        this.out.writeInt(i);
                        return;
                    }
                    case LONG: {
                        LongObjectInspector loi = (LongObjectInspector)poi;
                        long l = 0L;
                        if (objectForField != null) {
                            l = loi.get(objectForField);
                        }
                        this.out.writeLong(l);
                        return;
                    }
                    case DOUBLE: {
                        DoubleObjectInspector doi = (DoubleObjectInspector)poi;
                        double d = 0.0;
                        if (objectForField != null) {
                            d = doi.get(objectForField);
                        }
                        this.out.writeDouble(d);
                        return;
                    }
                    case VARCHAR: {
                        HiveVarcharObjectInspector hvoi = (HiveVarcharObjectInspector)poi;
                        HiveVarcharWritable hv = hvoi.getPrimitiveWritableObject(objectForField);
                        if (hv != null) assert (((VarcharTypeInfo)ti).getLength() >= hv.getHiveVarchar().getCharacterLength());
                        this.out.writeVarChar(hv);
                        return;
                    }
                    case TIMESTAMP: {
                        TimestampObjectInspector tsoi = (TimestampObjectInspector)poi;
                        TimestampWritableV2 ts = tsoi.getPrimitiveWritableObject(objectForField);
                        this.out.writeTimestamp(ts, this.getTimeStampByteNum(this.timestampPrecision));
                        return;
                    }
                    case DATE: {
                        DateObjectInspector dtoi = (DateObjectInspector)poi;
                        DateWritableV2 dw = dtoi.getPrimitiveWritableObject(objectForField);
                        this.out.writeDate(dw);
                        return;
                    }
                    case CHAR: {
                        HiveCharObjectInspector coi = (HiveCharObjectInspector)poi;
                        HiveCharWritable hc = coi.getPrimitiveWritableObject(objectForField);
                        if (hc != null) assert (((CharTypeInfo)ti).getLength() >= hc.getHiveChar().getCharacterLength());
                        this.out.writeChar(hc, this.getCharByteNum(this.charCharset) * ((CharTypeInfo)ti).getLength());
                        return;
                    }
                    case DECIMAL: {
                        DecimalTypeInfo dtype = (DecimalTypeInfo)ti;
                        int precision = dtype.precision();
                        int scale = dtype.scale();
                        HiveDecimalObjectInspector hdoi = (HiveDecimalObjectInspector)poi;
                        HiveDecimalWritable hd = hdoi.getPrimitiveWritableObject(objectForField);
                        if (hd != null) assert (dtype.getPrecision() >= hd.precision());
                        this.out.writeDecimal(hd, this.getDecimalByteNum(precision), scale);
                        return;
                    }
                    case BINARY: {
                        BinaryObjectInspector bnoi = (BinaryObjectInspector)poi;
                        BytesWritable byw = bnoi.getPrimitiveWritableObject(objectForField);
                        this.out.writeVarByte(byw);
                        return;
                    }
                }
                throw new SerDeException("Unrecognized type: " + poi.getPrimitiveCategory());
            }
        }
        throw new SerDeException("Unrecognized type: " + oi.getCategory());
    }

    @Override
    public Object deserialize(Writable blob) throws SerDeException {
        try {
            BytesWritable data = (BytesWritable)blob;
            TeradataBinaryDataInputStream in = new TeradataBinaryDataInputStream(new ByteArrayInputStream(data.getBytes(), 0, data.getLength()));
            int numOfByteRead = in.read(this.inForNull);
            if (this.inForNull.length != 0 && numOfByteRead != this.inForNull.length) {
                throw new EOFException("not enough bytes for one object");
            }
            for (int i = 0; i < this.numCols; ++i) {
                boolean isNull = (this.inForNull[i / 8] & 128 >> i % 8) != 0;
                this.row.set(i, this.deserializeField(in, this.columnTypes.get(i), this.row.get(i), isNull));
            }
            if (in.read() != -1) {
                throw new EOFException("The inputstream has more after we deserialize all the fields - this is unexpected");
            }
        }
        catch (EOFException e) {
            LOG.warn("Catch thrown exception", (Throwable)e);
            LOG.warn("This record has been polluted. We have reset all the row fields to be null");
            for (int i = 0; i < this.numCols; ++i) {
                this.row.set(i, null);
            }
        }
        catch (IOException e) {
            throw new SerDeException(e);
        }
        catch (ParseException e) {
            throw new SerDeException(e);
        }
        return this.row;
    }

    private Object deserializeField(TeradataBinaryDataInputStream in, TypeInfo type, Object reuse, boolean isNull) throws IOException, ParseException, SerDeException {
        switch (type.getCategory()) {
            case PRIMITIVE: {
                PrimitiveTypeInfo ptype = (PrimitiveTypeInfo)type;
                switch (ptype.getPrimitiveCategory()) {
                    case VARCHAR: {
                        String st = in.readVarchar();
                        if (isNull) {
                            return null;
                        }
                        HiveVarcharWritable r = reuse == null ? new HiveVarcharWritable() : (HiveVarcharWritable)reuse;
                        r.set(st, ((VarcharTypeInfo)type).getLength());
                        return r;
                    }
                    case INT: {
                        int i = in.readInt();
                        if (isNull) {
                            return null;
                        }
                        IntWritable r = reuse == null ? new IntWritable() : (IntWritable)reuse;
                        r.set(i);
                        return r;
                    }
                    case TIMESTAMP: {
                        Timestamp ts = in.readTimestamp(this.getTimeStampByteNum(this.timestampPrecision));
                        if (isNull) {
                            return null;
                        }
                        TimestampWritableV2 r = reuse == null ? new TimestampWritableV2() : (TimestampWritableV2)reuse;
                        r.set(ts);
                        return r;
                    }
                    case DOUBLE: {
                        double d = in.readDouble();
                        if (isNull) {
                            return null;
                        }
                        DoubleWritable r = reuse == null ? new DoubleWritable() : (DoubleWritable)((Object)reuse);
                        r.set(d);
                        return r;
                    }
                    case DATE: {
                        Date dt = in.readDate();
                        if (isNull) {
                            return null;
                        }
                        DateWritableV2 r = reuse == null ? new DateWritableV2() : (DateWritableV2)reuse;
                        r.set(dt);
                        return r;
                    }
                    case BYTE: {
                        byte bt = in.readByte();
                        if (isNull) {
                            return null;
                        }
                        ByteWritable r = reuse == null ? new ByteWritable() : (ByteWritable)((Object)reuse);
                        r.set(bt);
                        return r;
                    }
                    case LONG: {
                        long l = in.readLong();
                        if (isNull) {
                            return null;
                        }
                        LongWritable r = reuse == null ? new LongWritable() : (LongWritable)reuse;
                        r.set(l);
                        return r;
                    }
                    case CHAR: {
                        CharTypeInfo ctype = (CharTypeInfo)type;
                        int length = ctype.getLength();
                        String c = in.readChar(length * this.getCharByteNum(this.charCharset));
                        if (isNull) {
                            return null;
                        }
                        HiveCharWritable r = reuse == null ? new HiveCharWritable() : (HiveCharWritable)reuse;
                        r.set(c, length);
                        return r;
                    }
                    case DECIMAL: {
                        DecimalTypeInfo dtype = (DecimalTypeInfo)type;
                        int precision = dtype.precision();
                        int scale = dtype.scale();
                        HiveDecimal hd = in.readDecimal(scale, this.getDecimalByteNum(precision));
                        if (isNull) {
                            return null;
                        }
                        HiveDecimalWritable r = reuse == null ? new HiveDecimalWritable() : (HiveDecimalWritable)reuse;
                        r.set(hd);
                        return r;
                    }
                    case SHORT: {
                        short s = in.readShort();
                        if (isNull) {
                            return null;
                        }
                        ShortWritable r = reuse == null ? new ShortWritable() : (ShortWritable)reuse;
                        r.set(s);
                        return r;
                    }
                    case BINARY: {
                        byte[] content = in.readVarbyte();
                        if (isNull) {
                            return null;
                        }
                        BytesWritable r = new BytesWritable();
                        r.set(content, 0, content.length);
                        return r;
                    }
                }
                throw new SerDeException("Unrecognized type: " + ptype.getPrimitiveCategory());
            }
        }
        throw new SerDeException("Unsupported category: " + type.getCategory());
    }

    @Override
    public ObjectInspector getObjectInspector() throws SerDeException {
        return this.rowOI;
    }

    private int getTimeStampByteNum(int precision) {
        if (precision == 0) {
            return 19;
        }
        return precision + 1 + 19;
    }

    private int getCharByteNum(String charset) throws SerDeException {
        if (!CHARSET_TO_BYTE_NUM.containsKey(this.charCharset)) {
            throw new SerDeException(String.format("%s isn't supported in Teradata Char Charset %s", this.charCharset, CHARSET_TO_BYTE_NUM.keySet()));
        }
        return CHARSET_TO_BYTE_NUM.get(charset);
    }

    private int getDecimalByteNum(int precision) throws SerDeException {
        if (precision <= 0) {
            throw new SerDeException(String.format("the precision of Decimal should be bigger than 0. %d is illegal", precision));
        }
        if (precision <= 2) {
            return 1;
        }
        if (precision <= 4) {
            return 2;
        }
        if (precision <= 9) {
            return 4;
        }
        if (precision <= 18) {
            return 8;
        }
        if (precision <= 38) {
            return 16;
        }
        throw new IllegalArgumentException(String.format("the precision of Decimal should be smaller than 39. %d is illegal", precision));
    }
}

