/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping.java;

import java.util.Collection;
import java.util.Iterator;
import org.datanucleus.ExecutionContext;
import org.datanucleus.PersistableObjectType;
import org.datanucleus.PropertyNames;
import org.datanucleus.exceptions.ReachableObjectNotCascadedException;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.store.rdbms.mapping.MappingCallbacks;
import org.datanucleus.store.rdbms.mapping.java.AbstractContainerMapping;
import org.datanucleus.store.types.SCO;
import org.datanucleus.store.types.SCOUtils;
import org.datanucleus.store.types.scostore.CollectionStore;
import org.datanucleus.store.types.wrappers.backed.BackedSCO;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class CollectionMapping
extends AbstractContainerMapping
implements MappingCallbacks {
    @Override
    public Class getJavaType() {
        return Collection.class;
    }

    @Override
    public void postInsert(DNStateManager ownerSM) {
        ExecutionContext ec = ownerSM.getExecutionContext();
        Collection value = (Collection)ownerSM.provideField(this.getAbsoluteFieldNumber());
        if (this.containerIsStoredInSingleColumn()) {
            if (value != null && this.mmd.getCollection().elementIsPersistent()) {
                for (Object elem : value) {
                    DNStateManager elemSM;
                    if (elem == null || (elemSM = ec.findStateManager(elem)) != null && ec.getApiAdapter().getExecutionContext(elem) != null) continue;
                    elemSM = ec.getNucleusContext().getStateManagerFactory().newForEmbedded(ec, elem, false, ownerSM, this.mmd.getAbsoluteFieldNumber(), PersistableObjectType.EMBEDDED_COLLECTION_ELEMENT_PC);
                }
            }
            return;
        }
        if (value == null) {
            this.replaceFieldWithWrapper(ownerSM, null);
            return;
        }
        if (value.isEmpty()) {
            if (this.mmd.getRelationType(ec.getClassLoaderResolver()) == RelationType.MANY_TO_MANY_BI) {
                this.replaceFieldWithWrapper(ownerSM, null);
            } else {
                this.replaceFieldWithWrapper(ownerSM, value);
            }
            return;
        }
        if (this.mmd.isCascadePersist()) {
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug((Object)Localiser.msg((String)"007007", (Object[])new Object[]{IdentityUtils.getPersistableIdentityForId((Object)ownerSM.getInternalObjectId()), this.mmd.getFullFieldName()}));
            }
        } else {
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug((Object)Localiser.msg((String)"007006", (Object[])new Object[]{this.mmd.getFullFieldName()}));
            }
            for (Iterator elem : value) {
                if (ec.getApiAdapter().isDetached(elem) || ec.getApiAdapter().isPersistent(elem)) continue;
                throw new ReachableObjectNotCascadedException(this.mmd.getFullFieldName(), elem);
            }
        }
        boolean needsAttaching = false;
        for (Object elem : value) {
            if (!ec.getApiAdapter().isDetached(elem)) continue;
            needsAttaching = true;
            break;
        }
        if (needsAttaching) {
            SCO collWrapper = this.replaceFieldWithWrapper(ownerSM, null);
            if (value.size() > 0) {
                collWrapper.attachCopy((Object)value);
                ec.flushOperationsForBackingStore(((BackedSCO)collWrapper).getBackingStore(), ownerSM);
            }
        } else {
            ((CollectionStore)this.storeMgr.getBackingStoreForField(ec.getClassLoaderResolver(), this.mmd, value.getClass())).addAll(ownerSM, value, 0);
            this.replaceFieldWithWrapper(ownerSM, value);
        }
    }

    @Override
    public void postUpdate(DNStateManager ownerSM) {
        ExecutionContext ec = ownerSM.getExecutionContext();
        Collection value = (Collection)ownerSM.provideField(this.getAbsoluteFieldNumber());
        if (this.containerIsStoredInSingleColumn()) {
            if (value != null && this.mmd.getCollection().elementIsPersistent()) {
                Object[] collElements;
                for (Object collElement : collElements = value.toArray()) {
                    DNStateManager elemSM;
                    if (collElement == null || (elemSM = ec.findStateManager(collElement)) != null && ec.getApiAdapter().getExecutionContext(collElement) != null) continue;
                    elemSM = ec.getNucleusContext().getStateManagerFactory().newForEmbedded(ec, collElement, false, ownerSM, this.mmd.getAbsoluteFieldNumber(), PersistableObjectType.EMBEDDED_COLLECTION_ELEMENT_PC);
                }
            }
            return;
        }
        if (value == null) {
            ((CollectionStore)this.storeMgr.getBackingStoreForField(ec.getClassLoaderResolver(), this.mmd, null)).clear(ownerSM);
            this.replaceFieldWithWrapper(ownerSM, null);
            return;
        }
        if (value instanceof BackedSCO) {
            ec.flushOperationsForBackingStore(((BackedSCO)value).getBackingStore(), ownerSM);
            return;
        }
        if (this.mmd.isCascadePersist()) {
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug((Object)Localiser.msg((String)"007009", (Object[])new Object[]{IdentityUtils.getPersistableIdentityForId((Object)ownerSM.getInternalObjectId()), this.mmd.getFullFieldName()}));
            }
        } else {
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug((Object)Localiser.msg((String)"007008", (Object[])new Object[]{IdentityUtils.getPersistableIdentityForId((Object)ownerSM.getInternalObjectId()), this.mmd.getFullFieldName()}));
            }
            return;
        }
        CollectionStore backingStore = (CollectionStore)this.storeMgr.getBackingStoreForField(ec.getClassLoaderResolver(), this.mmd, value.getClass());
        backingStore.update(ownerSM, value);
        this.replaceFieldWithWrapper(ownerSM, value);
    }

    @Override
    public void preDelete(DNStateManager ownerSM) {
        if (this.containerIsStoredInSingleColumn()) {
            return;
        }
        ownerSM.isLoaded(this.getAbsoluteFieldNumber());
        Collection value = (Collection)ownerSM.provideField(this.getAbsoluteFieldNumber());
        if (value == null) {
            return;
        }
        ExecutionContext ec = ownerSM.getExecutionContext();
        boolean dependent = this.mmd.getCollection().isDependentElement();
        if (this.mmd.isCascadeRemoveOrphans()) {
            dependent = true;
        }
        boolean hasJoin = this.mmd.getJoinMetaData() != null;
        boolean hasFK = false;
        if (!hasJoin) {
            if (this.mmd.getElementMetaData() != null && this.mmd.getElementMetaData().getForeignKeyMetaData() != null) {
                hasFK = true;
            } else if (this.mmd.getForeignKeyMetaData() != null) {
                hasFK = true;
            }
            AbstractMemberMetaData[] relatedMmds = this.mmd.getRelatedMemberMetaData(ec.getClassLoaderResolver());
            if (relatedMmds != null && relatedMmds[0].getForeignKeyMetaData() != null) {
                hasFK = true;
            }
        }
        if (ec.getStringProperty(PropertyNames.PROPERTY_DELETION_POLICY).equals("JDO2")) {
            hasFK = false;
        }
        if (ec.getManageRelations()) {
            ec.getRelationshipManager(ownerSM).relationChange(this.getAbsoluteFieldNumber(), (Object)value, null);
        }
        if (dependent || hasJoin || !hasFK) {
            if (!(value instanceof SCO)) {
                value = (Collection)SCOUtils.wrapSCOField((DNStateManager)ownerSM, (int)this.getAbsoluteFieldNumber(), (Object)value, (boolean)true);
            }
            value.clear();
            ec.flushOperationsForBackingStore(((BackedSCO)value).getBackingStore(), ownerSM);
        }
    }
}

