/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping;

import java.util.HashMap;
import java.util.Map;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.ColumnMetaDataContainer;
import org.datanucleus.store.rdbms.identifier.DatastoreIdentifier;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.mapping.java.MultiMapping;
import org.datanucleus.store.rdbms.table.Table;
import org.datanucleus.util.Localiser;

public class CorrespondentColumnsMapper {
    private final Map<DatastoreIdentifier, ColumnMetaData> columnMetaDataBySideBIdentifier = new HashMap<DatastoreIdentifier, ColumnMetaData>();
    private final String columnsName;

    public CorrespondentColumnsMapper(ColumnMetaDataContainer columnContainer, Table tableA, ColumnMetaData[] colmds, JavaTypeMapping mappingSideB, boolean updateContainer) {
        if (columnContainer != null && colmds != null) {
            int i;
            int noOfUserColumns = colmds.length;
            StringBuilder str = new StringBuilder("Columns [");
            for (int i2 = 0; i2 < noOfUserColumns; ++i2) {
                str.append(colmds[i2].getName());
                if (i2 >= noOfUserColumns - 1) continue;
                str.append(", ");
            }
            str.append("]");
            this.columnsName = str.toString();
            if (noOfUserColumns > mappingSideB.getNumberOfColumnMappings()) {
                throw new NucleusUserException(Localiser.msg((String)"020003", (Object[])new Object[]{this.columnsName, "" + noOfUserColumns, "" + mappingSideB.getNumberOfColumnMappings()})).setFatal();
            }
            DatastoreIdentifier[] sideBidentifiers = new DatastoreIdentifier[mappingSideB.getNumberOfColumnMappings()];
            boolean[] sideButilised = new boolean[mappingSideB.getNumberOfColumnMappings()];
            for (int i3 = 0; i3 < mappingSideB.getNumberOfColumnMappings(); ++i3) {
                sideBidentifiers[i3] = mappingSideB.getColumnMapping(i3).getColumn().getIdentifier();
                sideButilised[i3] = false;
            }
            JavaTypeMapping[] sideBidMappings = ((MultiMapping)mappingSideB).getJavaTypeMapping();
            for (i = 0; i < noOfUserColumns; ++i) {
                int j;
                String targetFieldName;
                String targetColumnName = colmds[i].getTarget();
                if (targetColumnName == null && (targetFieldName = colmds[i].getTargetMember()) != null) {
                    for (j = 0; j < sideBidMappings.length; ++j) {
                        if (!sideBidMappings[j].getMemberMetaData().getName().equals(targetFieldName)) continue;
                        targetColumnName = sideBidMappings[j].getColumnMapping(0).getColumn().getIdentifier().getName();
                        break;
                    }
                }
                if (targetColumnName == null) continue;
                boolean targetExists = false;
                for (j = 0; j < sideBidentifiers.length; ++j) {
                    if (!sideBidentifiers[j].getName().equalsIgnoreCase(targetColumnName) || sideButilised[j]) continue;
                    this.putColumn(sideBidentifiers[j], colmds[i]);
                    sideButilised[j] = true;
                    targetExists = true;
                    break;
                }
                if (targetExists) continue;
                throw new NucleusUserException(Localiser.msg((String)"020004", (Object[])new Object[]{tableA, colmds[i].getName(), targetColumnName, mappingSideB.getTable(), mappingSideB})).setFatal();
            }
            block5: for (i = 0; i < colmds.length; ++i) {
                if (colmds[i].getTarget() != null) continue;
                for (int j = 0; j < sideBidentifiers.length; ++j) {
                    if (sideButilised[j]) continue;
                    this.putColumn(sideBidentifiers[j], colmds[i]);
                    sideButilised[j] = true;
                    continue block5;
                }
            }
            for (i = colmds.length; i < mappingSideB.getNumberOfColumnMappings(); ++i) {
                DatastoreIdentifier sideBidentifier = null;
                for (int j = 0; j < sideBidentifiers.length; ++j) {
                    if (sideButilised[j]) continue;
                    sideBidentifier = sideBidentifiers[j];
                    sideButilised[j] = true;
                    break;
                }
                if (sideBidentifier == null) {
                    throw new NucleusUserException(Localiser.msg((String)"020005", (Object[])new Object[]{this.columnsName, "" + i})).setFatal();
                }
                ColumnMetaData colmd = new ColumnMetaData();
                if (updateContainer) {
                    columnContainer.addColumn(colmd);
                }
                this.putColumn(sideBidentifier, colmd);
            }
        } else {
            this.columnsName = null;
            for (int i = 0; i < mappingSideB.getNumberOfColumnMappings(); ++i) {
                DatastoreIdentifier sideBidentifier = mappingSideB.getColumnMapping(i).getColumn().getIdentifier();
                ColumnMetaData colmd = new ColumnMetaData();
                this.putColumn(sideBidentifier, colmd);
            }
        }
    }

    public CorrespondentColumnsMapper(ColumnMetaDataContainer columnContainer, Table tableA, JavaTypeMapping mappingSideB, boolean updateContainer) {
        if (columnContainer != null) {
            int i;
            int noOfUserColumns = columnContainer.getColumnMetaData().length;
            ColumnMetaData[] colmds = columnContainer.getColumnMetaData();
            StringBuilder str = new StringBuilder("Columns [");
            for (int i2 = 0; i2 < noOfUserColumns; ++i2) {
                str.append(colmds[i2].getName());
                if (i2 >= noOfUserColumns - 1) continue;
                str.append(", ");
            }
            str.append("]");
            this.columnsName = str.toString();
            if (noOfUserColumns > mappingSideB.getNumberOfColumnMappings()) {
                throw new NucleusUserException(Localiser.msg((String)"020003", (Object[])new Object[]{this.columnsName, "" + noOfUserColumns, "" + mappingSideB.getNumberOfColumnMappings()})).setFatal();
            }
            DatastoreIdentifier[] sideBidentifiers = new DatastoreIdentifier[mappingSideB.getNumberOfColumnMappings()];
            boolean[] sideButilised = new boolean[mappingSideB.getNumberOfColumnMappings()];
            for (int i3 = 0; i3 < mappingSideB.getNumberOfColumnMappings(); ++i3) {
                sideBidentifiers[i3] = mappingSideB.getColumnMapping(i3).getColumn().getIdentifier();
                sideButilised[i3] = false;
            }
            JavaTypeMapping[] sideBidMappings = ((MultiMapping)mappingSideB).getJavaTypeMapping();
            for (i = 0; i < noOfUserColumns; ++i) {
                int j;
                String targetFieldName;
                String targetColumnName = colmds[i].getTarget();
                if (targetColumnName == null && (targetFieldName = colmds[i].getTargetMember()) != null) {
                    for (j = 0; j < sideBidMappings.length; ++j) {
                        if (!sideBidMappings[j].getMemberMetaData().getName().equals(targetFieldName)) continue;
                        targetColumnName = sideBidMappings[j].getColumnMapping(0).getColumn().getIdentifier().getName();
                        break;
                    }
                }
                if (targetColumnName == null) continue;
                boolean targetExists = false;
                for (j = 0; j < sideBidentifiers.length; ++j) {
                    if (!sideBidentifiers[j].getName().equalsIgnoreCase(targetColumnName) || sideButilised[j]) continue;
                    this.putColumn(sideBidentifiers[j], colmds[i]);
                    sideButilised[j] = true;
                    targetExists = true;
                    break;
                }
                if (targetExists) continue;
                throw new NucleusUserException(Localiser.msg((String)"020004", (Object[])new Object[]{tableA, colmds[i].getName(), targetColumnName, mappingSideB.getTable(), mappingSideB})).setFatal();
            }
            block5: for (i = 0; i < colmds.length; ++i) {
                if (colmds[i].getTarget() != null) continue;
                for (int j = 0; j < sideBidentifiers.length; ++j) {
                    if (sideButilised[j]) continue;
                    this.putColumn(sideBidentifiers[j], colmds[i]);
                    sideButilised[j] = true;
                    continue block5;
                }
            }
            for (i = colmds.length; i < mappingSideB.getNumberOfColumnMappings(); ++i) {
                DatastoreIdentifier sideBidentifier = null;
                for (int j = 0; j < sideBidentifiers.length; ++j) {
                    if (sideButilised[j]) continue;
                    sideBidentifier = sideBidentifiers[j];
                    sideButilised[j] = true;
                    break;
                }
                if (sideBidentifier == null) {
                    throw new NucleusUserException(Localiser.msg((String)"020005", (Object[])new Object[]{this.columnsName, "" + i})).setFatal();
                }
                ColumnMetaData colmd = new ColumnMetaData();
                if (updateContainer) {
                    columnContainer.addColumn(colmd);
                }
                this.putColumn(sideBidentifier, colmd);
            }
        } else {
            this.columnsName = null;
            for (int i = 0; i < mappingSideB.getNumberOfColumnMappings(); ++i) {
                DatastoreIdentifier sideBidentifier = mappingSideB.getColumnMapping(i).getColumn().getIdentifier();
                ColumnMetaData colmd = new ColumnMetaData();
                this.putColumn(sideBidentifier, colmd);
            }
        }
    }

    public ColumnMetaData getColumnMetaDataByIdentifier(DatastoreIdentifier name) {
        return this.columnMetaDataBySideBIdentifier.get(name);
    }

    private void putColumn(DatastoreIdentifier identifier, ColumnMetaData colmd) {
        if (this.columnMetaDataBySideBIdentifier.put(identifier, colmd) != null) {
            throw new NucleusUserException(Localiser.msg((String)"020006", (Object[])new Object[]{identifier, this.columnsName})).setFatal();
        }
    }
}

