/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.tezplugins.metrics;

import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.llap.impl.LlapManagementProtocolClientImpl;
import org.apache.hadoop.hive.llap.registry.LlapServiceInstance;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.net.NetUtils;

public class LlapManagementProtocolClientImplFactory {
    private final Configuration conf;
    private final RetryPolicy retryPolicy;
    private final SocketFactory socketFactory;

    public LlapManagementProtocolClientImplFactory(Configuration conf, RetryPolicy retryPolicy, SocketFactory socketFactory) {
        this.conf = conf;
        this.retryPolicy = retryPolicy;
        this.socketFactory = socketFactory;
    }

    public static LlapManagementProtocolClientImplFactory basicInstance(Configuration conf) {
        return new LlapManagementProtocolClientImplFactory(conf, RetryPolicies.retryUpToMaximumCountWithFixedSleep((int)5, (long)3000L, (TimeUnit)TimeUnit.MILLISECONDS), NetUtils.getDefaultSocketFactory((Configuration)conf));
    }

    public LlapManagementProtocolClientImpl create(LlapServiceInstance serviceInstance) {
        return new LlapManagementProtocolClientImpl(this.conf, serviceInstance.getHost(), serviceInstance.getManagementPort(), this.retryPolicy, this.socketFactory);
    }
}

