/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.model.instance;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import org.apache.atlas.model.PList;
import org.apache.atlas.model.SearchFilter;
import org.apache.atlas.model.glossary.relations.AtlasTermAssignmentHeader;
import org.apache.atlas.model.instance.AtlasClassification;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasStruct;
import org.apache.atlas.model.typedef.AtlasBaseTypeDef;
import org.apache.atlas.model.typedef.AtlasEntityDef;
import org.apache.commons.collections.CollectionUtils;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class AtlasEntityHeader
extends AtlasStruct
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String guid = null;
    private AtlasEntity.Status status = AtlasEntity.Status.ACTIVE;
    private String displayText = null;
    private List<String> classificationNames = null;
    private List<AtlasClassification> classifications = null;
    private List<String> meaningNames = null;
    private List<AtlasTermAssignmentHeader> meanings = null;
    private Boolean isIncomplete = Boolean.FALSE;
    private Set<String> labels = null;

    public AtlasEntityHeader() {
        this(null, null);
    }

    public AtlasEntityHeader(String typeName) {
        this(typeName, null);
    }

    public AtlasEntityHeader(AtlasEntityDef entityDef) {
        this(entityDef != null ? entityDef.getName() : null, null);
    }

    public AtlasEntityHeader(String typeName, Map<String, Object> attributes) {
        super(typeName, attributes);
        this.setClassificationNames(null);
        this.setClassifications(null);
        this.setLabels(null);
    }

    public AtlasEntityHeader(String typeName, String guid, Map<String, Object> attributes) {
        super(typeName, attributes);
        this.setGuid(guid);
        this.setClassificationNames(null);
        this.setClassifications(null);
        this.setLabels(null);
    }

    public AtlasEntityHeader(AtlasEntityHeader other) {
        super(other);
        if (other != null) {
            this.setGuid(other.getGuid());
            this.setStatus(other.getStatus());
            this.setDisplayText(other.getDisplayText());
            this.setClassificationNames(other.getClassificationNames());
            this.setClassifications(other.getClassifications());
            this.setIsIncomplete(other.getIsIncomplete());
            this.setLabels(other.getLabels());
        }
    }

    public AtlasEntityHeader(AtlasEntity entity) {
        super(entity.getTypeName(), entity.getAttributes());
        this.setGuid(entity.getGuid());
        this.setStatus(entity.getStatus());
        this.setClassifications(entity.getClassifications());
        this.setIsIncomplete(entity.getIsIncomplete());
        if (CollectionUtils.isNotEmpty(entity.getClassifications())) {
            this.classificationNames = new ArrayList<String>(entity.getClassifications().size());
            for (AtlasClassification classification : entity.getClassifications()) {
                this.classificationNames.add(classification.getTypeName());
            }
        }
        if (CollectionUtils.isNotEmpty(entity.getLabels())) {
            this.setLabels(entity.getLabels());
        }
    }

    public String getGuid() {
        return this.guid;
    }

    public void setGuid(String guid) {
        this.guid = guid;
    }

    public AtlasEntity.Status getStatus() {
        return this.status;
    }

    public void setStatus(AtlasEntity.Status status) {
        this.status = status;
    }

    public String getDisplayText() {
        return this.displayText;
    }

    public void setDisplayText(String displayText) {
        this.displayText = displayText;
    }

    public List<String> getClassificationNames() {
        return this.classificationNames;
    }

    public void setClassificationNames(List<String> classificationNames) {
        this.classificationNames = classificationNames;
    }

    public List<AtlasClassification> getClassifications() {
        return this.classifications;
    }

    public void setClassifications(List<AtlasClassification> classifications) {
        this.classifications = classifications;
    }

    public Set<String> getLabels() {
        return this.labels;
    }

    public void setLabels(Set<String> labels) {
        this.labels = labels;
    }

    public Boolean getIsIncomplete() {
        return this.isIncomplete;
    }

    public void setIsIncomplete(Boolean isIncomplete) {
        this.isIncomplete = isIncomplete;
    }

    @Override
    public StringBuilder toString(StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        sb.append("AtlasEntityHeader{");
        sb.append("guid='").append(this.guid).append('\'');
        sb.append(", status=").append((Object)this.status);
        sb.append(", displayText=").append(this.displayText);
        sb.append(", classificationNames=[");
        AtlasEntityHeader.dumpObjects(this.classificationNames, sb);
        sb.append("], ");
        sb.append("classifications=[");
        AtlasBaseTypeDef.dumpObjects(this.classifications, sb);
        sb.append("], ");
        sb.append("labels=[");
        AtlasEntityHeader.dumpObjects(this.labels, sb);
        sb.append("], ");
        sb.append("isIncomplete=").append(this.isIncomplete);
        super.toString(sb);
        sb.append('}');
        return sb;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AtlasEntityHeader that = (AtlasEntityHeader)o;
        return Objects.equals(this.guid, that.guid) && this.status == that.status && Objects.equals(this.displayText, that.displayText) && Objects.equals(this.classificationNames, that.classificationNames) && Objects.equals(this.meaningNames, that.classificationNames) && Objects.equals(this.classifications, that.classifications) && Objects.equals(this.labels, that.labels) && Objects.equals(this.isIncomplete, that.isIncomplete) && Objects.equals(this.meanings, that.meanings);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.guid, this.status, this.displayText, this.classificationNames, this.classifications, this.meaningNames, this.meanings, this.isIncomplete, this.labels});
    }

    @Override
    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }

    public List<String> getMeaningNames() {
        return this.meaningNames;
    }

    public void setMeaningNames(List<String> meaningNames) {
        this.meaningNames = meaningNames;
    }

    public List<AtlasTermAssignmentHeader> getMeanings() {
        return this.meanings;
    }

    public void setMeanings(List<AtlasTermAssignmentHeader> meanings) {
        this.meanings = meanings;
    }

    @JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    @XmlSeeAlso(value={AtlasEntity.class})
    public static class AtlasEntityHeaders
    extends PList<AtlasEntityHeader> {
        private static final long serialVersionUID = 1L;

        public AtlasEntityHeaders() {
        }

        public AtlasEntityHeaders(List<AtlasEntityHeader> list) {
            super(list);
        }

        public AtlasEntityHeaders(List list, long startIndex, int pageSize, long totalCount, SearchFilter.SortType sortType, String sortBy) {
            super(list, startIndex, pageSize, totalCount, sortType, sortBy);
        }
    }
}

