/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.state.LifeCycleState;
import org.datanucleus.state.RelationshipManager;
import org.datanucleus.state.RelationshipManagerImpl;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class ManagedRelationsHandler {
    private boolean performChecks = false;
    private boolean executing = false;
    private Map<DNStateManager, RelationshipManager> managedRelationDetails = null;

    public ManagedRelationsHandler(boolean performChecks) {
        this.performChecks = performChecks;
        this.managedRelationDetails = new ConcurrentHashMap<DNStateManager, RelationshipManager>();
    }

    public void setPerformChecks(boolean checks) {
        this.performChecks = checks;
    }

    public RelationshipManager getRelationshipManagerForStateManager(DNStateManager sm) {
        RelationshipManager relMgr = this.managedRelationDetails.get(sm);
        if (relMgr == null) {
            relMgr = new RelationshipManagerImpl(sm);
            this.managedRelationDetails.put(sm, relMgr);
        }
        return relMgr;
    }

    public void clear() {
        this.managedRelationDetails.clear();
    }

    public boolean isExecuting() {
        return this.executing;
    }

    public void addRelationshipManagerForStateManager(DNStateManager sm, RelationshipManager relMgr) {
        this.managedRelationDetails.put(sm, relMgr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        if (this.managedRelationDetails.isEmpty()) {
            return;
        }
        try {
            LifeCycleState lc;
            DNStateManager sm;
            this.executing = true;
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(Localiser.msg("013000"));
            }
            if (this.performChecks) {
                for (Map.Entry<DNStateManager, RelationshipManager> managedRelEntry : this.managedRelationDetails.entrySet()) {
                    sm = managedRelEntry.getKey();
                    lc = sm.getLifecycleState();
                    if (lc == null || lc.isDeleted()) continue;
                    managedRelEntry.getValue().checkConsistency();
                }
            }
            for (Map.Entry<DNStateManager, RelationshipManager> managedRelEntry : this.managedRelationDetails.entrySet()) {
                sm = managedRelEntry.getKey();
                lc = sm.getLifecycleState();
                if (lc == null || lc.isDeleted()) continue;
                RelationshipManager relMgr = managedRelEntry.getValue();
                relMgr.process();
                relMgr.clearFields();
            }
            this.managedRelationDetails.clear();
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(Localiser.msg("013001"));
            }
        }
        finally {
            this.executing = false;
        }
    }
}

