/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.properties;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.TreeMap;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.hadoop.hive.metastore.properties.Digester;
import org.apache.hadoop.hive.metastore.properties.PropertySchema;
import org.apache.hadoop.hive.metastore.properties.PropertyType;
import org.apache.hadoop.hive.metastore.properties.SerializationProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyMap
implements Serializable {
    public static final Logger LOGGER;
    private static final long serialVersionUID = 202212291759L;
    protected final transient PropertySchema schema;
    protected volatile transient UUID digest;
    protected transient Map<String, Object> properties;
    protected transient boolean dirty;
    static final UUID DROPPED;

    PropertyMap(PropertySchema schema) {
        this.schema = schema == null ? PropertySchema.NONE : schema;
        this.properties = Collections.emptyMap();
        this.dirty = false;
    }

    private PropertyMap(PropertyMap src) {
        this.schema = src.schema;
        this.properties = src.properties;
        this.digest = src.digest;
        this.dirty = false;
    }

    public PropertyMap(PropertyMap src, Map<String, Object> input) {
        this.schema = src.schema;
        this.properties = Collections.emptyMap();
        input.forEach((? super K k, ? super V v) -> {
            try {
                this.putProperty((String)k, v);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        });
        this.dirty = false;
    }

    PropertyMap(PropertySchema schema, UUID digest) {
        this(schema);
        this.digest = digest;
    }

    public PropertyMap(DataInput input, Function<String, PropertySchema> getSchema) throws IOException {
        long serial = input.readLong();
        if (serial != 202212291759L) {
            throw new InvalidObjectException("serial mismatch");
        }
        String schemaName = input.readUTF();
        int schemaVersion = input.readInt();
        this.schema = PropertyMap.fetchSchema(schemaName, getSchema);
        this.properties = new TreeMap<String, Object>();
        this.dirty = false;
        int size = input.readInt();
        for (int p = 0; p < size; ++p) {
            Object value;
            String name = input.readUTF();
            PropertyType<Object> type = this.schema.getPropertyType(name);
            if (type == null) {
                LOGGER.warn(this.schema.getName() + ": unsolvable property type for " + name);
                type = PropertyType.STRING;
            }
            if ((value = type.read(input)) != null) {
                this.properties.put(name, value);
                continue;
            }
            if (this.schema.getVersionNumber() <= schemaVersion) continue;
            this.dirty = true;
        }
    }

    private static PropertySchema fetchSchema(String schemaName, Function<String, PropertySchema> getSchema) {
        PropertySchema schema;
        PropertySchema propertySchema = schema = getSchema != null ? getSchema.apply(schemaName) : null;
        if (schema == null) {
            LOGGER.warn("unsolvable schema " + schemaName);
            return PropertySchema.NONE;
        }
        if (!schema.getName().equals(schemaName)) {
            LOGGER.warn("potential schema mismatch, expected " + schema.getName() + ", got " + schemaName);
        }
        return schema;
    }

    public void write(DataOutput out) throws IOException {
        out.writeLong(202212291759L);
        out.writeUTF(this.schema.getName());
        out.writeInt(this.schema.getVersionNumber());
        int size = this.properties.size();
        out.writeInt(size);
        for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
            String name = entry.getKey();
            out.writeUTF(name);
            PropertyType<?> type = this.schema.getPropertyType(name);
            type.write(out, entry.getValue());
        }
    }

    private Object writeReplace() throws ObjectStreamException {
        return new SerializationProxy<PropertyMap>(this);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        throw new InvalidObjectException("proxy required");
    }

    public int size() {
        return this.properties.size();
    }

    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setClean() {
        this.dirty = false;
    }

    public boolean isDropped() {
        return Objects.equals(DROPPED, this.digest);
    }

    public PropertyMap copy() {
        return new PropertyMap(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertyMap that = (PropertyMap)o;
        if (!Objects.equals(this.getDigest(), that.getDigest())) {
            return false;
        }
        return Objects.equals(this.schema, that.schema);
    }

    public int hashCode() {
        int result = this.getDigest().hashCode();
        result = 31 * result + (this.schema != null ? this.schema.hashCode() : 0);
        return result;
    }

    protected PropertyType<?> getTypeOf(String name) {
        return this.schema.getPropertyType(name);
    }

    public void exportToProperties(Properties javap) {
        this.forEach((k, v) -> javap.setProperty((String)k, this.getTypeOf((String)k).format(v)));
    }

    public void importFromProperties(Properties javap) {
        javap.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> this.putProperty(k.toString(), v)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UUID getDigest() {
        UUID uuid = this.digest;
        if (uuid == null) {
            Map<String, Object> map;
            Map<String, Object> map2 = map = this.properties;
            synchronized (map2) {
                uuid = this.digest;
                if (uuid == null) {
                    Digester digester = new Digester();
                    map.forEach((? super K k, ? super V v) -> {
                        digester.digest((String)k);
                        digester.digest(v);
                    });
                    uuid = this.digest = digester.getUUID();
                }
            }
        }
        return uuid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object putProperty(String name, Object value) {
        Map<String, Object> map;
        Map<String, Object> map2;
        PropertyType<?> type = this.getTypeOf(name);
        if (type == null) {
            throw new IllegalArgumentException("property " + name + " is not declared");
        }
        Object validated = type.cast(value);
        if (validated == null) {
            throw new IllegalArgumentException("property " + name + ", type " + type.getName() + ", " + value);
        }
        if (!this.dirty) {
            map = map2 = this.properties;
            synchronized (map) {
                this.properties = new TreeMap<String, Object>(map2);
                this.dirty = true;
            }
        }
        map = map2 = this.properties;
        synchronized (map) {
            this.digest = null;
            return map2.put(name, validated);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object removeProperty(String name) {
        Map<String, Object> map;
        Map<String, Object> map2;
        if (!this.dirty) {
            map = map2 = this.properties;
            synchronized (map) {
                if (!map2.containsKey(name)) {
                    return null;
                }
                this.properties = new TreeMap<String, Object>(map2);
                this.dirty = true;
            }
        }
        map = map2 = this.properties;
        synchronized (map) {
            Object value = map2.remove(name);
            if (value != null) {
                this.digest = null;
            }
            return value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getProperty(String name) {
        Map<String, Object> map;
        Map<String, Object> map2 = map = this.properties;
        synchronized (map2) {
            return map.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getPropertyValue(String name) {
        Map<String, Object> map;
        Map<String, Object> map2 = map = this.properties;
        synchronized (map2) {
            return map.getOrDefault(name, this.schema.getDefaultValue(name));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEach(BiConsumer<? super String, Object> action) {
        Map<String, Object> map;
        Map<String, Object> map2 = map = this.properties;
        synchronized (map2) {
            map.forEach(action);
        }
    }

    public Map<String, String> export() {
        return this.export(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> export(boolean withDefaults) {
        Map<String, Object> valueMap;
        TreeMap<String, String> map = new TreeMap<String, String>();
        Map<String, PropertyType<?>> schemaMap = this.schema.properties;
        Map<String, Object> map2 = valueMap = this.properties;
        synchronized (map2) {
            for (Map.Entry<String, PropertyType<?>> entry : schemaMap.entrySet()) {
                String pname = entry.getKey();
                Object value = withDefaults ? valueMap.getOrDefault(pname, this.schema.getDefaultValue(pname)) : valueMap.get(pname);
                if (value == null) continue;
                map.put(pname, entry.getValue().format(value));
            }
        }
        return map.isEmpty() ? Collections.emptyMap() : map;
    }

    static {
        SerializationProxy.registerType(0, PropertyMap.class);
        LOGGER = LoggerFactory.getLogger(PropertyMap.class);
        DROPPED = new Digester().digest(PropertyMap.class.getName()).digest("dropped").getUUID();
    }
}

