/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import javax.security.sasl.AuthenticationException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.MetaStoreAnonymousAuthenticationProviderImpl;
import org.apache.hadoop.hive.metastore.MetaStoreConfigAuthenticationProviderImpl;
import org.apache.hadoop.hive.metastore.MetaStoreCustomAuthenticationProviderImpl;
import org.apache.hadoop.hive.metastore.MetaStoreLdapAuthenticationProviderImpl;
import org.apache.hadoop.hive.metastore.MetaStorePasswdAuthenticationProvider;

public final class MetaStoreAuthenticationProviderFactory {
    private MetaStoreAuthenticationProviderFactory() {
    }

    public static MetaStorePasswdAuthenticationProvider getAuthenticationProvider(AuthMethods authMethod) throws AuthenticationException {
        return MetaStoreAuthenticationProviderFactory.getAuthenticationProvider(new Configuration(), authMethod);
    }

    public static MetaStorePasswdAuthenticationProvider getAuthenticationProvider(Configuration conf, AuthMethods authMethod) throws AuthenticationException {
        if (authMethod == AuthMethods.LDAP) {
            return new MetaStoreLdapAuthenticationProviderImpl(conf);
        }
        if (authMethod == AuthMethods.CUSTOM) {
            return new MetaStoreCustomAuthenticationProviderImpl(conf);
        }
        if (authMethod == AuthMethods.CONFIG) {
            return new MetaStoreConfigAuthenticationProviderImpl(conf);
        }
        if (authMethod == AuthMethods.NONE) {
            return new MetaStoreAnonymousAuthenticationProviderImpl();
        }
        throw new AuthenticationException("Unsupported authentication method");
    }

    public static enum AuthMethods {
        LDAP("LDAP"),
        PAM("PAM"),
        CUSTOM("CUSTOM"),
        NONE("NONE"),
        CONFIG("CONFIG");

        private final String authMethod;

        private AuthMethods(String authMethod) {
            this.authMethod = authMethod;
        }

        public String getAuthMethod() {
            return this.authMethod;
        }

        public static AuthMethods getValidAuthMethod(String authMethodStr) throws AuthenticationException {
            for (AuthMethods auth : AuthMethods.values()) {
                if (!authMethodStr.equals(auth.getAuthMethod())) continue;
                return auth;
            }
            throw new AuthenticationException("Not a valid authentication method");
        }
    }
}

