/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.jdbc;

import java.sql.DataTruncation;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLTimeoutException;
import java.sql.SQLTransientConnectionException;
import java.sql.SQLWarning;
import java.util.Map;
import java.util.Objects;
import org.apache.iceberg.BaseMetastoreTableOperations;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.exceptions.NoSuchNamespaceException;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.jdbc.JdbcClientPool;
import org.apache.iceberg.jdbc.JdbcUtil;
import org.apache.iceberg.jdbc.UncheckedInterruptedException;
import org.apache.iceberg.jdbc.UncheckedSQLException;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.util.PropertyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JdbcTableOperations
extends BaseMetastoreTableOperations {
    private static final Logger LOG = LoggerFactory.getLogger(JdbcTableOperations.class);
    private final String catalogName;
    private final TableIdentifier tableIdentifier;
    private final FileIO fileIO;
    private final JdbcClientPool connections;
    private final Map<String, String> catalogProperties;
    private final JdbcUtil.SchemaVersion schemaVersion;

    protected JdbcTableOperations(JdbcClientPool dbConnPool, FileIO fileIO, String catalogName, TableIdentifier tableIdentifier, Map<String, String> catalogProperties, JdbcUtil.SchemaVersion schemaVersion) {
        this.catalogName = catalogName;
        this.tableIdentifier = tableIdentifier;
        this.fileIO = fileIO;
        this.connections = dbConnPool;
        this.catalogProperties = catalogProperties;
        this.schemaVersion = schemaVersion;
    }

    @Override
    public void doRefresh() {
        Map<String, String> table;
        try {
            table = JdbcUtil.loadTable(this.schemaVersion, this.connections, this.catalogName, this.tableIdentifier);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UncheckedInterruptedException(e, "Interrupted during refresh", new Object[0]);
        }
        catch (SQLException e) {
            throw new UncheckedSQLException(e, "Failed to get table %s from catalog %s", this.tableIdentifier, this.catalogName);
        }
        if (table.isEmpty()) {
            if (this.currentMetadataLocation() != null) {
                throw new NoSuchTableException("Failed to load table %s from catalog %s: dropped by another process", this.tableIdentifier, this.catalogName);
            }
            this.disableRefresh();
            return;
        }
        String newMetadataLocation = table.get("metadata_location");
        Preconditions.checkState(newMetadataLocation != null, "Invalid table %s: metadata location is null", (Object)this.tableIdentifier);
        this.refreshFromMetadataLocation(newMetadataLocation);
    }

    @Override
    public void doCommit(TableMetadata base, TableMetadata metadata) {
        boolean newTable = base == null;
        String newMetadataLocation = this.writeNewMetadataIfRequired(newTable, metadata);
        try {
            Map<String, String> table = JdbcUtil.loadTable(this.schemaVersion, this.connections, this.catalogName, this.tableIdentifier);
            if (base != null) {
                this.validateMetadataLocation(table, base);
                String oldMetadataLocation = base.metadataFileLocation();
                LOG.debug("Committing existing table: {}", (Object)this.tableName());
                this.updateTable(newMetadataLocation, oldMetadataLocation);
            } else {
                LOG.debug("Committing new table: {}", (Object)this.tableName());
                this.createTable(newMetadataLocation);
            }
        }
        catch (SQLIntegrityConstraintViolationException e) {
            if (this.currentMetadataLocation() == null) {
                throw new AlreadyExistsException(e, "Table already exists: %s", this.tableIdentifier);
            }
            throw new UncheckedSQLException(e, "Table already exists: %s", this.tableIdentifier);
        }
        catch (SQLTimeoutException e) {
            throw new UncheckedSQLException(e, "Database Connection timeout", new Object[0]);
        }
        catch (SQLNonTransientConnectionException | SQLTransientConnectionException e) {
            throw new UncheckedSQLException(e, "Database Connection failed", new Object[0]);
        }
        catch (DataTruncation e) {
            throw new UncheckedSQLException(e, "Database data truncation error", new Object[0]);
        }
        catch (SQLWarning e) {
            throw new UncheckedSQLException(e, "Database warning", new Object[0]);
        }
        catch (SQLException e) {
            if (e.getMessage() != null && e.getMessage().contains("constraint failed")) {
                throw new AlreadyExistsException("Table already exists: %s", this.tableIdentifier);
            }
            throw new UncheckedSQLException(e, "Unknown failure", new Object[0]);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UncheckedInterruptedException(e, "Interrupted during commit", new Object[0]);
        }
    }

    private void updateTable(String newMetadataLocation, String oldMetadataLocation) throws SQLException, InterruptedException {
        int updatedRecords = JdbcUtil.updateTable(this.schemaVersion, this.connections, this.catalogName, this.tableIdentifier, newMetadataLocation, oldMetadataLocation);
        if (updatedRecords != 1) {
            throw new CommitFailedException("Failed to update table %s from catalog %s", this.tableIdentifier, this.catalogName);
        }
        LOG.debug("Successfully committed to existing table: {}", (Object)this.tableIdentifier);
    }

    private void createTable(String newMetadataLocation) throws SQLException, InterruptedException {
        Namespace namespace = this.tableIdentifier.namespace();
        if (PropertyUtil.propertyAsBoolean(this.catalogProperties, "jdbc.strict-mode", false) && !JdbcUtil.namespaceExists(this.catalogName, this.connections, namespace)) {
            throw new NoSuchNamespaceException("Cannot create table %s in catalog %s. Namespace %s does not exist", this.tableIdentifier, this.catalogName, namespace);
        }
        if (this.schemaVersion == JdbcUtil.SchemaVersion.V1 && JdbcUtil.viewExists(this.catalogName, this.connections, this.tableIdentifier)) {
            throw new AlreadyExistsException("View with same name already exists: %s", this.tableIdentifier);
        }
        if (JdbcUtil.tableExists(this.schemaVersion, this.catalogName, this.connections, this.tableIdentifier)) {
            throw new AlreadyExistsException("Table already exists: %s", this.tableIdentifier);
        }
        int insertRecord = JdbcUtil.doCommitCreateTable(this.schemaVersion, this.connections, this.catalogName, namespace, this.tableIdentifier, newMetadataLocation);
        if (insertRecord != 1) {
            throw new CommitFailedException("Failed to create table %s in catalog %s", this.tableIdentifier, this.catalogName);
        }
        LOG.debug("Successfully committed to new table: {}", (Object)this.tableIdentifier);
    }

    private void validateMetadataLocation(Map<String, String> table, TableMetadata base) {
        String baseMetadataLocation;
        String catalogMetadataLocation = table.get("metadata_location");
        String string = baseMetadataLocation = base != null ? base.metadataFileLocation() : null;
        if (!Objects.equals(baseMetadataLocation, catalogMetadataLocation)) {
            throw new CommitFailedException("Cannot commit %s: metadata location %s has changed from %s", this.tableIdentifier, baseMetadataLocation, catalogMetadataLocation);
        }
    }

    @Override
    public FileIO io() {
        return this.fileIO;
    }

    @Override
    protected String tableName() {
        return this.tableIdentifier.toString();
    }
}

