/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.common.DynConstructors;
import org.apache.iceberg.io.LocationProvider;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.relocated.com.google.common.hash.HashCode;
import org.apache.iceberg.relocated.com.google.common.hash.HashFunction;
import org.apache.iceberg.relocated.com.google.common.hash.Hashing;
import org.apache.iceberg.util.LocationUtil;
import org.apache.iceberg.util.PropertyUtil;

public class LocationProviders {
    private static final Set<String> DEPRECATED_PROPERTIES = ImmutableSet.of("write.object-storage.path", "write.folder-storage.path");

    private LocationProviders() {
    }

    public static LocationProvider locationsFor(String inputLocation, Map<String, String> properties) {
        String location = LocationUtil.stripTrailingSlash(inputLocation);
        if (properties.containsKey("write.location-provider.impl")) {
            DynConstructors.Ctor ctor;
            String impl = properties.get("write.location-provider.impl");
            try {
                ctor = DynConstructors.builder(LocationProvider.class).impl(impl, String.class, Map.class).impl(impl, new Class[0]).buildChecked();
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException(String.format("Unable to find a constructor for implementation %s of %s. Make sure the implementation is in classpath, and that it either has a public no-arg constructor or a two-arg constructor taking in the string base table location and its property string map.", impl, LocationProvider.class), e);
            }
            try {
                return (LocationProvider)ctor.newInstance(location, properties);
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException(String.format("Provided implementation for dynamic instantiation should implement %s.", LocationProvider.class), e);
            }
        }
        if (PropertyUtil.propertyAsBoolean(properties, "write.object-storage.enabled", false)) {
            return new ObjectStoreLocationProvider(location, properties);
        }
        return new DefaultLocationProvider(location, properties);
    }

    private static String getAndCheckLegacyLocation(Map<String, String> properties, String key) {
        String value = properties.get(key);
        if (value != null && DEPRECATED_PROPERTIES.contains(key)) {
            throw new IllegalArgumentException(String.format("Property '%s' has been deprecated and will be removed in 2.0, use '%s' instead.", key, "write.data.path"));
        }
        return value;
    }

    static class ObjectStoreLocationProvider
    implements LocationProvider {
        private static final HashFunction HASH_FUNC = Hashing.murmur3_32_fixed();
        private static final int HASH_BINARY_STRING_BITS = 20;
        private static final int ENTROPY_DIR_LENGTH = 4;
        private static final int ENTROPY_DIR_DEPTH = 3;
        private final String storageLocation;
        private final String context;
        private final boolean includePartitionPaths;

        ObjectStoreLocationProvider(String tableLocation, Map<String, String> properties) {
            this.storageLocation = LocationUtil.stripTrailingSlash(ObjectStoreLocationProvider.dataLocation(properties, tableLocation));
            this.context = this.storageLocation.startsWith(tableLocation) ? null : ObjectStoreLocationProvider.pathContext(tableLocation);
            this.includePartitionPaths = PropertyUtil.propertyAsBoolean(properties, "write.object-storage.partitioned-paths", true);
        }

        private static String dataLocation(Map<String, String> properties, String tableLocation) {
            String dataLocation = LocationProviders.getAndCheckLegacyLocation(properties, "write.data.path");
            if (dataLocation == null && (dataLocation = LocationProviders.getAndCheckLegacyLocation(properties, "write.object-storage.path")) == null && (dataLocation = LocationProviders.getAndCheckLegacyLocation(properties, "write.folder-storage.path")) == null) {
                dataLocation = String.format("%s/data", tableLocation);
            }
            return dataLocation;
        }

        @Override
        public String newDataLocation(PartitionSpec spec, StructLike partitionData, String filename) {
            if (this.includePartitionPaths) {
                return this.newDataLocation(String.format("%s/%s", spec.partitionToPath(partitionData), filename));
            }
            return this.newDataLocation(filename);
        }

        @Override
        public String newDataLocation(String filename) {
            String hash = this.computeHash(filename);
            if (this.context != null) {
                return String.format("%s/%s/%s/%s", this.storageLocation, hash, this.context, filename);
            }
            if (this.includePartitionPaths) {
                return String.format("%s/%s/%s", this.storageLocation, hash, filename);
            }
            return String.format("%s/%s-%s", this.storageLocation, hash, filename);
        }

        private static String pathContext(String tableLocation) {
            Path dataPath = new Path(tableLocation);
            Path parent = dataPath.getParent();
            String resolvedContext = parent != null ? String.format("%s/%s", parent.getName(), dataPath.getName()) : dataPath.getName();
            Preconditions.checkState(!resolvedContext.endsWith("/"), "Path context must not end with a slash.");
            return resolvedContext;
        }

        private String computeHash(String fileName) {
            HashCode hashCode = HASH_FUNC.hashString(fileName, StandardCharsets.UTF_8);
            String hashAsBinaryString = Integer.toBinaryString(hashCode.asInt() | Integer.MIN_VALUE);
            String hash = hashAsBinaryString.substring(hashAsBinaryString.length() - 20);
            return this.dirsFromHash(hash);
        }

        private String dirsFromHash(String hash) {
            StringBuilder hashWithDirs = new StringBuilder();
            for (int i = 0; i < 12; i += 4) {
                if (i > 0) {
                    hashWithDirs.append("/");
                }
                hashWithDirs.append(hash, i, Math.min(i + 4, hash.length()));
            }
            if (hash.length() > 12) {
                hashWithDirs.append("/").append(hash, 12, hash.length());
            }
            return hashWithDirs.toString();
        }
    }

    static class DefaultLocationProvider
    implements LocationProvider {
        private final String dataLocation;

        DefaultLocationProvider(String tableLocation, Map<String, String> properties) {
            this.dataLocation = LocationUtil.stripTrailingSlash(DefaultLocationProvider.dataLocation(properties, tableLocation));
        }

        private static String dataLocation(Map<String, String> properties, String tableLocation) {
            String dataLocation = LocationProviders.getAndCheckLegacyLocation(properties, "write.data.path");
            if (dataLocation == null && (dataLocation = LocationProviders.getAndCheckLegacyLocation(properties, "write.folder-storage.path")) == null) {
                dataLocation = String.format("%s/data", tableLocation);
            }
            return dataLocation;
        }

        @Override
        public String newDataLocation(PartitionSpec spec, StructLike partitionData, String filename) {
            return String.format("%s/%s/%s", this.dataLocation, spec.partitionToPath(partitionData), filename);
        }

        @Override
        public String newDataLocation(String filename) {
            return String.format("%s/%s", this.dataLocation, filename);
        }
    }
}

