/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.iceberg.org.apache.orc.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.hive.iceberg.org.apache.orc.OrcFilterContext;
import org.apache.hive.iceberg.org.apache.orc.TypeDescription;
import org.apache.hive.iceberg.org.apache.orc.impl.ParserUtils;
import org.apache.hive.iceberg.org.apache.orc.storage.ql.exec.vector.ColumnVector;
import org.apache.hive.iceberg.org.apache.orc.storage.ql.exec.vector.VectorizedRowBatch;
import org.jetbrains.annotations.NotNull;

public class OrcFilterContextImpl
implements OrcFilterContext {
    private VectorizedRowBatch batch = null;
    private final Map<String, ColumnVector[]> vectors;
    private final TypeDescription readSchema;
    private final boolean isSchemaCaseAware;

    public OrcFilterContextImpl(TypeDescription readSchema, boolean isSchemaCaseAware) {
        this.readSchema = readSchema;
        this.isSchemaCaseAware = isSchemaCaseAware;
        this.vectors = new HashMap<String, ColumnVector[]>();
    }

    public OrcFilterContext setBatch(@NotNull VectorizedRowBatch batch) {
        if (batch != this.batch) {
            this.batch = batch;
            this.vectors.clear();
        }
        return this;
    }

    VectorizedRowBatch getBatch() {
        return this.batch;
    }

    @Override
    public void setFilterContext(boolean selectedInUse, int[] selected, int selectedSize) {
        this.batch.setFilterContext(selectedInUse, selected, selectedSize);
    }

    @Override
    public boolean validateSelected() {
        return this.batch.validateSelected();
    }

    @Override
    public int[] updateSelected(int i) {
        return this.batch.updateSelected(i);
    }

    @Override
    public void setSelectedInUse(boolean b) {
        this.batch.setSelectedInUse(b);
    }

    @Override
    public void setSelected(int[] ints) {
        this.batch.setSelected(ints);
    }

    @Override
    public void setSelectedSize(int i) {
        this.batch.setSelectedSize(i);
    }

    @Override
    public void reset() {
        this.batch.reset();
    }

    @Override
    public boolean isSelectedInUse() {
        return this.batch.isSelectedInUse();
    }

    @Override
    public int[] getSelected() {
        return this.batch.getSelected();
    }

    @Override
    public int getSelectedSize() {
        return this.batch.getSelectedSize();
    }

    public ColumnVector[] getCols() {
        return this.batch.cols;
    }

    @Override
    public ColumnVector[] findColumnVector(String name) {
        return this.vectors.computeIfAbsent(name, key -> ParserUtils.findColumnVectors(this.readSchema, new ParserUtils.StringPosition((String)key), this.isSchemaCaseAware, this.batch));
    }
}

