/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.ptf;

import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.hive.ql.exec.PTFPartition;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.PTFInvocationSpec;
import org.apache.hadoop.hive.ql.plan.ptf.BoundaryDef;
import org.apache.hadoop.hive.ql.plan.ptf.OrderDef;
import org.apache.hadoop.hive.ql.plan.ptf.OrderExpressionDef;
import org.apache.hadoop.hive.ql.udf.ptf.BooleanPrimitiveValueBoundaryScanner;
import org.apache.hadoop.hive.ql.udf.ptf.BooleanValueBoundaryScanner;
import org.apache.hadoop.hive.ql.udf.ptf.CharValueBoundaryScanner;
import org.apache.hadoop.hive.ql.udf.ptf.DatePrimitiveValueBoundaryScanner;
import org.apache.hadoop.hive.ql.udf.ptf.DateValueBoundaryScanner;
import org.apache.hadoop.hive.ql.udf.ptf.DoublePrimitiveValueBoundaryScanner;
import org.apache.hadoop.hive.ql.udf.ptf.DoubleValueBoundaryScanner;
import org.apache.hadoop.hive.ql.udf.ptf.HiveDecimalPrimitiveValueBoundaryScanner;
import org.apache.hadoop.hive.ql.udf.ptf.HiveDecimalValueBoundaryScanner;
import org.apache.hadoop.hive.ql.udf.ptf.LongPrimitiveValueBoundaryScanner;
import org.apache.hadoop.hive.ql.udf.ptf.LongValueBoundaryScanner;
import org.apache.hadoop.hive.ql.udf.ptf.StringPrimitiveValueBoundaryScanner;
import org.apache.hadoop.hive.ql.udf.ptf.StringValueBoundaryScanner;
import org.apache.hadoop.hive.ql.udf.ptf.TimestampLocalTZValueBoundaryScanner;
import org.apache.hadoop.hive.ql.udf.ptf.TimestampPrimitiveValueBoundaryScanner;
import org.apache.hadoop.hive.ql.udf.ptf.TimestampValueBoundaryScanner;
import org.apache.hadoop.hive.ql.udf.ptf.ValueBoundaryScanner;
import org.apache.hadoop.hive.ql.udf.ptf.VarcharValueBoundaryScanner;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;

abstract class SingleValueBoundaryScanner
extends ValueBoundaryScanner {
    OrderExpressionDef expressionDef;

    public SingleValueBoundaryScanner(BoundaryDef start, BoundaryDef end, OrderExpressionDef expressionDef, boolean nullsLast) {
        super(start, end, nullsLast);
        this.expressionDef = expressionDef;
    }

    @Override
    public int computeStart(int rowIdx, PTFPartition p) throws HiveException {
        switch (this.start.getDirection()) {
            case PRECEDING: {
                return this.computeStartPreceding(rowIdx, p);
            }
            case CURRENT: {
                return this.computeStartCurrentRow(rowIdx, p);
            }
        }
        return this.computeStartFollowing(rowIdx, p);
    }

    protected int computeStartPreceding(int rowIdx, PTFPartition p) throws HiveException {
        int amt = this.start.getAmt();
        if (amt == Integer.MAX_VALUE) {
            return 0;
        }
        Object sortKey = this.computeValueUseCache(rowIdx, p);
        if (sortKey == null) {
            if (this.nullsLast || this.expressionDef.getOrder() == PTFInvocationSpec.Order.DESC) {
                while (sortKey == null && rowIdx >= 0) {
                    Pair<Integer, Object> stepResult = this.skipOrStepBack(rowIdx, p);
                    rowIdx = (Integer)stepResult.getLeft();
                    sortKey = stepResult.getRight();
                }
                return rowIdx + 1;
            }
            if (this.expressionDef.getOrder() == PTFInvocationSpec.Order.ASC) {
                return 0;
            }
        }
        if (this.enableBinarySearch) {
            return this.binarySearchBack(rowIdx, p, sortKey, amt, this.expressionDef.getOrder());
        }
        return this.linearSearchBack(rowIdx, p, sortKey, amt, this.expressionDef.getOrder());
    }

    protected int computeStartCurrentRow(int rowIdx, PTFPartition p) throws HiveException {
        Object sortKey = this.computeValueUseCache(rowIdx, p);
        if (sortKey == null) {
            while (sortKey == null && rowIdx >= 0) {
                Pair<Integer, Object> stepResult = this.skipOrStepBack(rowIdx, p);
                rowIdx = (Integer)stepResult.getLeft();
                sortKey = stepResult.getRight();
            }
            return rowIdx + 1;
        }
        Object rowVal = sortKey;
        int r = rowIdx;
        while (r >= 0 && this.isEqual(rowVal, sortKey)) {
            Pair<Integer, Object> stepResult = this.skipOrStepBack(r, p);
            r = (Integer)stepResult.getLeft();
            rowVal = stepResult.getRight();
        }
        return r + 1;
    }

    protected int computeStartFollowing(int rowIdx, PTFPartition p) throws HiveException {
        Object sortKey;
        int amt = this.start.getAmt();
        Object rowVal = sortKey = this.computeValueUseCache(rowIdx, p);
        if (sortKey == null) {
            if (this.nullsLast || this.expressionDef.getOrder() == PTFInvocationSpec.Order.DESC) {
                return p.size();
            }
            while (rowIdx < p.size() && rowVal == null) {
                Pair<Integer, Object> stepResult = this.skipOrStepForward(rowIdx, p);
                rowIdx = (Integer)stepResult.getLeft();
                rowVal = stepResult.getRight();
            }
            return rowIdx;
        }
        if (this.enableBinarySearch) {
            return this.binarySearchForward(rowIdx, p, sortKey, amt, this.expressionDef.getOrder());
        }
        return this.linearSearchForward(rowIdx, p, sortKey, amt, this.expressionDef.getOrder());
    }

    @Override
    public int computeEnd(int rowIdx, PTFPartition p) throws HiveException {
        switch (this.end.getDirection()) {
            case PRECEDING: {
                return this.computeEndPreceding(rowIdx, p);
            }
            case CURRENT: {
                return this.computeEndCurrentRow(rowIdx, p);
            }
        }
        return this.computeEndFollowing(rowIdx, p);
    }

    protected int computeEndPreceding(int rowIdx, PTFPartition p) throws HiveException {
        int amt = this.end.getAmt();
        Object sortKey = this.computeValueUseCache(rowIdx, p);
        if (sortKey == null) {
            if (this.nullsLast || this.expressionDef.getOrder() == PTFInvocationSpec.Order.DESC) {
                return p.size();
            }
            return 0;
        }
        int r = rowIdx;
        if (this.enableBinarySearch) {
            return this.binarySearchBack(r, p, sortKey, amt, this.expressionDef.getOrder());
        }
        return this.linearSearchBack(r, p, sortKey, amt, this.expressionDef.getOrder());
    }

    protected int computeEndCurrentRow(int rowIdx, PTFPartition p) throws HiveException {
        Object sortKey = this.computeValueUseCache(rowIdx, p);
        if (sortKey == null) {
            while (sortKey == null && rowIdx < p.size()) {
                Pair<Integer, Object> stepResult = this.skipOrStepForward(rowIdx, p);
                rowIdx = (Integer)stepResult.getLeft();
                sortKey = stepResult.getRight();
            }
            return rowIdx;
        }
        Object rowVal = sortKey;
        int r = rowIdx;
        while (r < p.size() && this.isEqual(sortKey, rowVal)) {
            Pair<Integer, Object> stepResult = this.skipOrStepForward(r, p);
            r = (Integer)stepResult.getLeft();
            rowVal = stepResult.getRight();
        }
        return r;
    }

    protected int computeEndFollowing(int rowIdx, PTFPartition p) throws HiveException {
        Object sortKey;
        int amt = this.end.getAmt();
        if (amt == Integer.MAX_VALUE) {
            return p.size();
        }
        Object rowVal = sortKey = this.computeValueUseCache(rowIdx, p);
        int r = rowIdx;
        if (sortKey == null) {
            if (this.nullsLast || this.expressionDef.getOrder() == PTFInvocationSpec.Order.DESC) {
                return p.size();
            }
            while (r < p.size() && rowVal == null) {
                Pair<Integer, Object> stepResult = this.skipOrStepForward(r, p);
                r = (Integer)stepResult.getLeft();
                rowVal = stepResult.getRight();
            }
            return r;
        }
        if (this.enableBinarySearch) {
            return this.binarySearchForward(r, p, sortKey, amt, this.expressionDef.getOrder());
        }
        return this.linearSearchForward(r, p, sortKey, amt, this.expressionDef.getOrder());
    }

    @Override
    public Object computeValue(Object row) throws HiveException {
        Object o = this.expressionDef.getExprEvaluator().evaluate(row);
        return ObjectInspectorUtils.copyToStandardObject((Object)o, (ObjectInspector)this.expressionDef.getOI());
    }

    @Override
    public abstract boolean isDistanceGreater(Object var1, Object var2, int var3);

    @Override
    public abstract boolean isEqual(Object var1, Object var2);

    protected int binarySearchBack(int rowId, PTFPartition p, Object sortKey, int amt, PTFInvocationSpec.Order order) throws HiveException {
        boolean isOrderDesc = order.equals((Object)PTFInvocationSpec.Order.DESC);
        Object rowVal = null;
        int rMin = 0;
        int rMax = rowId;
        boolean isDistanceGreater = true;
        while (rMin < rMax) {
            rowVal = this.computeValueUseCache(rowId, p);
            isDistanceGreater = this.isDistanceGreater(isOrderDesc ? rowVal : sortKey, isOrderDesc ? sortKey : rowVal, amt);
            if (isDistanceGreater) {
                rMin = rowId + 1;
            } else {
                rMax = rowId;
            }
            rowId = rMin + (rMax - rMin) / 2;
        }
        return rMin;
    }

    private int linearSearchBack(int r, PTFPartition p, Object sortKey, int amt, PTFInvocationSpec.Order order) throws HiveException {
        boolean isOrderDesc = order.equals((Object)PTFInvocationSpec.Order.DESC);
        Object rowVal = sortKey;
        while (r >= 0 && !this.isDistanceGreater(isOrderDesc ? rowVal : sortKey, isOrderDesc ? sortKey : rowVal, amt)) {
            Pair<Integer, Object> stepResult = this.skipOrStepBack(r, p);
            r = (Integer)stepResult.getLeft();
            rowVal = stepResult.getRight();
        }
        return r + 1;
    }

    protected int binarySearchForward(int rowId, PTFPartition p, Object sortKey, int amt, PTFInvocationSpec.Order order) throws HiveException {
        boolean isOrderDesc = order.equals((Object)PTFInvocationSpec.Order.DESC);
        Object rowVal = null;
        int rMin = rowId;
        int rMax = p.size();
        boolean isDistanceGreater = true;
        while (rMin < rMax) {
            rowVal = this.computeValueUseCache(rowId, p);
            isDistanceGreater = this.isDistanceGreater(isOrderDesc ? sortKey : rowVal, isOrderDesc ? rowVal : sortKey, amt);
            if (isDistanceGreater) {
                rMax = rowId;
            } else {
                rMin = rowId + 1;
            }
            rowId = rMin + (rMax - rMin) / 2;
        }
        return rMin;
    }

    private int linearSearchForward(int r, PTFPartition p, Object sortKey, int amt, PTFInvocationSpec.Order order) throws HiveException {
        boolean isOrderDesc = order.equals((Object)PTFInvocationSpec.Order.DESC);
        Object rowVal = sortKey;
        while (r < p.size() && !this.isDistanceGreater(isOrderDesc ? sortKey : rowVal, isOrderDesc ? rowVal : sortKey, amt)) {
            Pair<Integer, Object> stepResult = this.skipOrStepForward(r, p);
            r = (Integer)stepResult.getLeft();
            rowVal = stepResult.getRight();
        }
        return r;
    }

    public static SingleValueBoundaryScanner getScanner(BoundaryDef start, BoundaryDef end, OrderDef orderDef, boolean nullsLast) throws HiveException {
        if (orderDef.getExpressions().size() != 1) {
            throw new HiveException("Internal error: initializing SingleValueBoundaryScanner with multiple expression for sorting");
        }
        OrderExpressionDef exprDef = orderDef.getExpressions().get(0);
        PrimitiveObjectInspector pOI = (PrimitiveObjectInspector)exprDef.getOI();
        if (pOI != null) {
            PrimitiveObjectInspector.PrimitiveCategory primitiveCategory = pOI.getPrimitiveCategory();
            return SingleValueBoundaryScanner.getBoundaryScanner(start, end, nullsLast, exprDef, primitiveCategory);
        }
        String typeString = exprDef.getExprNode().getTypeInfo().getTypeName();
        return SingleValueBoundaryScanner.getBoundaryScanner(start, end, nullsLast, exprDef, typeString);
    }

    public static SingleValueBoundaryScanner getBoundaryScanner(BoundaryDef start, BoundaryDef end, boolean nullsLast, OrderExpressionDef exprDef, PrimitiveObjectInspector.PrimitiveCategory primitiveCategory) throws HiveException {
        switch (primitiveCategory) {
            case BYTE: 
            case INT: 
            case LONG: 
            case SHORT: {
                return new LongValueBoundaryScanner(start, end, exprDef, nullsLast);
            }
            case TIMESTAMP: {
                return new TimestampValueBoundaryScanner(start, end, exprDef, nullsLast);
            }
            case TIMESTAMPLOCALTZ: {
                return new TimestampLocalTZValueBoundaryScanner(start, end, exprDef, nullsLast);
            }
            case DOUBLE: 
            case FLOAT: {
                return new DoubleValueBoundaryScanner(start, end, exprDef, nullsLast);
            }
            case DECIMAL: {
                return new HiveDecimalValueBoundaryScanner(start, end, exprDef, nullsLast);
            }
            case DATE: {
                return new DateValueBoundaryScanner(start, end, exprDef, nullsLast);
            }
            case STRING: {
                return new StringValueBoundaryScanner(start, end, exprDef, nullsLast);
            }
            case CHAR: {
                return new CharValueBoundaryScanner(start, end, exprDef, nullsLast);
            }
            case VARCHAR: {
                return new VarcharValueBoundaryScanner(start, end, exprDef, nullsLast);
            }
            case BOOLEAN: {
                return new BooleanValueBoundaryScanner(start, end, exprDef, nullsLast);
            }
        }
        throw new HiveException(String.format("Internal Error: attempt to setup a Window for datatype: '%s'", primitiveCategory));
    }

    public static SingleValueBoundaryScanner getBoundaryScanner(BoundaryDef start, BoundaryDef end, boolean nullsLast, OrderExpressionDef exprDef, String typeString) throws HiveException {
        switch (typeString) {
            case "int": 
            case "bigint": 
            case "smallint": 
            case "tinyint": {
                return new LongPrimitiveValueBoundaryScanner(start, end, exprDef, nullsLast);
            }
            case "timestamp": {
                return new TimestampPrimitiveValueBoundaryScanner(start, end, exprDef, nullsLast);
            }
            case "double": 
            case "float": {
                return new DoublePrimitiveValueBoundaryScanner(start, end, exprDef, nullsLast);
            }
            case "date": {
                return new DatePrimitiveValueBoundaryScanner(start, end, exprDef, nullsLast);
            }
            case "string": {
                return new StringPrimitiveValueBoundaryScanner(start, end, exprDef, nullsLast);
            }
            case "boolean": {
                return new BooleanPrimitiveValueBoundaryScanner(start, end, exprDef, nullsLast);
            }
        }
        if (typeString.startsWith("char") || typeString.startsWith("varchar")) {
            return new StringPrimitiveValueBoundaryScanner(start, end, exprDef, nullsLast);
        }
        if (typeString.startsWith("decimal")) {
            return new HiveDecimalPrimitiveValueBoundaryScanner(start, end, exprDef, nullsLast);
        }
        throw new HiveException(String.format("Internal Error: attempt to setup a Window for typeString: '%s'", typeString));
    }
}

