/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedExpressions;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringTrimCol;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringTrimColScalar;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBaseTrim;

@Description(name="trim", value="_FUNC_([LEADING | TRAILING | BOTH] [chars] FROM str) | _FUNC_(str[, chars]) - Removes the leading/trailing or both pad characters from str", extended="Example:\n  > SELECT _FUNC_('   facebook  ') FROM src LIMIT 1;\n  'facebook'\n  > SELECT _FUNC_(BOTH 'xy' FROM 'xyyxFacebookxy');\n  'Facebook'\n  > SELECT _FUNC_(' ' FROM ' Facebook  ');\n  'Facebook'\n  > SELECT _FUNC_(LEADING ' ' FROM ' Facebook  ');\n  'Facebook  '\n  > SELECT _FUNC_('xyfacebookyyx', 'xy');\n  'facebook'")
@VectorizedExpressions(value={StringTrimCol.class, StringTrimColScalar.class})
public class GenericUDFTrim
extends GenericUDFBaseTrim {
    public GenericUDFTrim() {
        super("trim");
    }

    @Override
    protected String performOp(String val, String trimChars) {
        return StringUtils.strip((String)val, (String)trimChars);
    }
}

